/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import java.util.ArrayList;
import java.util.List;
import org.jxls.area.Area;
import org.jxls.command.Command;
import org.jxls.transform.TransformationConfig;
import org.jxls.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommand
implements Command {
    private Logger logger = LoggerFactory.getLogger(AbstractCommand.class);
    List<Area> areaList = new ArrayList<Area>();
    private String shiftMode;

    @Override
    public Command addArea(Area area) {
        this.areaList.add(area);
        area.setParentCommand(this);
        return this;
    }

    @Override
    public void reset() {
        for (Area area : this.areaList) {
            area.reset();
        }
    }

    @Override
    public void setShiftMode(String mode) {
        if (mode != null) {
            if (mode.equalsIgnoreCase("inner") || mode.equalsIgnoreCase("adjacent")) {
                this.shiftMode = mode;
            } else {
                this.logger.error("Cannot set cell shift mode to " + mode + " for command: " + this.getName());
            }
        }
    }

    @Override
    public String getShiftMode() {
        return this.shiftMode;
    }

    @Override
    public List<Area> getAreaList() {
        return this.areaList;
    }

    protected Transformer getTransformer() {
        if (this.areaList.isEmpty()) {
            return null;
        }
        return this.areaList.get(0).getTransformer();
    }

    protected TransformationConfig getTransformationConfig() {
        return this.getTransformer().getTransformationConfig();
    }
}

