/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;

@ChannelHandler.Sharable
public class SmppSessionThreadRenamer
extends ChannelHandlerAdapter
implements ChannelInboundHandler {
    private String threadName;

    public SmppSessionThreadRenamer(String threadName) {
        this.threadName = threadName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String value) {
        this.threadName = value;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.threadName);
        ctx.fireChannelRegistered();
        Thread.currentThread().setName(currentThreadName);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.threadName);
        ctx.fireChannelUnregistered();
        Thread.currentThread().setName(currentThreadName);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.threadName);
        ctx.fireChannelActive();
        Thread.currentThread().setName(currentThreadName);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.threadName);
        ctx.fireChannelInactive();
        Thread.currentThread().setName(currentThreadName);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.threadName);
        ctx.fireChannelRead(msg);
        Thread.currentThread().setName(currentThreadName);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.threadName);
        ctx.fireChannelReadComplete();
        Thread.currentThread().setName(currentThreadName);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.threadName);
        ctx.fireUserEventTriggered(evt);
        Thread.currentThread().setName(currentThreadName);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.threadName);
        ctx.fireChannelWritabilityChanged();
        Thread.currentThread().setName(currentThreadName);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.threadName);
        ctx.fireExceptionCaught(cause);
        Thread.currentThread().setName(currentThreadName);
    }
}

