<TeXmacs|1.0.7.11>

<style|<tuple|tmdoc|maxima>>

<\body>
  <\tmdoc-title>
    Example <name|R> session
  </tmdoc-title>

  In order to launch an <name|R> session inside <TeXmacs>, use
  <menu|Insert|Session|R>. The <verbatim|v()> function can be used in order
  to include the contents of the <name|R> graphics window inside your
  worksheet.

  <\session|r|default>
    <\output>
      \<gtr\> Welcome to the TeXmacs interface to R.

      To put the current graph in the TeXmacs buffer as an eps use v().

      The functions plotv(), linesv(), and pointsv() are provided as a
      convenience.

      They do the regular function, and then insert the graph.

      \;

      To change the size of the graph that is inserted to TeXmacs,just adjust
      the size of the X11 window.
    </output>

    <\unfolded-io|<\with|color|red>
      \<gtr\>\ 
    </with>>
      qnorm(1/2,mean=0,sd=1)
    <|unfolded-io>
      [1] 0
    </unfolded-io>

    <\input|<\with|color|red>
      \<gtr\>\ 
    </with>>
      x\<less\>-1:100
    </input>

    <\input|<\with|color|red>
      \<gtr\>\ 
    </with>>
      y\<less\>-rnorm(x)
    </input>

    <\input|<\with|color|red>
      \<gtr\>\ 
    </with>>
      plot(x,y)
    </input>

    <\unfolded-io|<\with|color|red>
      \<gtr\>\ 
    </with>>
      v()
    <|unfolded-io>
      <image|<tuple|<#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>|ps>|0.5w|0.5h||>
    </unfolded-io>

    <\input|<\with|color|red>
      \<gtr\>\ 
    </with>>
      plot(x)
    </input>

    <\unfolded-io|<\with|color|red>
      \<gtr\>\ 
    </with>>
      v()
    <|unfolded-io>
      <image|<tuple|<#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>|ps>|0.5w|0.5h||>
    </unfolded-io>

    <\input|<\with|color|red>
      \<gtr\>\ 
    </with>>
      z\<less\>-sort(y)
    </input>

    <\input|<\with|color|red>
      \<gtr\>\ 
    </with>>
      plot(z)
    </input>

    <\unfolded-io|<\with|color|red>
      \<gtr\>\ 
    </with>>
      v()
    <|unfolded-io>
      <image|<tuple|<#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>|ps>|0.5w|0.5h||>
    </unfolded-io>

    <\input|<\with|color|red>
      \<gtr\>\ 
    </with>>
      plot(z,sort(y))
    </input>

    <\unfolded-io|<\with|color|red>
      \<gtr\>\ 
    </with>>
      v()
    <|unfolded-io>
      <image|<tuple|<#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>|ps>|0.5w|0.5h||>
    </unfolded-io>

    <\input|<\with|color|red>
      \<gtr\>\ 
    </with>>
      hist(z)
    </input>

    <\unfolded-io|<\with|color|red>
      \<gtr\>\ 
    </with>>
      v()
    <|unfolded-io>
      <image|<tuple|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|ps>|0.5w|0.5h||>
    </unfolded-io>

    <\unfolded-io|<\with|color|red>
      \<gtr\>\ 
    </with>>
      summary(z)
    <|unfolded-io>
      \ \ \ \ \ Min. \ \ 1st Qu. \ \ \ Median \ \ \ \ \ Mean \ \ 3rd Qu.
      \ \ \ \ \ Max.\ 

      -2.802000 -1.003000 \ 0.007691 -0.040620 \ 0.840500 \ 2.447000\ 
    </unfolded-io>

    <\input|<\with|color|red>
      \<gtr\>\ 
    </with>>
      hist(y,seq(-4,3.5,0.2),prob=TRUE)
    </input>

    <\unfolded-io|<\with|color|red>
      \<gtr\>\ 
    </with>>
      v()
    <|unfolded-io>
      <image|<tuple|<#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>|ps>|0.5w|0.5h||>
    </unfolded-io>

    <\input|<\with|color|red>
      \<gtr\>\ 
    </with>>
      \;
    </input>
  </session>

  <tmdoc-copyright|2003|Chu-Ching Huang|Joris van der Hoeven>

  <tmdoc-license|Permission is granted to copy, distribute and/or modify this
  document under the terms of the GNU Free Documentation License, Version 1.1
  or any later version published by the Free Software Foundation; with no
  Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
  Texts. A copy of the license is included in the section entitled "GNU Free
  Documentation License".>
</body>

<\initial>
  <\collection>
    <associate|language|english>
  </collection>
</initial>