/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DBConnectionSpec;
import ca.sqlpower.sql.StatementClosingPoolableConnectionFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class Pool {
    private static Map pools = new HashMap();
    private static Map objPools = new HashMap();
    private DBConnectionSpec dbcs;
    private String poolName;
    private PoolingDataSource dataSource;
    ObjectPool connectionPool;

    public Pool(DBConnectionSpec dbcs) throws Exception {
        this.dbcs = dbcs;
        this.poolName = dbcs.getUrl() + "-" + dbcs.getUser() + "-" + dbcs.getPass();
        this.dataSource = (PoolingDataSource)pools.get(this.poolName);
        this.connectionPool = (ObjectPool)objPools.get(this.poolName);
        if (this.dataSource == null) {
            GenericObjectPool.Config poolConfig = new GenericObjectPool.Config();
            poolConfig.maxActive = 100;
            poolConfig.maxIdle = 50;
            poolConfig.maxWait = 10000L;
            poolConfig.minEvictableIdleTimeMillis = 300000L;
            poolConfig.timeBetweenEvictionRunsMillis = 10000L;
            poolConfig.numTestsPerEvictionRun = 5;
            poolConfig.testOnBorrow = true;
            this.connectionPool = new GenericObjectPool(null, poolConfig);
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(dbcs.getUrl(), dbcs.getUser(), dbcs.getPass());
            StatementClosingPoolableConnectionFactory poolableConnectionFactory = new StatementClosingPoolableConnectionFactory((ConnectionFactory)connectionFactory, this.connectionPool, null, null, false, true);
            poolableConnectionFactory.setValidationQuery("select 1 from def_param");
            this.dataSource = new PoolingDataSource(this.connectionPool);
            pools.put(this.poolName, this.dataSource);
            objPools.put(this.poolName, this.connectionPool);
        }
    }

    public Connection getConnection() throws SQLException {
        Connection con;
        try {
            con = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            pools.remove(this.poolName);
            objPools.remove(this.poolName);
            throw e;
        }
        return con;
    }
}

