/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.opf.LinkedResource;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class LinkedResources {
    private final List<LinkedResource> resources;
    private final Map<String, LinkedResource> resourcesById;
    private final ListMultimap<String, LinkedResource> resourcesByPath;

    public Optional<LinkedResource> getById(String id) {
        return Optional.fromNullable((Object)this.resourcesById.get(id));
    }

    public List<LinkedResource> getByPath(String path) {
        return this.resourcesByPath.get((Object)path);
    }

    public List<LinkedResource> asList() {
        return this.resources;
    }

    public boolean hasPath(String path) {
        return !this.getByPath(path).isEmpty();
    }

    private LinkedResources(Iterable<LinkedResource> resources) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ImmutableListMultimap.Builder byPathBuilder = ImmutableListMultimap.builder();
        HashMap byIdMap = Maps.newHashMap();
        for (LinkedResource resource : resources) {
            listBuilder.add((Object)resource);
            byPathBuilder.put((Object)resource.getPath(), (Object)resource);
            if (!resource.getId().isPresent()) continue;
            byIdMap.put(resource.getId().get(), resource);
        }
        this.resources = listBuilder.build();
        this.resourcesByPath = byPathBuilder.build();
        this.resourcesById = ImmutableMap.copyOf((Map)byIdMap);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final LinkedHashSet<LinkedResource> resources = Sets.newLinkedHashSet();

        public Builder add(LinkedResource resource) {
            if (resource != null) {
                this.resources.add(resource);
            }
            return this;
        }

        public LinkedResources build() {
            return new LinkedResources(this.resources);
        }
    }
}

