/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementStyle;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.StringUtils;

public final class ImageLibrary {
    private static final Logger logger = Logger.getLogger(ImageLibrary.class.getName());
    public static final Dimension ICON_SIZE = new Dimension(32, 32);
    public static final Dimension BUILDING_SIZE = new Dimension(128, 96);
    public static final Dimension TILE_SIZE = new Dimension(128, 64);
    public static final Dimension TILE_OVERLAY_SIZE = new Dimension(128, 96);
    public static final Dimension TILE_FOREST_SIZE = new Dimension(128, 84);
    public static final String DELETE = "image.miscicon.delete";
    public static final String PLOWED = "image.tile.model.improvement.plow";
    public static final String UNIT_SELECT = "image.tile.unitSelect";
    public static final String TILE_TAKEN = "image.tile.tileTaken";
    public static final String TILE_OWNED_BY_INDIANS = "image.tileitem.nativeLand";
    public static final String LOST_CITY_RUMOUR = "image.tileitem.lostCityRumour";
    public static final String DARKNESS = "image.halo.dark";
    public static final String ICON_LOCK = "image.icon.lock";
    public static final String ICON_COIN = "image.icon.coin";
    public static final String BELLS = "image.icon.model.goods.bells";
    private final float scaleFactor;
    final Dimension tileSize;
    final Dimension tileOverlaySize;
    final Dimension tileForestSize;
    private final HashMap<String, BufferedImage> stringImageCache;

    public ImageLibrary() {
        this(1.0f);
    }

    public ImageLibrary(float scaleFactor) {
        this.scaleFactor = scaleFactor;
        this.tileSize = ImageLibrary.scaleDimension(TILE_SIZE, scaleFactor);
        this.tileOverlaySize = ImageLibrary.scaleDimension(TILE_OVERLAY_SIZE, scaleFactor);
        this.tileForestSize = ImageLibrary.scaleDimension(TILE_FOREST_SIZE, scaleFactor);
        this.stringImageCache = new HashMap();
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public Dimension scaleDimension(Dimension size) {
        return ImageLibrary.scaleDimension(size, this.scaleFactor);
    }

    public static Dimension scaleDimension(Dimension size, float scaleFactor) {
        return new Dimension(Math.round((float)size.width * scaleFactor), Math.round((float)size.height * scaleFactor));
    }

    public static Color getForegroundColor(Color background) {
        return background == null || (double)background.getRed() * 0.3 + (double)background.getGreen() * 0.59 + (double)background.getBlue() * 0.11 >= 126.0 ? Color.BLACK : Color.WHITE;
    }

    public static Color getStringBorderColor(Color color) {
        return (double)color.getRed() * 0.3 + (double)color.getGreen() * 0.59 + (double)color.getBlue() * 0.11 < 10.0 ? Color.WHITE : Color.BLACK;
    }

    private static boolean isEven(int x, int y) {
        return y % 8 <= 2 || (x + y) % 2 == 0;
    }

    public BufferedImage getBeachCornerImage(int index, int x, int y) {
        return ResourceManager.getImage("image.tile.model.tile.beach.corner" + index + ".r" + (ImageLibrary.isEven(x, y) ? "0" : "1"), this.tileSize);
    }

    public BufferedImage getBeachEdgeImage(int index, int x, int y) {
        return ResourceManager.getImage("image.tile.model.tile.beach.edge" + index + ".r" + (ImageLibrary.isEven(x, y) ? "0" : "1"), this.tileSize);
    }

    public BufferedImage getBorderImage(TileType type, Direction direction, int x, int y) {
        String key = type == null ? "model.tile.unexplored" : type.getId();
        return ResourceManager.getImage("image.tile." + key + ".border." + direction + ".r" + (ImageLibrary.isEven(x, y) ? "0" : "1"), this.tileSize);
    }

    public BufferedImage getForestImage(TileType type) {
        return ImageLibrary.getForestImage(type, this.tileForestSize);
    }

    public static BufferedImage getForestImage(TileType type, Dimension size) {
        return ResourceManager.getImage("image.tileforest." + type.getId(), size);
    }

    public BufferedImage getForestImage(TileType type, TileImprovementStyle riverStyle) {
        return ImageLibrary.getForestImage(type, riverStyle, this.tileForestSize);
    }

    public static BufferedImage getForestImage(TileType type, TileImprovementStyle riverStyle, Dimension size) {
        String key;
        if (riverStyle != null && ResourceManager.hasImageResource(key = "image.tileforest." + type.getId() + ".s" + riverStyle.getMask())) {
            return ResourceManager.getImage(key, size);
        }
        return ResourceManager.getImage("image.tileforest." + type.getId(), size);
    }

    public static BufferedImage getFoundingFatherImage(FoundingFather father, boolean grey) {
        String resource = "image.flavor." + father.getId();
        return grey ? ResourceManager.getGrayscaleImage(resource, 1.0f) : ResourceManager.getImage(resource);
    }

    public BufferedImage getSmallBuildableImage(BuildableType buildable, Player player) {
        float scale = this.scaleFactor * 0.75f;
        BufferedImage image = buildable instanceof BuildingType ? ImageLibrary.getBuildingImage((BuildingType)buildable, player, scale) : ImageLibrary.getUnitImage((UnitType)buildable, scale);
        return image;
    }

    public static BufferedImage getBuildableImage(BuildableType buildable, Dimension size) {
        BufferedImage image = buildable instanceof BuildingType ? ImageLibrary.getBuildingImage((BuildingType)buildable, size) : ImageLibrary.getUnitImage((UnitType)buildable, size);
        return image;
    }

    public BufferedImage getSmallBuildingImage(Building building) {
        return ImageLibrary.getBuildingImage(building.getType(), building.getOwner(), this.scaleFactor * 0.75f);
    }

    public BufferedImage getBuildingImage(Building building) {
        return ImageLibrary.getBuildingImage(building.getType(), building.getOwner(), this.scaleFactor);
    }

    public static BufferedImage getBuildingImage(BuildingType buildingType, Player player, float scale) {
        String key = "image.buildingicon." + buildingType.getId() + "." + player.getNationResourceKey();
        if (!ResourceManager.hasImageResource(key)) {
            key = "image.buildingicon." + buildingType.getId();
        }
        return ResourceManager.getImage(key, scale);
    }

    public static BufferedImage getBuildingImage(BuildingType buildingType, float scale) {
        return ResourceManager.getImage("image.buildingicon." + buildingType.getId(), scale);
    }

    public static BufferedImage getBuildingImage(BuildingType buildingType, Dimension size) {
        return ResourceManager.getImage("image.buildingicon." + buildingType.getId(), size);
    }

    public BufferedImage getSmallerIconImage(FreeColGameObjectType type) {
        return ImageLibrary.getMiscImage("image.icon." + type.getId(), ImageLibrary.scaleDimension(ICON_SIZE, this.scaleFactor * 0.5f));
    }

    public BufferedImage getSmallIconImage(FreeColGameObjectType type) {
        return ImageLibrary.getMiscImage("image.icon." + type.getId(), ImageLibrary.scaleDimension(ICON_SIZE, this.scaleFactor * 0.75f));
    }

    public BufferedImage getIconImage(FreeColGameObjectType type) {
        return ImageLibrary.getMiscImage("image.icon." + type.getId(), ImageLibrary.scaleDimension(ICON_SIZE, this.scaleFactor));
    }

    public BufferedImage getSmallerMiscIconImage(FreeColGameObjectType type) {
        return ImageLibrary.getMiscIconImage(type, this.scaleFactor * 0.5f);
    }

    public BufferedImage getSmallMiscIconImage(FreeColGameObjectType type) {
        return ImageLibrary.getMiscIconImage(type, this.scaleFactor * 0.75f);
    }

    public BufferedImage getMiscIconImage(FreeColGameObjectType type) {
        return ImageLibrary.getMiscIconImage(type, this.scaleFactor);
    }

    public static BufferedImage getMiscIconImage(FreeColGameObjectType type, float scale) {
        return ResourceManager.getImage("image.miscicon." + type.getId(), scale);
    }

    public static BufferedImage getMiscIconImage(FreeColGameObjectType type, Dimension size) {
        return ResourceManager.getImage("image.miscicon." + type.getId(), size);
    }

    public BufferedImage getMiscImage(String id) {
        return ImageLibrary.getMiscImage(id, this.scaleFactor);
    }

    public static BufferedImage getMiscImage(String id, float scale) {
        return ResourceManager.getImage(id, scale);
    }

    public static BufferedImage getMiscImage(String id, Dimension size) {
        return ResourceManager.getImage(id, size);
    }

    public BufferedImage getObjectImage(FreeColObject display, float scale) {
        try {
            BufferedImage image;
            float combinedScale = this.scaleFactor * scale;
            Dimension size = ImageLibrary.scaleDimension(ICON_SIZE, combinedScale);
            if (display instanceof Goods) {
                display = ((Goods)display).getType();
            } else if (display instanceof Player) {
                display = ((Player)display).getNation();
            }
            if (display instanceof Unit) {
                Unit unit = (Unit)display;
                image = ImageLibrary.getUnitImage(unit, size);
            } else if (display instanceof UnitType) {
                UnitType unitType = (UnitType)display;
                image = ImageLibrary.getUnitImage(unitType, size);
            } else if (display instanceof Settlement) {
                Settlement settlement = (Settlement)display;
                image = ImageLibrary.getSettlementImage(settlement, size);
            } else if (display instanceof LostCityRumour) {
                image = ImageLibrary.getMiscImage(LOST_CITY_RUMOUR, size);
            } else if (display instanceof GoodsType) {
                FreeColGameObjectType type = (FreeColGameObjectType)display;
                image = this.getIconImage(type);
            } else if (display instanceof Nation) {
                FreeColGameObjectType type = (FreeColGameObjectType)display;
                image = ImageLibrary.getMiscIconImage(type, size);
            } else if (display instanceof BuildingType) {
                BuildingType type = (BuildingType)display;
                image = ImageLibrary.getBuildingImage(type, size);
            } else {
                logger.warning("could not find image of unknown type for " + display);
                return null;
            }
            if (image == null) {
                logger.warning("could not find image for " + display);
                return null;
            }
            return image;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "could not find image", e);
            return null;
        }
    }

    public static BufferedImage getMonarchImage(Nation nation) {
        return ResourceManager.getImage("image.flavor.monarch." + nation.getId());
    }

    public BufferedImage getOverlayImage(Tile tile) {
        return ImageLibrary.getOverlayImage(tile.getType(), tile.getId(), this.tileOverlaySize);
    }

    public static BufferedImage getOverlayImage(TileType type, String id, Dimension size) {
        String prefix = "image.tileoverlay." + type.getId();
        List<String> keys = ResourceManager.getImageKeys(prefix);
        return ImageLibrary.getRandomizedImage(keys, id, size);
    }

    public static Set<String> createOverlayCache() {
        return ResourceManager.getImageKeySet("image.tileoverlay.");
    }

    public BufferedImage getOverlayImage(Tile tile, Set<String> overlayCache) {
        return ImageLibrary.getOverlayImage(tile.getType(), tile.getId(), this.tileOverlaySize, overlayCache);
    }

    public static BufferedImage getOverlayImage(TileType type, String id, Dimension size, Set<String> overlayCache) {
        String prefix = "image.tileoverlay." + type.getId() + ".r";
        List<String> keys = overlayCache.stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toList());
        return ImageLibrary.getRandomizedImage(keys, id, size);
    }

    private static BufferedImage getRandomizedImage(List<String> keys, String id, Dimension size) {
        int count = keys.size();
        switch (count) {
            case 0: {
                return null;
            }
            case 1: {
                return ResourceManager.getImage(keys.get(0), size);
            }
        }
        Collections.sort(keys);
        return ResourceManager.getImage(keys.get(Math.abs(id.hashCode() % count)), size);
    }

    public static BufferedImage getPathImage(PathType pt) {
        return pt == null ? null : ResourceManager.getImage(pt.getImageKey());
    }

    public static BufferedImage getPathImage(Unit u) {
        return u == null ? null : ImageLibrary.getPathImage(PathType.getPathType(u));
    }

    public static BufferedImage getPathNextTurnImage(PathType pt) {
        return pt == null ? null : ResourceManager.getImage(pt.getNextTurnImageKey());
    }

    public static BufferedImage getPathNextTurnImage(Unit u) {
        return u == null ? null : ImageLibrary.getPathNextTurnImage(PathType.getPathType(u));
    }

    public BufferedImage getRiverImage(TileImprovementStyle style) {
        return ImageLibrary.getRiverImage(style.getString(), this.tileSize);
    }

    public static BufferedImage getRiverImage(String style, Dimension size) {
        return ResourceManager.getImage("image.tile.model.improvement.river.s" + style, size);
    }

    public BufferedImage getRiverMouthImage(Direction direction, int magnitude, int x, int y) {
        String key = "image.tile.model.tile.delta." + direction + (magnitude == 1 ? ".small" : ".large");
        return ResourceManager.getImage(key, this.tileSize);
    }

    public BufferedImage getSmallSettlementImage(Settlement settlement) {
        return ImageLibrary.getSettlementImage(settlement, this.scaleFactor * 0.75f);
    }

    public BufferedImage getSettlementImage(Settlement settlement) {
        return ImageLibrary.getSettlementImage(settlement, this.scaleFactor);
    }

    public static BufferedImage getSettlementImage(Settlement settlement, float scale) {
        return ResourceManager.getImage(settlement.getImageKey(), scale);
    }

    public static BufferedImage getSettlementImage(Settlement settlement, Dimension size) {
        return ResourceManager.getImage(settlement.getImageKey(), size);
    }

    public BufferedImage getSettlementImage(SettlementType settlementType) {
        return ImageLibrary.getSettlementImage(settlementType, this.scaleFactor);
    }

    public static BufferedImage getSettlementImage(SettlementType settlementType, float scale) {
        return ResourceManager.getImage("image.tileitem." + settlementType.getId(), scale);
    }

    public BufferedImage getTerrainImage(TileType type, int x, int y) {
        return ImageLibrary.getTerrainImage(type, x, y, this.tileSize);
    }

    public static BufferedImage getTerrainImage(TileType type, int x, int y, Dimension size) {
        String key = type == null ? "model.tile.unexplored" : type.getId();
        return ResourceManager.getImage("image.tile." + key + ".center.r" + (ImageLibrary.isEven(x, y) ? "0" : "1"), size);
    }

    public BufferedImage getSmallerUnitImage(Unit unit) {
        return ImageLibrary.getUnitImage(unit.getType(), unit.getRole().getId(), unit.hasNativeEthnicity(), false, this.scaleFactor * 0.5f);
    }

    public BufferedImage getSmallUnitImage(Unit unit) {
        return ImageLibrary.getUnitImage(unit.getType(), unit.getRole().getId(), unit.hasNativeEthnicity(), false, this.scaleFactor * 0.75f);
    }

    public BufferedImage getSmallUnitImage(Unit unit, boolean grayscale) {
        return ImageLibrary.getUnitImage(unit.getType(), unit.getRole().getId(), unit.hasNativeEthnicity(), grayscale, this.scaleFactor * 0.75f);
    }

    public BufferedImage getUnitImage(Unit unit) {
        return ImageLibrary.getUnitImage(unit.getType(), unit.getRole().getId(), unit.hasNativeEthnicity(), false, this.scaleFactor);
    }

    public BufferedImage getUnitImage(Unit unit, boolean grayscale) {
        return ImageLibrary.getUnitImage(unit.getType(), unit.getRole().getId(), unit.hasNativeEthnicity(), grayscale, this.scaleFactor);
    }

    public static BufferedImage getUnitImage(Unit unit, float scale) {
        return ImageLibrary.getUnitImage(unit.getType(), unit.getRole().getId(), unit.hasNativeEthnicity(), false, scale);
    }

    public BufferedImage getTinyUnitImage(UnitType unitType) {
        return ImageLibrary.getUnitImage(unitType, unitType.getDisplayRoleId(), false, false, this.scaleFactor * 0.25f);
    }

    public BufferedImage getTinyUnitImage(UnitType unitType, boolean grayscale) {
        return ImageLibrary.getUnitImage(unitType, unitType.getDisplayRoleId(), false, grayscale, this.scaleFactor * 0.25f);
    }

    public BufferedImage getSmallerUnitImage(UnitType unitType) {
        return ImageLibrary.getUnitImage(unitType, unitType.getDisplayRoleId(), false, false, this.scaleFactor * 0.5f);
    }

    public BufferedImage getSmallUnitImage(UnitType unitType) {
        return ImageLibrary.getUnitImage(unitType, unitType.getDisplayRoleId(), false, false, this.scaleFactor * 0.75f);
    }

    public BufferedImage getSmallUnitImage(UnitType unitType, boolean grayscale) {
        return ImageLibrary.getUnitImage(unitType, unitType.getDisplayRoleId(), false, grayscale, this.scaleFactor * 0.75f);
    }

    public BufferedImage getSmallUnitImage(UnitType unitType, String roleId, boolean grayscale) {
        return ImageLibrary.getUnitImage(unitType, roleId, false, grayscale, this.scaleFactor * 0.75f);
    }

    public BufferedImage getUnitImage(UnitType unitType) {
        return ImageLibrary.getUnitImage(unitType, unitType.getDisplayRoleId(), false, false, this.scaleFactor);
    }

    public static BufferedImage getUnitImage(UnitType unitType, float scale) {
        return ImageLibrary.getUnitImage(unitType, unitType.getDisplayRoleId(), false, false, scale);
    }

    public static BufferedImage getUnitImage(UnitType unitType, String roleId, boolean nativeEthnicity, boolean grayscale, float scale) {
        if (unitType.hasAbility("model.ability.bornInIndianSettlement")) {
            nativeEthnicity = false;
        }
        String roleQual = Role.isDefaultRoleId(roleId) ? "" : "." + Role.getRoleSuffix(roleId);
        String key = "image.unit." + unitType.getId() + roleQual + (nativeEthnicity ? ".native" : "");
        if (!ResourceManager.hasImageResource(key) && nativeEthnicity) {
            key = "image.unit." + unitType.getId() + roleQual;
        }
        BufferedImage image = grayscale ? ResourceManager.getGrayscaleImage(key, scale) : ResourceManager.getImage(key, scale);
        return image;
    }

    public static BufferedImage getUnitImage(Unit unit, Dimension size) {
        return ImageLibrary.getUnitImage(unit.getType(), unit.getRole().getId(), unit.hasNativeEthnicity(), size);
    }

    public static BufferedImage getUnitImage(UnitType unitType, Dimension size) {
        String roleId = unitType.getDisplayRoleId();
        String roleQual = Role.isDefaultRoleId(roleId) ? "" : "." + Role.getRoleSuffix(roleId);
        String key = "image.unit." + unitType.getId() + roleQual;
        return ResourceManager.getImage(key, size);
    }

    public static BufferedImage getUnitImage(UnitType unitType, String roleId, boolean nativeEthnicity, Dimension size) {
        if (unitType.hasAbility("model.ability.bornInIndianSettlement")) {
            nativeEthnicity = false;
        }
        String roleQual = Role.isDefaultRoleId(roleId) ? "" : "." + Role.getRoleSuffix(roleId);
        String key = "image.unit." + unitType.getId() + roleQual + (nativeEthnicity ? ".native" : "");
        if (!ResourceManager.hasImageResource(key) && nativeEthnicity) {
            key = "image.unit." + unitType.getId() + roleQual;
        }
        BufferedImage image = ResourceManager.getImage(key, size);
        return image;
    }

    public static void drawTiledImage(String resource, Graphics g, JComponent c, Insets insets) {
        int ymin;
        int xmin;
        int width = c.getWidth();
        int height = c.getHeight();
        if (insets == null) {
            xmin = 0;
            ymin = 0;
        } else {
            xmin = insets.left;
            ymin = insets.top;
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        if (ResourceManager.hasImageResource(resource)) {
            BufferedImage image = ResourceManager.getImage(resource);
            int dx = image.getWidth();
            int dy = image.getHeight();
            int xmax = xmin + width;
            int ymax = ymin + height;
            for (int x = xmin; x < xmax; x += dx) {
                for (int y = ymin; y < ymax; y += dy) {
                    g.drawImage(image, x, y, null);
                }
            }
        } else {
            g.setColor(c.getBackground());
            g.fillRect(xmin, ymin, width, height);
        }
    }

    public static void fillTexture(Graphics2D g2, BufferedImage img, int x, int y, int width, int height) {
        Rectangle anchor = new Rectangle(x, y, img.getWidth(), img.getHeight());
        TexturePaint paint = new TexturePaint(img, anchor);
        g2.setPaint(paint);
        g2.fillRect(x, y, width, height);
    }

    public static BufferedImage createBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        BufferedImage result = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return result;
    }

    public static BufferedImage createMirroredImage(Image image) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage result = new BufferedImage(width, height, 2);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, width, 0, -width, height, null);
        g.dispose();
        return result;
    }

    public static BufferedImage createResizedImage(Image image, int width, int height) {
        BufferedImage scaled = new BufferedImage(width, height, 2);
        Graphics2D g = scaled.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return scaled;
    }

    public static BufferedImage fadeImage(Image img, float fade, float target) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        float offset = target * (1.0f - fade);
        float[] scales = new float[]{fade, fade, fade, 1.0f};
        float[] offsets = new float[]{offset, offset, offset, 0.0f};
        RescaleOp rop = new RescaleOp(scales, offsets, null);
        g.drawImage(bi, rop, 0, 0);
        g.dispose();
        return bi;
    }

    private BufferedImage createChip(Graphics2D g, String text, Color border, Color background, Color foreground) {
        Font font = FontLibrary.createFont(FontLibrary.FontType.SIMPLE, FontLibrary.FontSize.TINY, 1, this.scaleFactor);
        FontMetrics fm = g.getFontMetrics(font);
        int padding = (int)(6.0f * this.scaleFactor);
        BufferedImage bi = new BufferedImage(fm.stringWidth(text) + padding, fm.getMaxAscent() + fm.getMaxDescent() + padding, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setFont(font);
        int width = bi.getWidth();
        int height = bi.getHeight();
        g2.setColor(border);
        g2.fillRect(0, 0, width, height);
        g2.setColor(background);
        g2.fillRect(1, 1, width - 2, height - 2);
        g2.setColor(foreground);
        g2.drawString(text, padding / 2, fm.getMaxAscent() + padding / 2);
        g2.dispose();
        return bi;
    }

    private BufferedImage createFilledChip(Graphics2D g, String text, Color border, Color background, double amount, Color fill, Color foreground) {
        Font font = FontLibrary.createFont(FontLibrary.FontType.SIMPLE, FontLibrary.FontSize.TINY, 1, this.scaleFactor);
        FontMetrics fm = g.getFontMetrics(font);
        int padding = (int)(6.0f * this.scaleFactor);
        BufferedImage bi = new BufferedImage(fm.stringWidth(text) + padding, fm.getMaxAscent() + fm.getMaxDescent() + padding, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setFont(font);
        int width = bi.getWidth();
        int height = bi.getHeight();
        g2.setColor(border);
        g2.fillRect(0, 0, width, height);
        g2.setColor(background);
        g2.fillRect(1, 1, width - 2, height - 2);
        if (amount > 0.0 && amount <= 1.0) {
            g2.setColor(fill);
            g2.fillRect(1, 1, width - 2, (int)((double)(height - 2) * amount));
        }
        g2.setColor(foreground);
        g2.drawString(text, padding / 2, fm.getMaxAscent() + padding / 2);
        g2.dispose();
        return bi;
    }

    public BufferedImage getAlarmChip(Graphics2D g, IndianSettlement is, Player player) {
        if (player == null || !is.hasContacted(player)) {
            return null;
        }
        Color ownerColor = is.getOwner().getNationColor();
        Player enemy = is.getMostHated();
        Color enemyColor = enemy == null ? Nation.UNKNOWN_NATION_COLOR : enemy.getNationColor();
        int amount = 4;
        if (enemy == null) {
            amount = 0;
        } else if (player == enemy) {
            Tension alarm = is.getAlarm(enemy);
            int n = amount = alarm == null ? 4 : alarm.getLevel().ordinal();
            if (amount == 0) {
                amount = 1;
            }
        }
        Color foreground = ImageLibrary.getForegroundColor(enemyColor);
        String text = ResourceManager.getString(is.worthScouting(player) ? "indianAlarmChip.contacted" : "indianAlarmChip.scouted");
        return this.createFilledChip(g, text, Color.BLACK, ownerColor, (double)amount / 4.0, enemyColor, foreground);
    }

    public BufferedImage getIndianSettlementChip(Graphics2D g, IndianSettlement is) {
        String text = ResourceManager.getString("indianSettlementChip." + (is.getType().isCapital() ? "capital" : "normal"));
        Color background = is.getOwner().getNationColor();
        return this.createChip(g, text, Color.BLACK, background, ImageLibrary.getForegroundColor(background));
    }

    public BufferedImage getMissionChip(Graphics2D g, Player owner, boolean expert) {
        Color background = owner.getNationColor();
        String key = "color.foreground.mission." + (expert ? "expert" : "normal");
        Color foreground = ResourceManager.hasColorResource(key) ? ResourceManager.getColor(key) : (expert ? Color.BLACK : Color.GRAY);
        return this.createChip(g, ResourceManager.getString("cross"), Color.BLACK, background, foreground);
    }

    public BufferedImage getOccupationIndicatorChip(Graphics2D g, Unit unit, String text) {
        Color backgroundColor = unit.getOwner().getNationColor();
        Color foregroundColor = unit.getState() == Unit.UnitState.FORTIFIED ? Color.GRAY : ImageLibrary.getForegroundColor(backgroundColor);
        return this.createChip(g, text, Color.BLACK, backgroundColor, foregroundColor);
    }

    public BufferedImage getStringImage(Graphics g, String text, Color color, Font font) {
        int dstRGB;
        int srcA;
        int srcRGB;
        int d;
        String key;
        BufferedImage img;
        if (color == null) {
            logger.warning("createStringImage called with color null");
            color = Color.WHITE;
        }
        if ((img = this.stringImageCache.get(key = text + "." + font.getFontName().replace(' ', '-') + "." + Integer.toString(font.getSize()) + "." + Integer.toHexString(color.getRGB()))) != null) {
            return img;
        }
        FontMetrics fm = g.getFontMetrics(font);
        int width = fm.stringWidth(text) + 4;
        int height = fm.getMaxAscent() + fm.getMaxDescent();
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setColor(ImageLibrary.getStringBorderColor(color));
        g2.setFont(font);
        g2.drawString(text, 2, fm.getMaxAscent());
        int borderWidth = 1;
        int borderColor = ImageLibrary.getStringBorderColor(color).getRGB();
        for (int biY = 0; biY < height; ++biY) {
            for (int biX = borderWidth; biX < width - borderWidth; ++biX) {
                int biXI = width - biX - 1;
                for (d = 1; d <= borderWidth; ++d) {
                    srcRGB = bi.getRGB(biX, biY);
                    srcA = srcRGB >> 24 & 0xFF;
                    dstRGB = bi.getRGB(biX - d, biY);
                    if (dstRGB != borderColor && srcA > 0) {
                        bi.setRGB(biX, biY, borderColor);
                        bi.setRGB(biX - d, biY, srcRGB);
                    }
                    srcRGB = bi.getRGB(biXI, biY);
                    srcA = srcRGB >> 24 & 0xFF;
                    dstRGB = bi.getRGB(biXI + d, biY);
                    if (dstRGB == borderColor || srcA <= 0) continue;
                    bi.setRGB(biXI, biY, borderColor);
                    bi.setRGB(biXI + d, biY, srcRGB);
                }
            }
        }
        for (int biX = 0; biX < width; ++biX) {
            for (int biY = borderWidth; biY < height - borderWidth; ++biY) {
                int biYI = height - biY - 1;
                for (d = 1; d <= borderWidth; ++d) {
                    srcRGB = bi.getRGB(biX, biY);
                    srcA = srcRGB >> 24 & 0xFF;
                    dstRGB = bi.getRGB(biX, biY - d);
                    if (dstRGB != borderColor && srcA > 0) {
                        bi.setRGB(biX, biY, borderColor);
                        bi.setRGB(biX, biY - d, srcRGB);
                    }
                    srcRGB = bi.getRGB(biX, biYI);
                    srcA = srcRGB >> 24 & 0xFF;
                    dstRGB = bi.getRGB(biX, biYI + d);
                    if (dstRGB == borderColor || srcA <= 0) continue;
                    bi.setRGB(biX, biYI, borderColor);
                    bi.setRGB(biX, biYI + d, srcRGB);
                }
            }
        }
        g2.setColor(color);
        g2.drawString(text, 2, fm.getMaxAscent());
        g2.dispose();
        this.stringImageCache.put(key, bi);
        return bi;
    }

    public static enum PathType {
        NAVAL,
        WAGON,
        HORSE,
        FOOT;


        private String getKey() {
            return StringUtils.getEnumKey(this);
        }

        public String getImageKey() {
            return "image.tileitem.path." + this.getKey();
        }

        public String getNextTurnImageKey() {
            return "image.tileitem.path." + this.getKey() + ".nextTurn";
        }

        public static PathType getPathType(Unit u) {
            return u == null ? FOOT : (u.isNaval() ? NAVAL : (u.isMounted() ? HORSE : (u.isPerson() ? FOOT : WAGON)));
        }
    }
}

