(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/misc/threads#primordial-thread-group
    (lambda () (thread-thread-group ##primordial-thread)))
  (define std/misc/threads#thread-group->thread-list*
    (lambda (_tg532_)
      (let _lp534_ ((_rest536_ (thread-group->thread-group-list _tg532_))
                    (_r537_ (thread-group->thread-list _tg532_)))
        (let* ((_rest538546_ _rest536_)
               (_else540554_ (lambda () _r537_))
               (_K542560_
                (lambda (_rest557_ _tg558_)
                  (_lp534_ (foldl1 cons
                                   _rest557_
                                   (thread-group->thread-group-list _tg558_))
                           (foldl1 cons
                                   _r537_
                                   (thread-group->thread-list _tg558_))))))
          (if (let () (declare (not safe)) (##pair? _rest538546_))
              (let ((_hd543563_
                     (let () (declare (not safe)) (##car _rest538546_)))
                    (_tl544565_
                     (let () (declare (not safe)) (##cdr _rest538546_))))
                (let* ((_tg568_ _hd543563_) (_rest570_ _tl544565_))
                  (_K542560_ _rest570_ _tg568_)))
              (_else540554_))))))
  (define std/misc/threads#all-threads
    (lambda ()
      (std/misc/threads#thread-group->thread-list*
       (std/misc/threads#primordial-thread-group))))
  (namespace ("std/misc/threads#" thread-dead?))
  (define (thread-dead? thread) (not (macro-thread-end-condvar thread)))
  (namespace
   ("std/misc/threads#"
    thread-group-kill!
    tgroup-kill!
    tgroup-kill-threads!
    tgroup-detach!))
  (define (thread-group-kill! tg)
    (declare (not interrupts-enabled))
    (define (check-tgroup! tg)
      (let ((mytg (macro-thread-tgroup (##current-thread))))
        (let lp ((mytg mytg))
          (cond ((##eq? mytg tg)
                 (error "Cannot kill thread group; thread-group includes current thread"
                        tg))
                ((##not mytg))
                (else (lp (macro-tgroup-parent mytg)))))))
    (if (macro-tgroup? tg)
        (begin
          (check-tgroup! tg)
          (cond-expand
           (enable-smp (let lp () (if (##fx> (tgroup-kill! tg) 0) (lp))))
           (else (tgroup-kill! tg)))
          (tgroup-detach! tg)
          (void))
        (error "Bad argument; expected thread-group" tg)))
  (define (tgroup-kill! tg)
    (declare (not interrupts-enabled))
    (let ((tgroups (##tgroup->tgroup-vector tg)))
      (let lp ((i 0) (r 0))
        (if (##fx< i (##vector-length tgroups))
            (let ((count (tgroup-kill! (##vector-ref tgroups i))))
              (lp (##fx+ i 1) (##fx+ r count)))
            (let ((count (tgroup-kill-threads! tg))) (##fx+ r count))))))
  (define (tgroup-kill-threads! tg)
    (declare (not interrupts-enabled))
    (let ((threads (##tgroup->thread-vector tg)))
      (let lp ((i 0))
        (if (##fx< i (##vector-length threads))
            (begin
              (##thread-terminate! (##vector-ref threads i))
              (lp (##fx+ i 1)))
            i))))
  (define (tgroup-detach! tg)
    (declare (not interrupts-enabled))
    (if (macro-tgroup-parent tg)
        (begin
          (let ((next (macro-tgroup-tgroups-deq-next tg))
                (prev (macro-tgroup-tgroups-deq-prev tg)))
            (cond-expand
             (enable-smp
              (##vector-set! prev 2 next)
              (##vector-set! next 3 prev))
             (else (##vector-set! prev 1 next) (##vector-set! next 2 prev)))
            (macro-tgroup-tgroups-deq-next-set! tg tg)
            (macro-tgroup-tgroups-deq-prev-set! tg tg))
          (cond-expand
           (enable-smp (##vector-set! tg 8 #f))
           (else (macro-tgroup-parent-set! tg #f))))))
  (define std/misc/threads#thread-abort::t
    (make-struct-type
     'std/misc/threads#thread-abort::t
     '#f
     '0
     'thread-abort
     '((final: . #t))
     '#f
     '()))
  (define std/misc/threads#thread-abort?
    (make-struct-predicate std/misc/threads#thread-abort::t))
  (define std/misc/threads#make-thread-abort
    (lambda _$args528_
      (apply make-struct-instance
             std/misc/threads#thread-abort::t
             _$args528_)))
  (define std/misc/threads#thread-abort::display-exception
    (lambda (_self525_ _port526_)
      (display '"thread aborted" _port526_)
      (newline _port526_)))
  (bind-method!
   std/misc/threads#thread-abort::t
   'display-exception
   std/misc/threads#thread-abort::display-exception
   '#f)
  (define std/misc/threads#+thread-abort+
    (let ()
      (declare (not safe))
      (##structure std/misc/threads#thread-abort::t)))
  (define std/misc/threads#thread-abort!
    (lambda (_thread399_)
      (std/misc/threads#thread-raise!
       _thread399_
       std/misc/threads#+thread-abort+)))
  (define std/misc/threads#thread-raise!
    (lambda (_thread395_ _obj396_)
      (if (not (thread? _thread395_))
          (error '"Bad argument; expected thread" _thread395_)
          (if (eq? _thread395_ (current-thread))
              (raise _obj396_)
              (std/misc/threads#thread-intr!
               _thread395_
               (lambda () (raise _obj396_)))))))
  (define std/misc/threads#thread-async!
    (lambda (_thread392_ _thunk393_)
      (if (not (thread? _thread392_))
          (error '"Bad argument; expected thread" _thread392_)
          (if (eq? _thread392_ (current-thread))
              (_thunk393_)
              (std/misc/threads#thread-intr! _thread392_ _thunk393_)))))
  (namespace ("std/misc/threads#" thread-intr!))
  (define (thread-intr! thread thunk)
    (declare (not interrupts-enabled))
    (if (and (macro-initialized-thread? thread)
             (##not (macro-terminated-thread-given-initialized? thread))
             (cond-expand
              (enable-smp (macro-started-thread? thread))
              (else (macro-started-thread-given-initialized? thread))))
        (begin
          (cond-expand
           (enable-smp (##thread-intr! thread #t thunk))
           (else (##thread-int! thread thunk)))
          (##void))
        #f))
  (define std/misc/threads#on-all-processors
    (lambda (_thunk390_)
      (cons (gerbil/gambit/threads#spawn-thread__0 _thunk390_) '()))))
