(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/repl#repl-state::t
    (make-struct-type
     'std/net/repl#repl-state::t
     '#f
     '4
     'repl-state
     '((final: . #t))
     '#f
     '(client channel reader eof)))
  (define std/net/repl#repl-state?
    (make-struct-predicate std/net/repl#repl-state::t))
  (define std/net/repl#make-repl-state
    (lambda _$args639_
      (apply make-struct-instance std/net/repl#repl-state::t _$args639_)))
  (define std/net/repl#repl-state-client
    (make-struct-field-accessor std/net/repl#repl-state::t '0))
  (define std/net/repl#repl-state-channel
    (make-struct-field-accessor std/net/repl#repl-state::t '1))
  (define std/net/repl#repl-state-reader
    (make-struct-field-accessor std/net/repl#repl-state::t '2))
  (define std/net/repl#repl-state-eof
    (make-struct-field-accessor std/net/repl#repl-state::t '3))
  (define std/net/repl#repl-state-client-set!
    (make-struct-field-mutator std/net/repl#repl-state::t '0))
  (define std/net/repl#repl-state-channel-set!
    (make-struct-field-mutator std/net/repl#repl-state::t '1))
  (define std/net/repl#repl-state-reader-set!
    (make-struct-field-mutator std/net/repl#repl-state::t '2))
  (define std/net/repl#repl-state-eof-set!
    (make-struct-field-mutator std/net/repl#repl-state::t '3))
  (define std/net/repl#start-repl-server!__%
    (lambda (_g4240_ _passwd607611_ _address608613_)
      (let* ((_passwd616_
              (if (eq? _passwd607611_ absent-value) '#f _passwd607611_))
             (_address618_
              (if (eq? _address608613_ absent-value)
                  '"127.0.0.1:7000"
                  _address608613_)))
        (std/logger#start-logger!__0)
        (let* ((_sock620_
                (open-tcp-server
                 (cons 'server-address:
                       (cons _address618_
                             (cons 'eol-encoding:
                                   (cons 'cr-lf
                                         (cons 'reuse-address:
                                               (cons '#t '()))))))))
               (_server622_
                (gerbil/gambit/threads#spawn/group
                 'repl-server
                 std/net/repl#repl-server
                 _sock620_
                 _passwd616_)))
          (thread-specific-set! _server622_ _sock620_)
          _server622_))))
  (define std/net/repl#start-repl-server!__@
    (lambda (_keys606628_ . _args630_)
      (apply std/net/repl#start-repl-server!__%
             _keys606628_
             (table-ref _keys606628_ 'password: absent-value)
             (table-ref _keys606628_ 'address: absent-value)
             _args630_)))
  (define std/net/repl#start-repl-server!
    (lambda _args609636_
      (apply keyword-dispatch
             '#(password: address:)
             std/net/repl#start-repl-server!__@
             _args609636_)))
  (define std/net/repl#stop-repl-server!
    (lambda (_server588_)
      (let ((_tgroup590_ (thread-thread-group _server588_))
            (_port591_ (thread-specific _server588_)))
        (with-unwind-protect
         (lambda ()
           (with-exception-catcher
            (lambda (_g592595_)
              (if ((lambda (_$obj598_) (uncaught-exception? _$obj598_))
                   _g592595_)
                  (let ((_e601_ _g592595_))
                    (if (os-exception? (uncaught-exception-reason _e601_))
                        '#!void
                        (raise _e601_)))
                  (raise _g592595_)))
            (lambda ()
              (close-port _port591_)
              (std/misc/threads#thread-async! _server588_ void)
              (thread-join! _server588_))))
         (lambda () (std/misc/threads#thread-group-kill! _tgroup590_))))))
  (define std/net/repl#repl-server
    (lambda (_sock568_ _passwd569_)
      (let _lp571_ ()
        (let ((_client574_ (read _sock568_)))
          (if (eof-object? _client574_)
              '#!void
              (begin
                (let ((_sinfo576_ (tcp-client-peer-socket-info _client574_)))
                  (std/logger#debug
                   '"accepted repl connection from ~a"
                   (std/net/address#inet-address->string
                    (cons (socket-info-address _sinfo576_)
                          (socket-info-port-number _sinfo576_)))))
                (output-port-readtable-set!
                 _client574_
                 (readtable-sharing-allowed?-set
                  (output-port-readtable _client574_)
                  '#t))
                (let* ((_tgroup578_ (make-thread-group 'repl-client))
                       (_thread581_
                        (make-thread
                         (lambda ()
                           (std/net/repl#repl-client _client574_ _passwd569_))
                         'repl
                         _tgroup578_))
                       (_state583_
                        (std/net/repl#make-repl-client-state
                         _client574_
                         _thread581_)))
                  (thread-group-specific-set! _tgroup578_ _state583_)
                  (thread-start! _thread581_)
                  (let ((_monitor586_
                         (gerbil/gambit/threads#spawn/name
                          'repl-client-monitor
                          std/net/repl#repl-client-monitor
                          _thread581_
                          _tgroup578_)))
                    (thread-specific-set! _monitor586_ _tgroup578_))
                  (_lp571_))))))))
  (define std/net/repl#repl-client-monitor
    (lambda (_thread553_ _tgroup554_)
      (with-unwind-protect
       (lambda ()
         (with-exception-catcher
          (lambda (_g555558_)
            (if ((lambda (_$obj561_) (uncaught-exception? _$obj561_))
                 _g555558_)
                (let ((_e564_ _g555558_))
                  (std/logger#log-error
                   '"repl client error"
                   (uncaught-exception-reason _e564_)))
                (raise _g555558_)))
          (lambda () (thread-join! _thread553_))))
       (lambda () (std/misc/threads#thread-group-kill! _tgroup554_)))))
  (define std/net/repl#repl-client
    (lambda (_client541_ _passwd542_)
      (if _passwd542_
          (let _lp544_ ()
            (display '"Password: " _client541_)
            (force-output _client541_)
            (let ((_pw547_ (read-line _client541_)))
              (if (equal? _pw547_ _passwd542_) '#!void (_lp544_))))
          '#!void)
      (let ((_state549_ (std/net/repl#repl-client-state__0)))
        (thread-start!
         (##direct-structure-ref _state549_ '3 std/net/repl#repl-state::t '#f))
        (call-with-parameters
         (lambda () (replx))
         current-input-port
         (let () (declare (not safe)) (##repl-input-port))
         current-output-port
         (let () (declare (not safe)) (##repl-output-port))
         current-error-port
         (let () (declare (not safe)) (##repl-output-port))
         ##current-user-interrupt-handler
         (lambda () (let () (declare (not safe)) (##handle-interrupt '#f))))
        (close-port _client541_)
        (thread-terminate!
         (##direct-structure-ref
          _state549_
          '3
          std/net/repl#repl-state::t
          '#f)))))
  (define std/net/repl#repl-client-reader
    (lambda (_state500_ _in501_ _out502_ _repl-thread503_)
      (letrec ((_loop505_
                (lambda (_mode514_)
                  (let ((_c516_ (read-char _in501_)))
                    (if (eof-object? _c516_)
                        (begin
                          (##direct-structure-set!
                           _state500_
                           '#t
                           '4
                           std/net/repl#repl-state::t
                           '#f)
                          (close-output-port _out502_))
                        (let ((_$e518_ _mode514_))
                          (if (eq? 'input _$e518_)
                              (if (char=? _c516_ '#\ÿ)
                                  (_loop505_ _c516_)
                                  (if (char=? _c516_ '#\x4)
                                      (begin
                                        (close-output-port _out502_)
                                        (_loop505_ _mode514_))
                                      (begin
                                        (write-char _c516_ _out502_)
                                        (force-output _out502_)
                                        (_loop505_ _mode514_))))
                              (if (or (eq? '#\û _$e518_)
                                      (eq? '#\ü _$e518_)
                                      (eq? '#\þ _$e518_))
                                  (_loop505_ 'input)
                                  (if (eq? '#\ý _$e518_)
                                      (begin
                                        (if (char=? _c516_ '#\x6)
                                            (let ((_client527_
                                                   (##direct-structure-ref
                                                    _state500_
                                                    '1
                                                    std/net/repl#repl-state::t
                                                    '#f)))
                                              (gerbil/gambit/ports#write-u8vector__%
                                               '#u8(255 251 6)
                                               _client527_)
                                              (force-output _client527_))
                                            '#!void)
                                        (_loop505_ 'input))
                                      (if (eq? '#\ÿ _$e518_)
                                          (let ((_$e529_ _c516_))
                                            (if (eq? '#\ô _$e529_)
                                                (begin
                                                  (std/misc/threads#thread-async!
                                                   _repl-thread503_
                                                   ##user-interrupt!)
                                                  (_loop505_ 'input))
                                                (if (or (eq? '#\û _$e529_)
                                                        (eq? '#\ü _$e529_)
                                                        (eq? '#\ý _$e529_)
                                                        (eq? '#\þ _$e529_))
                                                    (_loop505_ _c516_)
                                                    (_loop505_ 'input))))
                                          (_loop505_ 'input)))))))))))
        (with-exception-catcher
         (lambda (_g506508_)
           (if '#t
               (let ((_e511_ _g506508_))
                 (std/logger#log-error '"repl reader error" _e511_)
                 (##direct-structure-set!
                  _state500_
                  '#t
                  '4
                  std/net/repl#repl-state::t
                  '#f)
                 (close-output-port _out502_))
               (raise _g506508_)))
         (lambda () (_loop505_ 'input))))))
  (define std/net/repl#make-repl-client-state
    (lambda (_client482_ _thread483_)
      (let ((_g4241_ (open-string-pipe
                      '(direction: input permanent-close: #f))))
        (begin
          (let ((_g4242_ (let ()
                           (declare (not safe))
                           (if (##values? _g4241_)
                               (##vector-length _g4241_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4242_ 2)))
                (error "Context expects 2 values" _g4242_)))
          (let ((_in-rd485_
                 (let () (declare (not safe)) (##vector-ref _g4241_ 0)))
                (_in-wr486_
                 (let () (declare (not safe)) (##vector-ref _g4241_ 1))))
            (let* ((_g4243_ (macro-port-name-set!
                             _in-rd485_
                             (lambda (_port488_) '(repl))))
                   (_channel491_
                    (let ()
                      (declare (not safe))
                      (##make-repl-channel-ports _in-rd485_ _client482_)))
                   (_g4244_ (macro-repl-channel-last-owner-set!
                             _channel491_
                             _thread483_))
                   (_state494_
                    (let ()
                      (declare (not safe))
                      (##structure
                       std/net/repl#repl-state::t
                       _client482_
                       _channel491_
                       '#f
                       '#f)))
                   (_reader497_
                    (make-thread
                     (lambda ()
                       (std/net/repl#repl-client-reader
                        _state494_
                        _client482_
                        _in-wr486_
                        _thread483_))
                     'repl-client-reader)))
              (##direct-structure-set!
               _state494_
               _reader497_
               '3
               std/net/repl#repl-state::t
               '#f)
              _state494_))))))
  (define std/net/repl#repl-context-command
    (lambda (_repl-context474_ _src475_)
      (if (eof-object? _src475_)
          (let ((_$e477_ (std/net/repl#repl-client-state__0)))
            (if _$e477_
                ((lambda (_state480_)
                   (if (##direct-structure-ref
                        _state480_
                        '4
                        std/net/repl#repl-state::t
                        '#f)
                       (let ()
                         (declare (not safe))
                         (##repl-context-return _repl-context474_ '#!void))
                       (begin
                         (let () (declare (not safe)) (##repl-channel-newline))
                         (if (fx< '0
                                  (macro-repl-context-level _repl-context474_))
                             (let ()
                               (declare (not safe))
                               (##repl-cmd-d _repl-context474_))
                             (if (let ()
                                   (declare (not safe))
                                   (##repl-channel-really-exit?))
                                 (let ()
                                   (declare (not safe))
                                   (##repl-context-return
                                    _repl-context474_
                                    '#!void))
                                 (let ()
                                   (declare (not safe))
                                   (##repl-context-prompt
                                    _repl-context474_)))))))
                 _$e477_)
                (let ()
                  (declare (not safe))
                  (##default-repl-context-command
                   _repl-context474_
                   _src475_))))
          (let ()
            (declare (not safe))
            (##default-repl-context-command _repl-context474_ _src475_)))))
  (let ()
    (declare (not safe))
    (##repl-context-command-set! std/net/repl#repl-context-command))
  (define std/net/repl#make-repl-channel
    (lambda (_thread469_)
      (let ((_$e471_ (std/net/repl#repl-client-state__% _thread469_)))
        (if _$e471_
            (##direct-structure-ref _$e471_ '2 std/net/repl#repl-state::t '#f)
            (let ()
              (declare (not safe))
              (##default-thread-make-repl-channel _thread469_))))))
  (let ()
    (declare (not safe))
    (##thread-make-repl-channel-set! std/net/repl#make-repl-channel))
  (define std/net/repl#repl-client-state__%
    (lambda (_thread450_)
      (let _lp452_ ((_tgroup454_ (thread-thread-group _thread450_)))
        (if (not _tgroup454_)
            '#f
            (let ((_$e456_ (thread-group-specific _tgroup454_)))
              (if _$e456_
                  ((lambda (_state459_)
                     (if (let ()
                           (declare (not safe))
                           (##structure-direct-instance-of?
                            _state459_
                            'std/net/repl#repl-state::t))
                         _state459_
                         (_lp452_ (thread-group-parent _tgroup454_))))
                   _$e456_)
                  (_lp452_ (thread-group-parent _tgroup454_))))))))
  (define std/net/repl#repl-client-state__0
    (lambda ()
      (let ((_thread465_ (current-thread)))
        (std/net/repl#repl-client-state__% _thread465_))))
  (define std/net/repl#repl-client-state
    (lambda _g4246_
      (let ((_g4245_ (let () (declare (not safe)) (##length _g4246_))))
        (cond ((let () (declare (not safe)) (##fx= _g4245_ 0))
               (apply std/net/repl#repl-client-state__0 _g4246_))
              ((let () (declare (not safe)) (##fx= _g4245_ 1))
               (apply std/net/repl#repl-client-state__% _g4246_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/repl#repl-client-state
                _g4246_))))))
  (define std/net/repl#taint!__%
    (lambda (_tgroup426_)
      (let ((_$e428_ (std/net/repl#repl-client-state__0)))
        (if _$e428_
            ((lambda (_state431_)
               (let* ((_tgroup436_
                       (let ((_$e433_ _tgroup426_))
                         (if _$e433_
                             _$e433_
                             (std/misc/threads#primordial-thread-group))))
                      (_ostate438_ (thread-group-specific _tgroup436_)))
                 (thread-group-specific-set! _tgroup436_ _state431_)
                 _ostate438_))
             _$e428_)
            (error '"No repl state")))))
  (define std/net/repl#taint!__0
    (lambda () (let ((_tgroup445_ '#f)) (std/net/repl#taint!__% _tgroup445_))))
  (define std/net/repl#taint!
    (lambda _g4248_
      (let ((_g4247_ (let () (declare (not safe)) (##length _g4248_))))
        (cond ((let () (declare (not safe)) (##fx= _g4247_ 0))
               (apply std/net/repl#taint!__0 _g4248_))
              ((let () (declare (not safe)) (##fx= _g4247_ 1))
               (apply std/net/repl#taint!__% _g4248_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/repl#taint!
                _g4248_))))))
  (define std/net/repl#untaint!__%
    (lambda (_tgroup402_ _state403_)
      (let ((_tgroup408_
             (let ((_$e405_ _tgroup402_))
               (if _$e405_
                   _$e405_
                   (std/misc/threads#primordial-thread-group)))))
        (if (let ((__tmp4249 (thread-group-specific _tgroup408_)))
              (declare (not safe))
              (##structure-direct-instance-of?
               __tmp4249
               'std/net/repl#repl-state::t))
            (thread-group-specific-set! _tgroup408_ _state403_)
            (error '"No tainted repl state in thread-group" _tgroup408_)))))
  (define std/net/repl#untaint!__0
    (lambda ()
      (let* ((_tgroup414_ '#f) (_state416_ '#f))
        (std/net/repl#untaint!__% _tgroup414_ _state416_))))
  (define std/net/repl#untaint!__1
    (lambda (_tgroup418_)
      (let ((_state420_ '#f))
        (std/net/repl#untaint!__% _tgroup418_ _state420_))))
  (define std/net/repl#untaint!
    (lambda _g4251_
      (let ((_g4250_ (let () (declare (not safe)) (##length _g4251_))))
        (cond ((let () (declare (not safe)) (##fx= _g4250_ 0))
               (apply std/net/repl#untaint!__0 _g4251_))
              ((let () (declare (not safe)) (##fx= _g4250_ 1))
               (apply std/net/repl#untaint!__1 _g4251_))
              ((let () (declare (not safe)) (##fx= _g4250_ 2))
               (apply std/net/repl#untaint!__% _g4251_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/repl#untaint!
                _g4251_)))))))
