/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.transformers.IntegerLiteralTypeApproximationTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.IntegerLiteralTypeApproximationTransformerKt;
import org.jetbrains.kotlin.fir.resolve.transformers.IntegerOperatorsTypeUpdater$WhenMappings;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerOperator;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralTypeImpl;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J/\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\f\u001a\u0002H\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerOperatorsTypeUpdater;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "approximator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralTypeApproximationTransformer;", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralTypeApproximationTransformer;)V", "getApproximator", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralTypeApproximationTransformer;", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformFunctionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "resolve"})
public final class IntegerOperatorsTypeUpdater
extends FirTransformer {
    @NotNull
    private final IntegerLiteralTypeApproximationTransformer approximator;

    @NotNull
    public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(element, (String)"element");
        E $this$compose$iv = element;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompositeTransformResult<FirStatement> transformFunctionCall(@NotNull FirFunctionCall functionCall, @Nullable Void data) {
        void $this$resultType$iv;
        Object argumentType;
        long l;
        block30: {
            void $this$resultType$iv2;
            block31: {
                FirIntegerOperator.Kind kind;
                long receiverValue;
                block29: {
                    Intrinsics.checkParameterIsNotNull((Object)functionCall, (String)"functionCall");
                    FirCallableDeclaration<?> firCallableDeclaration = IntegerLiteralTypeApproximationTransformerKt.getOriginalFunction(functionCall);
                    if (firCallableDeclaration == null) {
                        FirElement $this$compose$iv = functionCall;
                        boolean $i$f$compose = false;
                        return CompositeTransformResult.Companion.single($this$compose$iv);
                    }
                    FirCallableDeclaration<?> function2 = firCallableDeclaration;
                    if (!(function2 instanceof FirIntegerOperator)) {
                        ConeKotlinType coneKotlinType;
                        FirTypeRef firTypeRef = function2.getReceiverTypeRef();
                        if (firTypeRef != null) {
                            FirTypeRef $this$coneTypeSafe$iv = firTypeRef;
                            boolean $i$f$coneTypeSafe = false;
                            FirTypeRef firTypeRef2 = $this$coneTypeSafe$iv;
                            if (!(firTypeRef2 instanceof FirResolvedTypeRef)) {
                                firTypeRef2 = null;
                            }
                            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef2;
                            coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                            if (!(coneKotlinType instanceof ConeKotlinType)) {
                                coneKotlinType = null;
                            }
                        } else {
                            coneKotlinType = null;
                        }
                        ConeKotlinType expectedType = coneKotlinType;
                        FirElement $this$compose$iv = functionCall.transformExplicitReceiver(this.approximator, expectedType);
                        boolean $i$f$compose = false;
                        return CompositeTransformResult.Companion.single($this$compose$iv);
                    }
                    FirExpression firExpression2 = functionCall.getExplicitReceiver();
                    if (firExpression2 == null) {
                        Intrinsics.throwNpe();
                    }
                    FirTypeRef $this$coneTypeSafe$iv = firExpression2.getTypeRef();
                    boolean $i$f$coneTypeSafe = false;
                    FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                    if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                        firTypeRef = null;
                    }
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeIntegerLiteralType)) {
                        coneKotlinType = null;
                    }
                    ConeIntegerLiteralType coneIntegerLiteralType = (ConeIntegerLiteralType)((ConeKotlinType)((ConeIntegerLiteralType)coneKotlinType));
                    if (coneIntegerLiteralType == null) {
                        FirElement $this$compose$iv = functionCall;
                        boolean $i$f$compose = false;
                        return CompositeTransformResult.Companion.single($this$compose$iv);
                    }
                    receiverValue = coneIntegerLiteralType.getValue();
                    kind = ((FirIntegerOperator)function2).getKind();
                    if (!kind.getUnary()) break block29;
                    switch (IntegerOperatorsTypeUpdater$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                        case 1: {
                            l = receiverValue;
                            break block30;
                        }
                        case 2: {
                            l = -receiverValue;
                            break block30;
                        }
                        case 3: {
                            l = receiverValue ^ 0xFFFFFFFFFFFFFFFFL;
                            break block30;
                        }
                        default: {
                            throw (Throwable)new IllegalStateException();
                        }
                    }
                }
                Object $this$coneTypeUnsafe$iv = ((FirExpression)CollectionsKt.first(functionCall.getArguments())).getTypeRef();
                boolean $i$f$coneTypeUnsafe = false;
                ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
                if (coneKotlinType == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                argumentType = coneKotlinType;
                $this$coneTypeUnsafe$iv = argumentType;
                if (!($this$coneTypeUnsafe$iv instanceof ConeIntegerLiteralType)) break block31;
                long argumentValue = ((ConeIntegerLiteralType)argumentType).getValue();
                boolean divisionByZero = argumentValue == 0L;
                switch (IntegerOperatorsTypeUpdater$WhenMappings.$EnumSwitchMapping$1[kind.ordinal()]) {
                    case 1: {
                        l = receiverValue + argumentValue;
                        break block30;
                    }
                    case 2: {
                        l = receiverValue - argumentValue;
                        break block30;
                    }
                    case 3: {
                        l = receiverValue * argumentValue;
                        break block30;
                    }
                    case 4: {
                        l = divisionByZero ? receiverValue : receiverValue / argumentValue;
                        break block30;
                    }
                    case 5: {
                        l = divisionByZero ? receiverValue : receiverValue % argumentValue;
                        break block30;
                    }
                    case 6: {
                        l = receiverValue << (int)argumentValue;
                        break block30;
                    }
                    case 7: {
                        l = receiverValue >> (int)argumentValue;
                        break block30;
                    }
                    case 8: {
                        l = receiverValue >>> (int)argumentValue;
                        break block30;
                    }
                    case 9: {
                        l = receiverValue ^ argumentValue;
                        break block30;
                    }
                    case 10: {
                        l = receiverValue & argumentValue;
                        break block30;
                    }
                    case 11: {
                        l = receiverValue | argumentValue;
                        break block30;
                    }
                    default: {
                        throw (Throwable)new IllegalStateException();
                    }
                }
            }
            Object object = ConeTypeUtilsKt.getClassId((ConeKotlinType)argumentType);
            Object expectedType = Intrinsics.areEqual((Object)object, (Object)StandardClassIds.INSTANCE.getLong()) ? argumentType : (ConeKotlinType)ConeIntegerLiteralTypeImpl.Companion.createType(StandardClassIds.INSTANCE.getInt());
            FirTransformerUtilKt.transformSingle((FirElement)functionCall, this.approximator, expectedType);
            object = functionCall;
            FirFunctionCall firFunctionCall = functionCall;
            boolean $i$f$getResultType = false;
            FirTypeRef firTypeRef = $this$resultType$iv2.getTypeRef();
            firFunctionCall.replaceTypeRef(CopyUtilsKt.resolvedTypeFromPrototype(firTypeRef, (ConeKotlinType)expectedType));
            FirElement $this$compose$iv = functionCall;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        long resultValue = l;
        argumentType = functionCall;
        FirFunctionCall firFunctionCall = functionCall;
        boolean $i$f$getResultType = false;
        FirTypeRef firTypeRef = $this$resultType$iv.getTypeRef();
        firFunctionCall.replaceTypeRef(CopyUtilsKt.resolvedTypeFromPrototype(firTypeRef, new ConeIntegerLiteralTypeImpl(resultValue)));
        FirElement $this$compose$iv = IntegerLiteralTypeApproximationTransformerKt.access$toOperatorCall(functionCall);
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @NotNull
    public final IntegerLiteralTypeApproximationTransformer getApproximator() {
        return this.approximator;
    }

    public IntegerOperatorsTypeUpdater(@NotNull IntegerLiteralTypeApproximationTransformer approximator2) {
        Intrinsics.checkParameterIsNotNull((Object)approximator2, (String)"approximator");
        this.approximator = approximator2;
    }
}

