/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.maven.MavenDeployment;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.artifacts.maven.PomFilterContainer;
import org.gradle.api.publication.maven.internal.ArtifactPom;
import org.gradle.api.publication.maven.internal.ArtifactPomContainer;
import org.gradle.api.publication.maven.internal.ArtifactPomFactory;
import org.gradle.api.publication.maven.internal.DefaultMavenDeployment;
import org.gradle.api.publication.maven.internal.MavenPomMetaInfoProvider;
import org.gradle.api.publication.maven.internal.PomFilter;
import org.gradle.api.publish.maven.internal.publication.ReadableMavenProjectIdentity;

public class DefaultArtifactPomContainer
implements ArtifactPomContainer {
    private Map<String, ArtifactPom> artifactPoms = new HashMap<String, ArtifactPom>();
    private final MavenPomMetaInfoProvider pomMetaInfoProvider;
    private PomFilterContainer pomFilterContainer;
    private ArtifactPomFactory artifactPomFactory;

    public DefaultArtifactPomContainer(MavenPomMetaInfoProvider pomMetaInfoProvider, PomFilterContainer pomFilterContainer, ArtifactPomFactory artifactPomFactory) {
        this.pomMetaInfoProvider = pomMetaInfoProvider;
        this.pomFilterContainer = pomFilterContainer;
        this.artifactPomFactory = artifactPomFactory;
    }

    @Override
    public void addArtifact(Artifact artifact, File src) {
        if (artifact == null || src == null) {
            throw new InvalidUserDataException("Artifact or source file must not be null!");
        }
        for (PomFilter activePomFilter : this.pomFilterContainer.getActivePomFilters()) {
            if (!activePomFilter.getFilter().accept(artifact, src)) continue;
            if (this.artifactPoms.get(activePomFilter.getName()) == null) {
                this.artifactPoms.put(activePomFilter.getName(), this.artifactPomFactory.createArtifactPom(activePomFilter.getPomTemplate()));
            }
            this.artifactPoms.get(activePomFilter.getName()).addArtifact(artifact, src);
        }
    }

    @Override
    public Set<MavenDeployment> createDeployableFilesInfos() {
        HashSet<MavenDeployment> mavenDeployments = new HashSet<MavenDeployment>();
        for (String activeArtifactPomName : this.artifactPoms.keySet()) {
            ArtifactPom activeArtifactPom = this.artifactPoms.get(activeArtifactPomName);
            File pomFile = this.createPomFile(activeArtifactPomName);
            MavenPom mavenPom = activeArtifactPom.getPom();
            String packaging = mavenPom.getPackaging();
            ReadableMavenProjectIdentity projectIdentity = new ReadableMavenProjectIdentity(mavenPom.getGroupId(), mavenPom.getArtifactId(), mavenPom.getVersion());
            PublishArtifact pomArtifact = activeArtifactPom.writePom(pomFile);
            mavenDeployments.add(new DefaultMavenDeployment(packaging, projectIdentity, pomArtifact, activeArtifactPom.getArtifact(), activeArtifactPom.getAttachedArtifacts()));
        }
        return mavenDeployments;
    }

    private File createPomFile(String artifactPomName) {
        return new File(this.pomMetaInfoProvider.getMavenPomDir(), "pom-" + artifactPomName + ".xml");
    }
}

