/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.grouping.core;

import com.projectlibre1.grouping.core.GroupNodeImpl;
import com.projectlibre1.grouping.core.LazyParent;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.NodeException;
import com.projectlibre1.grouping.core.NodeVisitor;
import com.projectlibre1.grouping.core.VoidNodeImpl;
import com.projectlibre1.grouping.core.model.NodeModelUtil;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.resource.Resource;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.server.data.DataObject;
import java.util.List;
import java.util.ListIterator;
import javax.swing.tree.DefaultMutableTreeNode;

public class NodeBridge
extends DefaultMutableTreeNode
implements Node {
    protected boolean virtual = false;
    protected boolean voidNode = false;
    protected boolean root = false;
    protected transient boolean lazyParent = false;
    protected int subprojectLevel;

    NodeBridge(Object object) {
        this.setImpl(object);
    }

    NodeBridge(Object object, boolean bl) {
        this(object);
        this.virtual = bl;
    }

    @Override
    public boolean isVirtual() {
        return this.virtual;
    }

    @Override
    public void setVirtual(boolean bl) {
        this.virtual = bl;
    }

    @Override
    public boolean isVoid() {
        return this.voidNode;
    }

    @Override
    public void setVoid(boolean bl) {
        this.voidNode = bl;
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    @Override
    public void setRoot(boolean bl) {
        this.root = bl;
    }

    @Override
    public Class getType() throws NodeException {
        Object object = this.getUserObject();
        if (object == null) {
            throw new NodeException("No Implementation");
        }
        return object.getClass();
    }

    @Override
    public void accept(NodeVisitor nodeVisitor) {
        nodeVisitor.execute(this);
    }

    @Override
    public String toString() {
        Object object = this.getUserObject();
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    @Override
    public Object getImpl() {
        return this.getUserObject();
    }

    @Override
    public void setImpl(Object object) {
        this.virtual = object instanceof GroupNodeImpl;
        this.voidNode = object instanceof VoidNodeImpl;
        this.setUserObject(object);
    }

    static ListIterator emptyListIterator() {
        return new ListIterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void add(Object object) {
            }

            @Override
            public boolean hasPrevious() {
                return false;
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            public Object previous() {
                return null;
            }

            @Override
            public int previousIndex() {
                return -1;
            }

            public void set(Object object) {
            }
        };
    }

    @Override
    public ListIterator childrenIterator() {
        return this.children == null ? NodeBridge.emptyListIterator() : this.children.listIterator();
    }

    @Override
    public ListIterator childrenIterator(int n) {
        return this.children == null ? NodeBridge.emptyListIterator() : this.children.listIterator(n);
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public boolean isIndentable(int n) {
        if (n != 1 && n != -1) {
            return false;
        }
        return !this.root && !this.voidNode && !this.virtual && !(this.getImpl() instanceof Assignment);
    }

    @Override
    public boolean canBeChildOf(Node node) {
        if (node.isVoid()) {
            return false;
        }
        return NodeModelUtil.canBeChildOf(node, this);
    }

    @Override
    public boolean isDirty() {
        Object object = this.getImpl();
        if (object instanceof DataObject) {
            return ((DataObject)object).isDirty();
        }
        return false;
    }

    @Override
    public void setDirty(boolean bl) {
        Object object = this.getImpl();
        if (object instanceof DataObject) {
            ((DataObject)object).setDirty(bl);
        }
    }

    @Override
    public final boolean isLazyParent() {
        return this.getImpl() instanceof LazyParent;
    }

    public final boolean isValidLazyParent() {
        return this.getImpl() instanceof LazyParent && ((LazyParent)this.getImpl()).isValid();
    }

    @Override
    public boolean hasNumber() {
        Object object = this.getImpl();
        return object instanceof Task || object instanceof Resource;
    }

    @Override
    public int getSubprojectLevel() {
        return this.subprojectLevel;
    }

    @Override
    public void setSubprojectLevel(int n) {
        this.subprojectLevel = n;
    }

    @Override
    public boolean isInSubproject() {
        return this.getSubprojectLevel() > 0;
    }
}

