/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

public class LabelWidget
extends Widget {
    private String label;
    private Alignment alignment = Alignment.LEFT;
    private VerticalAlignment verticalAlignment = VerticalAlignment.BASELINE;
    private Orientation orientation = Orientation.NORMAL;
    private boolean paintAsDisabled;
    private boolean useGlyphVector = false;
    private GlyphVector cacheGlyphVector;
    private String cacheLabel;
    private Font cacheFont;

    public LabelWidget(Scene scene) {
        this(scene, null);
    }

    public LabelWidget(Scene scene, String string) {
        super(scene);
        this.setOpaque(false);
        this.setLabel(string);
        this.setCheckClipping(true);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        if (GeomUtil.equals(this.label, string)) {
            return;
        }
        this.label = string;
        this.revalidate();
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
        this.repaint();
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.repaint();
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.revalidate();
    }

    public boolean isPaintAsDisabled() {
        return this.paintAsDisabled;
    }

    public void setPaintAsDisabled(boolean bl) {
        boolean bl2 = this.paintAsDisabled != bl;
        this.paintAsDisabled = bl;
        if (bl2) {
            this.repaint();
        }
    }

    public boolean isUseGlyphVector() {
        return this.useGlyphVector;
    }

    public void setUseGlyphVector(boolean bl) {
        if (this.useGlyphVector == bl) {
            return;
        }
        this.useGlyphVector = bl;
        this.cacheGlyphVector = null;
        this.cacheLabel = null;
        this.cacheFont = null;
        this.revalidate();
    }

    private void assureGlyphVector() {
        Font font = this.getFont();
        FontRenderContext fontRenderContext = this.getGraphics().getFontRenderContext();
        if (this.cacheGlyphVector != null && this.cacheFont == font && this.cacheLabel == this.label) {
            return;
        }
        this.cacheFont = font;
        this.cacheLabel = this.label;
        this.cacheGlyphVector = font.createGlyphVector(new FontRenderContext(new AffineTransform(), fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics()), this.cacheLabel);
    }

    protected Rectangle calculateClientArea() {
        Rectangle rectangle;
        if (this.label == null) {
            return super.calculateClientArea();
        }
        if (this.useGlyphVector) {
            this.assureGlyphVector();
            rectangle = GeomUtil.roundRectangle(this.cacheGlyphVector.getVisualBounds());
            rectangle.grow(1, 1);
        } else {
            Graphics2D graphics2D = this.getGraphics();
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getFont());
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.label, graphics2D);
            rectangle = GeomUtil.roundRectangle(rectangle2D);
        }
        switch (this.orientation) {
            case NORMAL: {
                return rectangle;
            }
            case ROTATE_90: {
                return new Rectangle(rectangle.y, -rectangle.x - rectangle.width, rectangle.height, rectangle.width);
            }
        }
        throw new IllegalStateException();
    }

    protected void paintWidget() {
        int n;
        int n2;
        if (this.label == null) {
            return;
        }
        Graphics2D graphics2D = this.getGraphics();
        if (this.useGlyphVector) {
            this.assureGlyphVector();
        } else {
            graphics2D.setFont(this.getFont());
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle rectangle = this.getClientArea();
        block0 : switch (this.orientation) {
            case NORMAL: {
                switch (this.alignment) {
                    case BASELINE: {
                        n2 = 0;
                        break;
                    }
                    case LEFT: {
                        n2 = rectangle.x;
                        break;
                    }
                    case CENTER: {
                        if (this.useGlyphVector) {
                            n2 = rectangle.x + (rectangle.width - this.getCacheGlyphVectorWidth()) / 2;
                            break;
                        }
                        n2 = rectangle.x + (rectangle.width - fontMetrics.stringWidth(this.label)) / 2;
                        break;
                    }
                    case RIGHT: {
                        if (this.useGlyphVector) {
                            n2 = rectangle.x + rectangle.width - this.getCacheGlyphVectorWidth();
                            break;
                        }
                        n2 = rectangle.x + rectangle.width - fontMetrics.stringWidth(this.label);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                switch (this.verticalAlignment) {
                    case BASELINE: {
                        n = 0;
                        break block0;
                    }
                    case TOP: {
                        n = rectangle.y + fontMetrics.getAscent();
                        break block0;
                    }
                    case CENTER: {
                        n = rectangle.y + (rectangle.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                        break block0;
                    }
                    case BOTTOM: {
                        n = rectangle.y + rectangle.height - fontMetrics.getDescent();
                        break block0;
                    }
                }
                return;
            }
            case ROTATE_90: {
                switch (this.alignment) {
                    case BASELINE: {
                        n2 = 0;
                        break;
                    }
                    case LEFT: {
                        n2 = rectangle.x + fontMetrics.getAscent();
                        break;
                    }
                    case CENTER: {
                        n2 = rectangle.x + (rectangle.width + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                        break;
                    }
                    case RIGHT: {
                        n2 = rectangle.x + rectangle.width - fontMetrics.getDescent();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                switch (this.verticalAlignment) {
                    case BASELINE: {
                        n = 0;
                        break block0;
                    }
                    case TOP: {
                        if (this.useGlyphVector) {
                            n = rectangle.y + this.getCacheGlyphVectorWidth();
                            break block0;
                        }
                        n = rectangle.y + fontMetrics.stringWidth(this.label);
                        break block0;
                    }
                    case CENTER: {
                        if (this.useGlyphVector) {
                            n = rectangle.y + (rectangle.height + this.getCacheGlyphVectorWidth()) / 2;
                            break block0;
                        }
                        n = rectangle.y + (rectangle.height + fontMetrics.stringWidth(this.label)) / 2;
                        break block0;
                    }
                    case BOTTOM: {
                        n = rectangle.y + rectangle.height;
                        break block0;
                    }
                }
                return;
            }
            default: {
                return;
            }
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(n2, n);
        switch (this.orientation) {
            case NORMAL: {
                break;
            }
            case ROTATE_90: {
                graphics2D.rotate(-1.5707963267948966);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Paint paint = this.getBackground();
        if (this.paintAsDisabled && paint instanceof Color) {
            Color color = (Color)paint;
            graphics2D.setColor(color.brighter());
            if (this.useGlyphVector) {
                graphics2D.fill(this.cacheGlyphVector.getOutline(1.0f, 1.0f));
            } else {
                graphics2D.drawString(this.label, 1, 1);
            }
            graphics2D.setColor(color.darker());
            if (this.useGlyphVector) {
                graphics2D.fill(this.cacheGlyphVector.getOutline());
            } else {
                graphics2D.drawString(this.label, 0, 0);
            }
        } else {
            graphics2D.setColor(this.getForeground());
            if (this.useGlyphVector) {
                graphics2D.fill(this.cacheGlyphVector.getOutline());
            } else {
                graphics2D.drawString(this.label, 0, 0);
            }
        }
        graphics2D.setTransform(affineTransform);
    }

    private int getCacheGlyphVectorWidth() {
        return GeomUtil.roundRectangle((Rectangle2D)this.cacheGlyphVector.getVisualBounds()).width;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        BASELINE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        NORMAL,
        ROTATE_90;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerticalAlignment {
        TOP,
        BOTTOM,
        CENTER,
        BASELINE;

    }
}

