/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class Tt8850ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().binary("0004,").number("xxxx,").expression("[01],").expression("GT...,").number("(?:[0-9A-Z]{2}xxxx)?,").expression("([^,]+),").any().number("(d{1,2})?,").number("(d{1,3}.d)?,").number("(d{1,3})?,").number("(-?d{1,5}.d)?,").number("(-?d{1,3}.d{6}),").number("(-?d{1,2}.d{6}),").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").number("(0ddd)?,").number("(0ddd)?,").number("(xxxx)?,").number("(xxxx)?,").any().number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").number("(xxxx)").compile();

    public Tt8850ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(true);
        position.setAccuracy(parser.nextInt(0));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setLatitude(parser.nextDouble(0.0));
        position.setTime(parser.nextDateTime());
        if (parser.hasNext(4)) {
            position.setNetwork(new Network(CellTower.from(parser.nextInt(0), parser.nextInt(0), parser.nextHexInt(0), parser.nextHexInt(0))));
        }
        return position;
    }
}

