/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.util.ArrayList;
import org.w3c.css.properties.css3.CssBackgroundPosition;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssColorCSS3;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssImage
extends CssValue {
    public static final int type = 16;
    static final CssIdent to = CssIdent.getIdent("to");
    static final CssIdent left = CssIdent.getIdent("left");
    static final CssIdent right = CssIdent.getIdent("right");
    static final CssIdent top = CssIdent.getIdent("top");
    static final CssIdent bottom = CssIdent.getIdent("bottom");
    static final CssIdent at = CssIdent.getIdent("at");
    static final CssIdent circle = CssIdent.getIdent("circle");
    static final CssIdent ellipse = CssIdent.getIdent("ellipse");
    static final CssIdent[] extent_keywords;
    String name;
    CssValue value;
    private String _cache;

    @Override
    public final int getType() {
        return 16;
    }

    public static boolean isVerticalIdent(CssIdent ident) {
        return ident.equals(top) || ident.equals(bottom);
    }

    public static CssIdent getLinearGradientIdent(CssIdent ident) {
        if (left.equals(ident)) {
            return left;
        }
        if (right.equals(ident)) {
            return right;
        }
        if (top.equals(ident)) {
            return top;
        }
        if (bottom.equals(ident)) {
            return bottom;
        }
        return null;
    }

    public static CssIdent getExtentIdent(CssIdent ident) {
        for (CssIdent id : extent_keywords) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getShape(CssIdent ident) {
        if (circle.equals(ident)) {
            return circle;
        }
        if (ellipse.equals(ident)) {
            return ellipse;
        }
        return null;
    }

    @Override
    public void set(String s, ApplContext ac) {
    }

    public void setImageList(CssExpression exp, ApplContext ac) throws InvalidParamException {
        this.name = "image";
        this._cache = null;
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append('(').append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        boolean gotcolor = false;
        ArrayList<CssValue> v = new ArrayList<CssValue>();
        while (!exp.end()) {
            CssValue val = exp.getValue();
            char op = exp.getOperator();
            if (gotcolor) {
                throw new InvalidParamException("value", val.toString(), "image()", ac);
            }
            switch (val.getType()) {
                case 1: 
                case 2: {
                    v.add(val);
                    break;
                }
                case 15: {
                    CssColor c = new CssColor();
                    c.setShortRGBColor(ac, val.toString());
                    v.add(c);
                    gotcolor = true;
                    break;
                }
                case 3: {
                    v.add(val);
                    gotcolor = true;
                    break;
                }
                case 0: {
                    if (CssColorCSS3.currentColor.equals((CssIdent)val)) {
                        v.add(val);
                        gotcolor = true;
                        break;
                    }
                    CssColor c = new CssColor();
                    c.setIdentColor(ac, val.toString());
                    v.add(c);
                    gotcolor = true;
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), "image()", ac);
                }
            }
            exp.next();
            if (exp.end() || op == ',') continue;
            exp.starts();
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        this.value = v.size() == 1 ? (CssValue)v.get(0) : new CssLayerList(v);
    }

    public void setLinearGradient(CssExpression exp, ApplContext ac) throws InvalidParamException {
        this.name = "linear-gradient";
        this._cache = null;
        this._setLinearGradient(exp, ac);
    }

    public void setRepeatingLinearGradient(CssExpression exp, ApplContext ac) throws InvalidParamException {
        this.name = "repeating-linear-gradient";
        this._cache = null;
        this._setLinearGradient(exp, ac);
    }

    private void _setLinearGradient(CssExpression exp, ApplContext ac) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append('(').append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        ArrayList<CssValue> v = new ArrayList<CssValue>();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        switch (val.getType()) {
            case 5: {
                val.getAngle();
            }
            case 7: {
                v.add(val);
                if (op != ',') {
                    exp.starts();
                    throw new InvalidParamException("operator", new Character(op).toString(), ac);
                }
                exp.next();
                break;
            }
            case 0: {
                CssIdent ident = (CssIdent)val;
                if (to.equals(ident)) {
                    CssValueList vl = new CssValueList();
                    vl.add(to);
                    CssIdent v1 = null;
                    CssIdent v2 = null;
                    if (op != ' ') {
                        exp.starts();
                        throw new InvalidParamException("operator", new Character(op).toString(), ac);
                    }
                    exp.next();
                    if (exp.end()) {
                        throw new InvalidParamException("few-value", this.name, ac);
                    }
                    val = exp.getValue();
                    op = exp.getOperator();
                    if (val.getType() != 0) {
                        throw new InvalidParamException("value", val.toString(), this.name, ac);
                    }
                    v1 = CssImage.getLinearGradientIdent((CssIdent)val);
                    if (v1 == null) {
                        throw new InvalidParamException("value", val.toString(), this.name, ac);
                    }
                    vl.add(v1);
                    boolean isV1Vertical = CssImage.isVerticalIdent(v1);
                    exp.next();
                    if (exp.end()) {
                        throw new InvalidParamException("few-value", this.name, ac);
                    }
                    if (op == ' ') {
                        val = exp.getValue();
                        op = exp.getOperator();
                        if (val.getType() != 0) {
                            throw new InvalidParamException("value", val.toString(), this.name, ac);
                        }
                        v2 = CssImage.getLinearGradientIdent((CssIdent)val);
                        if (v2 == null) {
                            throw new InvalidParamException("value", val.toString(), this.name, ac);
                        }
                        boolean isV2Vertical = CssImage.isVerticalIdent(v2);
                        if (isV1Vertical && isV2Vertical || !isV1Vertical && !isV2Vertical) {
                            throw new InvalidParamException("value", val.toString(), this.name, ac);
                        }
                        vl.add(v2);
                        exp.next();
                    }
                    v.add(vl);
                    if (op != ',') {
                        exp.starts();
                        throw new InvalidParamException("operator", new Character(op).toString(), ac);
                    }
                }
                if (!top.equals(ident) && !bottom.equals(ident) && !left.equals(ident) && !right.equals(ident)) break;
                throw new InvalidParamException("linear-gradient-missing-to", "to " + ident, ident, ac);
            }
        }
        ArrayList<CssValue> stops = this.parseColorStops(exp, ac);
        if (stops.size() < 2) {
            throw new InvalidParamException("few-value", this.name, ac);
        }
        v.addAll(stops);
        this.value = new CssLayerList(v);
    }

    public void setRadialGradient(CssExpression exp, ApplContext ac) throws InvalidParamException {
        this.name = "radial-gradient";
        this._cache = null;
        this._setRadialGradient(exp, ac);
    }

    public void setRepeatingRadialGradient(CssExpression exp, ApplContext ac) throws InvalidParamException {
        this.name = "repeating-radial-gradient";
        this._cache = null;
        this._setRadialGradient(exp, ac);
    }

    private void _setRadialGradient(CssExpression exp, ApplContext ac) throws InvalidParamException {
        ArrayList<CssValue> stops;
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append('(').append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        ArrayList<CssValue> v = new ArrayList<CssValue>();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        boolean parse_prolog = false;
        switch (val.getType()) {
            case 5: {
                val.getLength();
            }
            case 4: 
            case 6: {
                parse_prolog = true;
                break;
            }
            case 0: {
                CssIdent id = (CssIdent)val;
                boolean bl = parse_prolog = at.equals(id) || CssImage.getShape(id) != null || CssImage.getExtentIdent(id) != null;
            }
        }
        if (parse_prolog) {
            CssExpression newexp = new CssExpression();
            boolean done = false;
            while (!done && !exp.end()) {
                val = exp.getValue();
                op = exp.getOperator();
                newexp.addValue(val);
                done = op == ',';
                exp.next();
            }
            v.add(this.parseRadialProlog(newexp, ac));
        }
        if ((stops = this.parseColorStops(exp, ac)).size() < 2) {
            throw new InvalidParamException("few-value", this.name, ac);
        }
        v.addAll(stops);
        this.value = new CssLayerList(v);
    }

    private CssValue parseRadialProlog(CssExpression expression, ApplContext ac) throws InvalidParamException {
        CssIdent shape = null;
        CssValue extend = null;
        CssValue extend2 = null;
        CssValue atPosition = null;
        ArrayList<CssValue> v = new ArrayList<CssValue>();
        boolean shapeInMiddle = false;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            switch (val.getType()) {
                case 4: {
                    if (shapeInMiddle) {
                        throw new InvalidParamException("value", val, this.name, ac);
                    }
                    CssPercentage p = val.getPercentage();
                    if (!p.isPositive()) {
                        throw new InvalidParamException("negative-value", val, this.name, ac);
                    }
                    if (extend == null) {
                        extend = val;
                        break;
                    }
                    if (extend2 == null) {
                        extend2 = val;
                        break;
                    }
                    throw new InvalidParamException("value", val, this.name, ac);
                }
                case 5: 
                case 6: {
                    if (shapeInMiddle) {
                        throw new InvalidParamException("value", val, this.name, ac);
                    }
                    CssLength l = val.getLength();
                    if (!l.isPositive()) {
                        throw new InvalidParamException("negative-value", val, this.name, ac);
                    }
                    if (extend == null) {
                        extend = val;
                        break;
                    }
                    if (extend.getType() == 0) {
                        throw new InvalidParamException("value", val, this.name, ac);
                    }
                    if (extend2 == null) {
                        extend2 = val;
                        break;
                    }
                    throw new InvalidParamException("value", val, this.name, ac);
                }
                case 0: {
                    CssIdent id = (CssIdent)val;
                    if (at.equals(id)) {
                        CssExpression exp = new CssExpression();
                        expression.next();
                        while (!expression.end()) {
                            exp.addValue(expression.getValue());
                            expression.next();
                        }
                        atPosition = this.checkPosition(exp, ac);
                        break;
                    }
                    if (shape == null && (shape = CssImage.getShape(id)) != null) {
                        shapeInMiddle = expression.getCount() != expression.getRemainingCount();
                        break;
                    }
                    if (extend == null && (extend = CssImage.getExtentIdent(id)) != null) {
                        if (!shapeInMiddle) break;
                        throw new InvalidParamException("value", val, this.name, ac);
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.name, ac);
                }
            }
            expression.next();
        }
        if (shape == circle && (extend2 != null || extend != null && extend.getType() == 4)) {
            throw new InvalidParamException("value", expression.toStringFromStart(), this.name, ac);
        }
        if (shape == ellipse && extend2 == null && extend != null && extend.getType() != 0) {
            throw new InvalidParamException("value", expression.toStringFromStart(), this.name, ac);
        }
        if (shape == null && extend2 == null && extend != null && extend.getType() == 4) {
            throw new InvalidParamException("value", expression.toStringFromStart(), this.name, ac);
        }
        if (shape != null) {
            v.add(shape);
        }
        if (extend != null) {
            v.add(extend);
            if (extend2 != null) {
                v.add(extend2);
            }
        }
        if (atPosition != null) {
            v.add(at);
            v.add(atPosition);
        }
        return v.size() == 1 ? (CssValue)v.get(0) : new CssValueList(v);
    }

    private final ArrayList<CssValue> parseColorStops(CssExpression expression, ApplContext ac) throws InvalidParamException {
        ArrayList<CssValue> v = new ArrayList<CssValue>();
        boolean prev_is_hint = false;
        while (!expression.end()) {
            CssColor stopcol;
            CssValue stop1;
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            boolean got_length_percentage = false;
            switch (val.getType()) {
                case 5: {
                    val.getLength();
                }
                case 4: 
                case 6: {
                    stop1 = val;
                    got_length_percentage = true;
                    break;
                }
                case 15: {
                    stopcol = new CssColor();
                    stopcol.setShortRGBColor(ac, val.toString());
                    stop1 = stopcol;
                    break;
                }
                case 0: {
                    if (CssColorCSS3.currentColor.equals((CssIdent)val)) {
                        stop1 = CssColorCSS3.currentColor;
                        break;
                    }
                    stopcol = new CssColor();
                    stopcol.setIdentColor(ac, val.toString());
                    stop1 = stopcol;
                    break;
                }
                case 3: {
                    stop1 = val;
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), "color", ac);
                }
            }
            if (op == ' ' && expression.getRemainingCount() > 1) {
                expression.next();
                val = expression.getValue();
                op = expression.getOperator();
                switch (val.getType()) {
                    case 5: {
                        val.getLength();
                    }
                    case 4: 
                    case 6: {
                        if (got_length_percentage) {
                            throw new InvalidParamException("value", val.toString(), "color-stop", ac);
                        }
                        ArrayList<CssValue> stop = new ArrayList<CssValue>(2);
                        stop.add(stop1);
                        stop.add(val);
                        v.add(new CssValueList(stop));
                        break;
                    }
                    case 15: {
                        if (!got_length_percentage) {
                            throw new InvalidParamException("value", val.toString(), "color-stop", ac);
                        }
                        stopcol = new CssColor();
                        stopcol.setShortRGBColor(ac, val.toString());
                        ArrayList<CssValue> stop = new ArrayList(2);
                        stop.add(stopcol);
                        stop.add(stop1);
                        v.add(new CssValueList(stop));
                        break;
                    }
                    case 0: {
                        CssValue stop2;
                        if (!got_length_percentage) {
                            throw new InvalidParamException("value", val.toString(), "color-stop", ac);
                        }
                        if (CssColorCSS3.currentColor.equals((CssIdent)val)) {
                            stop2 = CssColorCSS3.currentColor;
                        } else {
                            stopcol = new CssColor();
                            stopcol.setIdentColor(ac, val.toString());
                            stop2 = stopcol;
                        }
                        ArrayList<CssValue> stop = new ArrayList(2);
                        stop.add(stop2);
                        stop.add(stop1);
                        v.add(new CssValueList(stop));
                        break;
                    }
                    case 3: {
                        if (!got_length_percentage) {
                            throw new InvalidParamException("value", val.toString(), "color-stop", ac);
                        }
                        ArrayList<CssValue> stop = new ArrayList(2);
                        stop.add(val);
                        stop.add(stop1);
                        v.add(new CssValueList(stop));
                        break;
                    }
                    default: {
                        throw new InvalidParamException("value", val.toString(), "color-stop", ac);
                    }
                }
                prev_is_hint = false;
            } else {
                if (prev_is_hint && got_length_percentage) {
                    throw new InvalidParamException("value", stop1, "color-stop", ac);
                }
                v.add(stop1);
                prev_is_hint = got_length_percentage;
            }
            expression.next();
            if (expression.end() || op == ',') continue;
            expression.starts();
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        return v;
    }

    private CssValue checkPosition(CssExpression expression, ApplContext ac) throws InvalidParamException {
        switch (ac.getCssVersion()) {
            case CSS3: {
                return CssBackgroundPosition.checkSyntax(ac, expression, this.name);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append('(').append(expression.toStringFromStart()).append(')');
        throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
    }

    @Override
    public Object get() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this._cache == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append('(').append(this.value).append(')');
            this._cache = sb.toString();
        }
        return this._cache;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof CssImage && this.name.equals(((CssImage)other).name) && this.value.equals(((CssImage)other).value);
    }

    static {
        String[] _val = new String[]{"closest-corner", "closest-side", "farthest-corner", "farthest-side"};
        extent_keywords = new CssIdent[_val.length];
        int i = 0;
        for (String s : _val) {
            CssImage.extent_keywords[i++] = CssIdent.getIdent(s);
        }
    }
}

