/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import org.apache.log4j.Logger;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ProxyListenerScript
implements ProxyListener {
    public static final int PROXY_LISTENER_ORDER = 4998;
    private final ExtensionScript extension;
    private static final Logger logger = Logger.getLogger(ProxyListenerScript.class);

    public ProxyListenerScript(ExtensionScript extension) {
        this.extension = extension;
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 4998;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage msg) {
        return this.invokeProxyScripts(msg, true);
    }

    private boolean invokeProxyScripts(HttpMessage msg, boolean processRequest) {
        for (ScriptWrapper script : this.extension.getScripts("proxy")) {
            if (!script.isEnabled()) continue;
            try {
                if (this.extension.invokeProxyScript(script, msg, processRequest)) continue;
                return false;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public boolean onHttpResponseReceive(HttpMessage msg) {
        return this.invokeProxyScripts(msg, false);
    }
}

