/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket.jdk8;

import java.io.IOException;
import java.net.DatagramPacket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.ice4j.socket.jdk8.DelegatingSocketChannel;

class PreReadSocketChannel
extends DelegatingSocketChannel<SocketChannel> {
    private final DatagramPacket preRead;

    public PreReadSocketChannel(DatagramPacket preRead, SocketChannel delegate) {
        super(delegate);
        this.preRead = preRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        DatagramPacket datagramPacket = this.preRead;
        synchronized (datagramPacket) {
            int superRead;
            int read;
            int len = this.preRead.getLength();
            if (len > 0) {
                int toRead = Math.min(len, dst.remaining());
                if (toRead > 0) {
                    byte[] buf = this.preRead.getData();
                    int off = this.preRead.getOffset();
                    dst.put(buf, off, toRead);
                    read = toRead;
                    this.preRead.setData(buf, off + read, len - read);
                } else {
                    read = 0;
                }
            } else {
                read = 0;
            }
            if (read == 0) {
                read = super.read(dst);
            } else if (dst.hasRemaining() && (superRead = super.read(dst)) > 0) {
                read += superRead;
            }
            return read;
        }
    }
}

