(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/14#%latin1->char integer->char)
  (define std/srfi/14#%char->latin1 char->integer)
  (define std/srfi/14#:char-set
    (make-struct-type
     'std/srfi/14#:char-set
     '#f
     '1
     ':char-set
     '((fields: s))
     '#f))
  (define std/srfi/14#char-set? (make-struct-predicate std/srfi/14#:char-set))
  (define std/srfi/14#char-set:s
    (make-struct-field-accessor std/srfi/14#:char-set '0))
  (define std/srfi/14#make-char-set
    (lambda (_s905_) (make-struct-instance std/srfi/14#:char-set _s905_)))
  (define std/srfi/14#%string-copy
    (lambda (_s903_) (substring _s903_ '0 (string-length _s903_))))
  (define std/srfi/14#%default-base
    (lambda (_maybe-base897_ _proc898_)
      (if (pair? _maybe-base897_)
          (let ((_bcs900_ (car _maybe-base897_))
                (_tail901_ (cdr _maybe-base897_)))
            (if (null? _tail901_)
                (if (let ()
                      (declare (not safe))
                      (##structure-instance-of?
                       _bcs900_
                       'std/srfi/14#:char-set))
                    (std/srfi/14#%string-copy
                     (##structure-ref _bcs900_ '1 std/srfi/14#:char-set '#f))
                    (error '"BASE-CS parameter not a char-set"
                           _proc898_
                           _bcs900_))
                (error '"Expected final base char set -- too many parameters"
                       _proc898_
                       _maybe-base897_)))
          (make-string '256 (std/srfi/14#%latin1->char '0)))))
  (define std/srfi/14#%char-set:s/check
    (lambda (_cs890_ _proc891_)
      (let _lp893_ ((_cs895_ _cs890_))
        (if (let ()
              (declare (not safe))
              (##structure-instance-of? _cs895_ 'std/srfi/14#:char-set))
            (##structure-ref _cs895_ '1 std/srfi/14#:char-set '#f)
            (_lp893_ (error '"Not a char-set" _cs895_ _proc891_))))))
  (define std/srfi/14#si=0?
    (lambda (_s887_ _i888_)
      (zero? (std/srfi/14#%char->latin1 (string-ref _s887_ _i888_)))))
  (define std/srfi/14#si=1?
    (lambda (_s884_ _i885_) (not (std/srfi/14#si=0? _s884_ _i885_))))
  (define std/srfi/14#c0 (std/srfi/14#%latin1->char '0))
  (define std/srfi/14#c1 (std/srfi/14#%latin1->char '1))
  (define std/srfi/14#si
    (lambda (_s881_ _i882_)
      (std/srfi/14#%char->latin1 (string-ref _s881_ _i882_))))
  (define std/srfi/14#%set0!
    (lambda (_s878_ _i879_) (string-set! _s878_ _i879_ std/srfi/14#c0)))
  (define std/srfi/14#%set1!
    (lambda (_s875_ _i876_) (string-set! _s875_ _i876_ std/srfi/14#c1)))
  (define std/srfi/14#setv!
    (lambda (_s871_ _i872_ _v873_)
      (string-set! _s871_ _i872_ (std/srfi/14#%latin1->char _v873_))))
  (define std/srfi/14#%not!
    (lambda (_s867_ _i868_ _v869_)
      (std/srfi/14#setv! _s867_ _i868_ (- '1 _v869_))))
  (define std/srfi/14#%and!
    (lambda (_s863_ _i864_ _v865_)
      (if (zero? _v865_) (std/srfi/14#%set0! _s863_ _i864_) '#!void)))
  (define std/srfi/14#%or!
    (lambda (_s859_ _i860_ _v861_)
      (if (not (zero? _v861_)) (std/srfi/14#%set1! _s859_ _i860_) '#!void)))
  (define std/srfi/14#%minus!
    (lambda (_s855_ _i856_ _v857_)
      (if (not (zero? _v857_)) (std/srfi/14#%set0! _s855_ _i856_) '#!void)))
  (define std/srfi/14#%xor!
    (lambda (_s851_ _i852_ _v853_)
      (if (not (zero? _v853_))
          (std/srfi/14#setv!
           _s851_
           _i852_
           (- '1 (std/srfi/14#si _s851_ _i852_)))
          '#!void)))
  (define std/srfi/14#char-set-copy
    (lambda (_cs849_)
      (let ((__tmp4505
             (std/srfi/14#%string-copy
              (std/srfi/14#%char-set:s/check
               _cs849_
               std/srfi/14#char-set-copy))))
        (declare (not safe))
        (##structure std/srfi/14#:char-set __tmp4505))))
  (define std/srfi/14#char-set=
    (lambda _rest830_
      (let ((_$e832_ (null? _rest830_)))
        (if _$e832_
            _$e832_
            (let* ((_cs1835_ (car _rest830_))
                   (_rest837_ (cdr _rest830_))
                   (_s1839_ (std/srfi/14#%char-set:s/check
                             _cs1835_
                             std/srfi/14#char-set=)))
              (let _lp842_ ((_rest844_ _rest837_))
                (let ((_$e846_ (not (pair? _rest844_))))
                  (if _$e846_
                      _$e846_
                      (if (string=?
                           _s1839_
                           (std/srfi/14#%char-set:s/check
                            (car _rest844_)
                            std/srfi/14#char-set=))
                          (_lp842_ (cdr _rest844_))
                          '#f)))))))))
  (define std/srfi/14#char-set<=
    (lambda _rest807_
      (let ((_$e809_ (null? _rest807_)))
        (if _$e809_
            _$e809_
            (let ((_cs1812_ (car _rest807_)) (_rest813_ (cdr _rest807_)))
              (let _lp815_ ((_s1817_ (std/srfi/14#%char-set:s/check
                                      _cs1812_
                                      std/srfi/14#char-set<=))
                            (_rest818_ _rest813_))
                (let ((_$e820_ (not (pair? _rest818_))))
                  (if _$e820_
                      _$e820_
                      (let ((_s2823_ (std/srfi/14#%char-set:s/check
                                      (car _rest818_)
                                      std/srfi/14#char-set<=))
                            (_rest824_ (cdr _rest818_)))
                        (if (eq? _s1817_ _s2823_)
                            (_lp815_ _s2823_ _rest824_)
                            (let _lp2826_ ((_i828_ '255))
                              (if (< _i828_ '0)
                                  (_lp815_ _s2823_ _rest824_)
                                  (if (<= (std/srfi/14#si _s1817_ _i828_)
                                          (std/srfi/14#si _s2823_ _i828_))
                                      (_lp2826_ (- _i828_ '1))
                                      '#f)))))))))))))
  (define std/srfi/14#char-set-hash
    (lambda (_cs778_ . _maybe-bound779_)
      (let* ((_bound789_
              (let ((_maybe-arg781_ _maybe-bound779_))
                (if (null? _maybe-arg781_)
                    '4194304
                    (if (null? (cdr _maybe-arg781_))
                        (let ((_val784_ (car _maybe-arg781_)))
                          (if ((lambda (_n787_)
                                 (and (integer? _n787_)
                                      (exact? _n787_)
                                      (<= '0 _n787_)))
                               _val784_)
                              _val784_
                              (error '"argument out of domain" _val784_)))
                        (error '"too many optional arguments"
                               _maybe-arg781_)))))
             (_bound791_ (if (zero? _bound789_) '4194304 _bound789_))
             (_s793_ (std/srfi/14#%char-set:s/check
                      _cs778_
                      std/srfi/14#char-set-hash))
             (_mask799_
              (let _lp795_ ((_i797_ '65536))
                (if (>= _i797_ _bound791_)
                    (- _i797_ '1)
                    (_lp795_ (+ _i797_ _i797_))))))
        (let _lp802_ ((_i804_ '255) (_ans805_ '0))
          (if (< _i804_ '0)
              (modulo _ans805_ _bound791_)
              (_lp802_ (- _i804_ '1)
                       (if (std/srfi/14#si=0? _s793_ _i804_)
                           _ans805_
                           (bitwise-and
                            _mask799_
                            (+ (* '37 _ans805_) _i804_)))))))))
  (define std/srfi/14#char-set-contains?
    (lambda (_cs775_ _char776_)
      (std/srfi/14#si=1?
       (std/srfi/14#%char-set:s/check _cs775_ std/srfi/14#char-set-contains?)
       (std/srfi/14#%char->latin1
        (if (char? _char776_)
            _char776_
            (error '"Bad argument" _char776_ 'char? 'char-set-contains?))))))
  (define std/srfi/14#char-set-size
    (lambda (_cs766_)
      (let ((_s768_ (std/srfi/14#%char-set:s/check
                     _cs766_
                     std/srfi/14#char-set-size)))
        (let _lp770_ ((_i772_ '255) (_size773_ '0))
          (if (< _i772_ '0)
              _size773_
              (_lp770_ (- _i772_ '1)
                       (+ _size773_ (std/srfi/14#si _s768_ _i772_))))))))
  (define std/srfi/14#char-set-count
    (lambda (_pred756_ _cset757_)
      (if (procedure? _pred756_)
          _pred756_
          (error '"Bad argument" _pred756_ 'procedure? 'char-set-count))
      (let ((_s759_ (std/srfi/14#%char-set:s/check
                     _cset757_
                     std/srfi/14#char-set-count)))
        (let _lp761_ ((_i763_ '255) (_count764_ '0))
          (if (< _i763_ '0)
              _count764_
              (_lp761_ (- _i763_ '1)
                       (if (and (std/srfi/14#si=1? _s759_ _i763_)
                                (_pred756_ (std/srfi/14#%latin1->char _i763_)))
                           (+ _count764_ '1)
                           _count764_)))))))
  (define std/srfi/14#%set-char-set
    (lambda (_set747_ _proc748_ _cs749_ _chars750_)
      (let ((_s752_ (std/srfi/14#%string-copy
                     (std/srfi/14#%char-set:s/check _cs749_ _proc748_))))
        (for-each
         (lambda (_c754_) (_set747_ _s752_ (std/srfi/14#%char->latin1 _c754_)))
         _chars750_)
        (let ()
          (declare (not safe))
          (##structure std/srfi/14#:char-set _s752_)))))
  (define std/srfi/14#%set-char-set!
    (lambda (_set738_ _proc739_ _cs740_ _chars741_)
      (let ((_s743_ (std/srfi/14#%char-set:s/check _cs740_ _proc739_)))
        (for-each
         (lambda (_c745_) (_set738_ _s743_ (std/srfi/14#%char->latin1 _c745_)))
         _chars741_))
      _cs740_))
  (define std/srfi/14#char-set-adjoin
    (lambda (_cs735_ . _chars736_)
      (std/srfi/14#%set-char-set
       std/srfi/14#%set1!
       std/srfi/14#char-set-adjoin
       _cs735_
       _chars736_)))
  (define std/srfi/14#char-set-adjoin!
    (lambda (_cs732_ . _chars733_)
      (std/srfi/14#%set-char-set!
       std/srfi/14#%set1!
       std/srfi/14#char-set-adjoin!
       _cs732_
       _chars733_)))
  (define std/srfi/14#char-set-delete
    (lambda (_cs729_ . _chars730_)
      (std/srfi/14#%set-char-set
       std/srfi/14#%set0!
       std/srfi/14#char-set-delete
       _cs729_
       _chars730_)))
  (define std/srfi/14#char-set-delete!
    (lambda (_cs726_ . _chars727_)
      (std/srfi/14#%set-char-set!
       std/srfi/14#%set0!
       std/srfi/14#char-set-delete!
       _cs726_
       _chars727_)))
  (define std/srfi/14#char-set-cursor
    (lambda (_cset724_)
      (std/srfi/14#%char-set-cursor-next
       _cset724_
       '256
       std/srfi/14#char-set-cursor)))
  (define std/srfi/14#end-of-char-set?
    (lambda (_cursor722_) (< _cursor722_ '0)))
  (define std/srfi/14#char-set-ref
    (lambda (_cset719_ _cursor720_) (std/srfi/14#%latin1->char _cursor720_)))
  (define std/srfi/14#char-set-cursor-next
    (lambda (_cset714_ _cursor715_)
      (if ((lambda (_i717_)
             (and (integer? _i717_) (exact? _i717_) (<= '0 _i717_ '255)))
           _cursor715_)
          _cursor715_
          (error '"Bad argument"
                 _cursor715_
                 '(lambda (i) (and (integer? i) (exact? i) (<= 0 i 255)))
                 'char-set-cursor-next))
      (std/srfi/14#%char-set-cursor-next
       _cset714_
       _cursor715_
       std/srfi/14#char-set-cursor-next)))
  (define std/srfi/14#%char-set-cursor-next
    (lambda (_cset699_ _cursor700_ _proc701_)
      (let ((_s703_ (std/srfi/14#%char-set:s/check _cset699_ _proc701_)))
        (let _lp705_ ((_cur707_ _cursor700_))
          (let ((_cur709_ (- _cur707_ '1)))
            (if (or (< _cur709_ '0) (std/srfi/14#si=1? _s703_ _cur709_))
                _cur709_
                (_lp705_ _cur709_)))))))
  (define std/srfi/14#char-set-for-each
    (lambda (_proc690_ _cs691_)
      (if (procedure? _proc690_)
          _proc690_
          (error '"Bad argument" _proc690_ 'procedure? 'char-set-for-each))
      (let ((_s693_ (std/srfi/14#%char-set:s/check
                     _cs691_
                     std/srfi/14#char-set-for-each)))
        (let _lp695_ ((_i697_ '255))
          (if (>= _i697_ '0)
              (begin
                (if (std/srfi/14#si=1? _s693_ _i697_)
                    (_proc690_ (std/srfi/14#%latin1->char _i697_))
                    '#!void)
                (_lp695_ (- _i697_ '1)))
              '#!void)))))
  (define std/srfi/14#char-set-map
    (lambda (_proc680_ _cs681_)
      (if (procedure? _proc680_)
          _proc680_
          (error '"Bad argument" _proc680_ 'procedure? 'char-set-map))
      (let ((_s683_ (std/srfi/14#%char-set:s/check
                     _cs681_
                     std/srfi/14#char-set-map))
            (_ans684_ (make-string '256 std/srfi/14#c0)))
        (let _lp686_ ((_i688_ '255))
          (if (>= _i688_ '0)
              (begin
                (if (std/srfi/14#si=1? _s683_ _i688_)
                    (std/srfi/14#%set1!
                     _ans684_
                     (std/srfi/14#%char->latin1
                      (_proc680_ (std/srfi/14#%latin1->char _i688_))))
                    '#!void)
                (_lp686_ (- _i688_ '1)))
              '#!void))
        (let ()
          (declare (not safe))
          (##structure std/srfi/14#:char-set _ans684_)))))
  (define std/srfi/14#char-set-fold
    (lambda (_kons669_ _knil670_ _cs671_)
      (if (procedure? _kons669_)
          _kons669_
          (error '"Bad argument" _kons669_ 'procedure? 'char-set-fold))
      (let ((_s673_ (std/srfi/14#%char-set:s/check
                     _cs671_
                     std/srfi/14#char-set-fold)))
        (let _lp675_ ((_i677_ '255) (_ans678_ _knil670_))
          (if (< _i677_ '0)
              _ans678_
              (_lp675_ (- _i677_ '1)
                       (if (std/srfi/14#si=0? _s673_ _i677_)
                           _ans678_
                           (_kons669_
                            (std/srfi/14#%latin1->char _i677_)
                            _ans678_))))))))
  (define std/srfi/14#char-set-every
    (lambda (_pred654_ _cs655_)
      (if (procedure? _pred654_)
          _pred654_
          (error '"Bad argument" _pred654_ 'procedure? 'char-set-every))
      (let ((_s657_ (std/srfi/14#%char-set:s/check
                     _cs655_
                     std/srfi/14#char-set-every)))
        (let _lp659_ ((_i661_ '255))
          (let ((_$e663_ (< _i661_ '0)))
            (if _$e663_
                _$e663_
                (if (or (std/srfi/14#si=0? _s657_ _i661_)
                        (_pred654_ (std/srfi/14#%latin1->char _i661_)))
                    (_lp659_ (- _i661_ '1))
                    '#f)))))))
  (define std/srfi/14#char-set-any
    (lambda (_pred642_ _cs643_)
      (if (procedure? _pred642_)
          _pred642_
          (error '"Bad argument" _pred642_ 'procedure? 'char-set-any))
      (let ((_s645_ (std/srfi/14#%char-set:s/check
                     _cs643_
                     std/srfi/14#char-set-any)))
        (let _lp647_ ((_i649_ '255))
          (if (>= _i649_ '0)
              (let ((_$e651_ (if (std/srfi/14#si=1? _s645_ _i649_)
                                 (_pred642_ (std/srfi/14#%latin1->char _i649_))
                                 '#f)))
                (if _$e651_ _$e651_ (_lp647_ (- _i649_ '1))))
              '#f)))))
  (define std/srfi/14#%char-set-unfold!
    (lambda (_proc631_ _p632_ _f633_ _g634_ _s635_ _seed636_)
      (if (procedure? _p632_)
          _p632_
          (error '"Bad argument" _p632_ 'procedure? 'proc))
      (if (procedure? _f633_)
          _f633_
          (error '"Bad argument" _f633_ 'procedure? 'proc))
      (if (procedure? _g634_)
          _g634_
          (error '"Bad argument" _g634_ 'procedure? 'proc))
      (let _lp638_ ((_seed640_ _seed636_))
        (if (not (_p632_ _seed640_))
            (begin
              (std/srfi/14#%set1!
               _s635_
               (std/srfi/14#%char->latin1 (_f633_ _seed640_)))
              (_lp638_ (_g634_ _seed640_)))
            '#!void))))
  (define std/srfi/14#char-set-unfold
    (lambda (_p623_ _f624_ _g625_ _seed626_ . _maybe-base627_)
      (let ((_bs629_ (std/srfi/14#%default-base
                      _maybe-base627_
                      std/srfi/14#char-set-unfold)))
        (std/srfi/14#%char-set-unfold!
         std/srfi/14#char-set-unfold
         _p623_
         _f624_
         _g625_
         _bs629_
         _seed626_)
        (let ()
          (declare (not safe))
          (##structure std/srfi/14#:char-set _bs629_)))))
  (define std/srfi/14#char-set-unfold!
    (lambda (_p617_ _f618_ _g619_ _seed620_ _base-cset621_)
      (std/srfi/14#%char-set-unfold!
       std/srfi/14#char-set-unfold!
       _p617_
       _f618_
       _g619_
       (std/srfi/14#%char-set:s/check
        _base-cset621_
        std/srfi/14#char-set-unfold!)
       _seed620_)
      _base-cset621_))
  (define std/srfi/14#%list->char-set!
    (lambda (_chars612_ _s613_)
      (for-each
       (lambda (_char615_)
         (std/srfi/14#%set1! _s613_ (std/srfi/14#%char->latin1 _char615_)))
       _chars612_)))
  (define std/srfi/14#char-set
    (lambda _chars608_
      (let ((_s610_ (make-string '256 std/srfi/14#c0)))
        (std/srfi/14#%list->char-set! _chars608_ _s610_)
        (let ()
          (declare (not safe))
          (##structure std/srfi/14#:char-set _s610_)))))
  (define std/srfi/14#list->char-set
    (lambda (_chars603_ . _maybe-base604_)
      (let ((_bs606_ (std/srfi/14#%default-base
                      _maybe-base604_
                      std/srfi/14#list->char-set)))
        (std/srfi/14#%list->char-set! _chars603_ _bs606_)
        (let ()
          (declare (not safe))
          (##structure std/srfi/14#:char-set _bs606_)))))
  (define std/srfi/14#list->char-set!
    (lambda (_chars600_ _base-cs601_)
      (std/srfi/14#%list->char-set!
       _chars600_
       (std/srfi/14#%char-set:s/check
        _base-cs601_
        std/srfi/14#list->char-set!))
      _base-cs601_))
  (define std/srfi/14#char-set->list
    (lambda (_cs591_)
      (let ((_s593_ (std/srfi/14#%char-set:s/check
                     _cs591_
                     std/srfi/14#char-set->list)))
        (let _lp595_ ((_i597_ '255) (_ans598_ '()))
          (if (< _i597_ '0)
              _ans598_
              (_lp595_ (- _i597_ '1)
                       (if (std/srfi/14#si=0? _s593_ _i597_)
                           _ans598_
                           (cons (std/srfi/14#%latin1->char _i597_)
                                 _ans598_))))))))
  (define std/srfi/14#%string->char-set!
    (lambda (_str582_ _bs583_ _proc584_)
      (if (string? _str582_)
          _str582_
          (error '"Bad argument" _str582_ 'string? 'proc))
      (let _$loop586_ ((_i589_ (- (string-length _str582_) '1)))
        (if (< _i589_ '0)
            '#!void
            (begin
              (std/srfi/14#%set1!
               _bs583_
               (std/srfi/14#%char->latin1 (string-ref _str582_ _i589_)))
              (_$loop586_ (- _i589_ '1)))))))
  (define std/srfi/14#string->char-set
    (lambda (_str577_ . _maybe-base578_)
      (let ((_bs580_ (std/srfi/14#%default-base
                      _maybe-base578_
                      std/srfi/14#string->char-set)))
        (std/srfi/14#%string->char-set!
         _str577_
         _bs580_
         std/srfi/14#string->char-set)
        (let ()
          (declare (not safe))
          (##structure std/srfi/14#:char-set _bs580_)))))
  (define std/srfi/14#string->char-set!
    (lambda (_str574_ _base-cs575_)
      (std/srfi/14#%string->char-set!
       _str574_
       (std/srfi/14#%char-set:s/check
        _base-cs575_
        std/srfi/14#string->char-set!)
       std/srfi/14#string->char-set!)
      _base-cs575_))
  (define std/srfi/14#char-set->string
    (lambda (_cs560_)
      (let* ((_s562_ (std/srfi/14#%char-set:s/check
                      _cs560_
                      std/srfi/14#char-set->string))
             (_ans564_ (make-string (std/srfi/14#char-set-size _cs560_))))
        (let _lp567_ ((_i569_ '255) (_j570_ '0))
          (if (< _i569_ '0)
              _ans564_
              (let ((_j572_ (if (std/srfi/14#si=0? _s562_ _i569_)
                                _j570_
                                (begin
                                  (string-set!
                                   _ans564_
                                   _j570_
                                   (std/srfi/14#%latin1->char _i569_))
                                  (+ _j570_ '1)))))
                (_lp567_ (- _i569_ '1) _j572_)))))))
  (define std/srfi/14#%ucs-range->char-set!
    (lambda (_lower546_ _upper547_ _error?548_ _bs549_ _proc550_)
      (if ((lambda (_x552_)
             (and (integer? _x552_) (exact? _x552_) (<= '0 _x552_)))
           _lower546_)
          _lower546_
          (error '"Bad argument"
                 _lower546_
                 '(lambda (x) (and (integer? x) (exact? x) (<= 0 x)))
                 'proc))
      (if ((lambda (_x554_)
             (and (integer? _x554_) (exact? _x554_) (<= _lower546_ _x554_)))
           _upper547_)
          _upper547_
          (error '"Bad argument"
                 _upper547_
                 '(lambda (x) (and (integer? x) (exact? x) (<= lower x)))
                 'proc))
      (if (and (< _lower546_ _upper547_) (< '256 _upper547_) _error?548_)
          (error '"Requested UCS range contains unavailable characters -- this implementation only supports Latin-1"
                 _proc550_
                 _lower546_
                 _upper547_)
          '#!void)
      (let _lp556_ ((_i558_ (- (min _upper547_ '256) '1)))
        (if (<= _lower546_ _i558_)
            (begin (std/srfi/14#%set1! _bs549_ _i558_) (_lp556_ (- _i558_ '1)))
            '#!void))))
  (define std/srfi/14#ucs-range->char-set
    (lambda (_lower530_ _upper531_ . _rest532_)
      (let ((_rest534_ _rest532_))
        (call-with-values
         (lambda ()
           (if (null? _rest534_)
               (values '#f '())
               (values (car _rest534_) (cdr _rest534_))))
         (lambda (_error?538_ _rest539_)
           (if '#t
               (let* ((_rest542_ _rest539_)
                      (_bs544_ (std/srfi/14#%default-base
                                _rest542_
                                std/srfi/14#ucs-range->char-set)))
                 (std/srfi/14#%ucs-range->char-set!
                  _lower530_
                  _upper531_
                  _error?538_
                  _bs544_
                  std/srfi/14#ucs-range->char-set)
                 (let ()
                   (declare (not safe))
                   (##structure std/srfi/14#:char-set _bs544_)))
               (error '"argument out of domain" _error?538_)))))))
  (define std/srfi/14#ucs-range->char-set!
    (lambda (_lower525_ _upper526_ _error?527_ _base-cs528_)
      (std/srfi/14#%ucs-range->char-set!
       _lower525_
       _upper526_
       _error?527_
       (std/srfi/14#%char-set:s/check
        _base-cs528_
        std/srfi/14#ucs-range->char-set!)
       std/srfi/14#ucs-range->char-set)
      _base-cs528_))
  (define std/srfi/14#%char-set-filter!
    (lambda (_pred516_ _ds517_ _bs518_ _proc519_)
      (if (procedure? _pred516_)
          _pred516_
          (error '"Bad argument" _pred516_ 'procedure? 'proc))
      (let _lp521_ ((_i523_ '255))
        (if (>= _i523_ '0)
            (begin
              (if (and (std/srfi/14#si=1? _ds517_ _i523_)
                       (_pred516_ (std/srfi/14#%latin1->char _i523_)))
                  (std/srfi/14#%set1! _bs518_ _i523_)
                  '#!void)
              (_lp521_ (- _i523_ '1)))
            '#!void))))
  (define std/srfi/14#char-set-filter
    (lambda (_predicate510_ _domain511_ . _maybe-base512_)
      (let ((_bs514_ (std/srfi/14#%default-base
                      _maybe-base512_
                      std/srfi/14#char-set-filter)))
        (std/srfi/14#%char-set-filter!
         _predicate510_
         (std/srfi/14#%char-set:s/check
          _domain511_
          std/srfi/14#char-set-filter!)
         _bs514_
         std/srfi/14#char-set-filter)
        (let ()
          (declare (not safe))
          (##structure std/srfi/14#:char-set _bs514_)))))
  (define std/srfi/14#char-set-filter!
    (lambda (_predicate506_ _domain507_ _base-cs508_)
      (std/srfi/14#%char-set-filter!
       _predicate506_
       (std/srfi/14#%char-set:s/check _domain507_ std/srfi/14#char-set-filter!)
       (std/srfi/14#%char-set:s/check
        _base-cs508_
        std/srfi/14#char-set-filter!)
       std/srfi/14#char-set-filter!)
      _base-cs508_))
  (define std/srfi/14#->char-set
    (lambda (_x504_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _x504_ 'std/srfi/14#:char-set))
          _x504_
          (if (string? _x504_)
              (std/srfi/14#string->char-set _x504_)
              (if (char? _x504_)
                  (std/srfi/14#char-set _x504_)
                  (error '"->char-set: Not a charset, string or char."
                         _x504_))))))
  (define std/srfi/14#%string-iter
    (lambda (_p497_ _s498_)
      (let _lp500_ ((_i502_ (- (string-length _s498_) '1)))
        (if (>= _i502_ '0)
            (begin
              (_p497_ _i502_
                      (std/srfi/14#%char->latin1 (string-ref _s498_ _i502_)))
              (_lp500_ (- _i502_ '1)))
            '#!void))))
  (define std/srfi/14#%char-set-algebra
    (lambda (_s484_ _csets485_ _op486_ _proc487_)
      (for-each
       (lambda (_cset489_)
         (let ((_s2491_ (std/srfi/14#%char-set:s/check _cset489_ _proc487_)))
           (let _lp493_ ((_i495_ '255))
             (if (>= _i495_ '0)
                 (begin
                   (_op486_ _s484_ _i495_ (std/srfi/14#si _s2491_ _i495_))
                   (_lp493_ (- _i495_ '1)))
                 '#!void))))
       _csets485_)))
  (define std/srfi/14#char-set-complement
    (lambda (_cs476_)
      (let ((_s478_ (std/srfi/14#%char-set:s/check
                     _cs476_
                     std/srfi/14#char-set-complement))
            (_ans479_ (make-string '256)))
        (std/srfi/14#%string-iter
         (lambda (_i481_ _v482_) (std/srfi/14#%not! _ans479_ _i481_ _v482_))
         _s478_)
        (let ()
          (declare (not safe))
          (##structure std/srfi/14#:char-set _ans479_)))))
  (define std/srfi/14#char-set-complement!
    (lambda (_cset469_)
      (let ((_s471_ (std/srfi/14#%char-set:s/check
                     _cset469_
                     std/srfi/14#char-set-complement!)))
        (std/srfi/14#%string-iter
         (lambda (_i473_ _v474_) (std/srfi/14#%not! _s471_ _i473_ _v474_))
         _s471_))
      _cset469_))
  (define std/srfi/14#char-set-union!
    (lambda (_cset1466_ . _csets467_)
      (std/srfi/14#%char-set-algebra
       (std/srfi/14#%char-set:s/check _cset1466_ std/srfi/14#char-set-union!)
       _csets467_
       std/srfi/14#%or!
       std/srfi/14#char-set-union!)
      _cset1466_))
  (define std/srfi/14#char-set-union
    (lambda _csets462_
      (if (pair? _csets462_)
          (let ((_s464_ (std/srfi/14#%string-copy
                         (std/srfi/14#%char-set:s/check
                          (car _csets462_)
                          std/srfi/14#char-set-union))))
            (std/srfi/14#%char-set-algebra
             _s464_
             (cdr _csets462_)
             std/srfi/14#%or!
             std/srfi/14#char-set-union)
            (let ()
              (declare (not safe))
              (##structure std/srfi/14#:char-set _s464_)))
          (std/srfi/14#char-set-copy std/srfi/14#char-set:empty))))
  (define std/srfi/14#char-set-intersection!
    (lambda (_cset1459_ . _csets460_)
      (std/srfi/14#%char-set-algebra
       (std/srfi/14#%char-set:s/check
        _cset1459_
        std/srfi/14#char-set-intersection!)
       _csets460_
       std/srfi/14#%and!
       std/srfi/14#char-set-intersection!)
      _cset1459_))
  (define std/srfi/14#char-set-intersection
    (lambda _csets455_
      (if (pair? _csets455_)
          (let ((_s457_ (std/srfi/14#%string-copy
                         (std/srfi/14#%char-set:s/check
                          (car _csets455_)
                          std/srfi/14#char-set-intersection))))
            (std/srfi/14#%char-set-algebra
             _s457_
             (cdr _csets455_)
             std/srfi/14#%and!
             std/srfi/14#char-set-intersection)
            (let ()
              (declare (not safe))
              (##structure std/srfi/14#:char-set _s457_)))
          (std/srfi/14#char-set-copy std/srfi/14#char-set:full))))
  (define std/srfi/14#char-set-difference!
    (lambda (_cset1452_ . _csets453_)
      (std/srfi/14#%char-set-algebra
       (std/srfi/14#%char-set:s/check
        _cset1452_
        std/srfi/14#char-set-difference!)
       _csets453_
       std/srfi/14#%minus!
       std/srfi/14#char-set-difference!)
      _cset1452_))
  (define std/srfi/14#char-set-difference
    (lambda (_cs1447_ . _csets448_)
      (if (pair? _csets448_)
          (let ((_s450_ (std/srfi/14#%string-copy
                         (std/srfi/14#%char-set:s/check
                          _cs1447_
                          std/srfi/14#char-set-difference))))
            (std/srfi/14#%char-set-algebra
             _s450_
             _csets448_
             std/srfi/14#%minus!
             std/srfi/14#char-set-difference)
            (let ()
              (declare (not safe))
              (##structure std/srfi/14#:char-set _s450_)))
          (std/srfi/14#char-set-copy _cs1447_))))
  (define std/srfi/14#char-set-xor!
    (lambda (_cset1444_ . _csets445_)
      (std/srfi/14#%char-set-algebra
       (std/srfi/14#%char-set:s/check _cset1444_ std/srfi/14#char-set-xor!)
       _csets445_
       std/srfi/14#%xor!
       std/srfi/14#char-set-xor!)
      _cset1444_))
  (define std/srfi/14#char-set-xor
    (lambda _csets440_
      (if (pair? _csets440_)
          (let ((_s442_ (std/srfi/14#%string-copy
                         (std/srfi/14#%char-set:s/check
                          (car _csets440_)
                          std/srfi/14#char-set-xor))))
            (std/srfi/14#%char-set-algebra
             _s442_
             (cdr _csets440_)
             std/srfi/14#%xor!
             std/srfi/14#char-set-xor)
            (let ()
              (declare (not safe))
              (##structure std/srfi/14#:char-set _s442_)))
          (std/srfi/14#char-set-copy std/srfi/14#char-set:empty))))
  (define std/srfi/14#%char-set-diff+intersection!
    (lambda (_diff430_ _int431_ _csets432_ _proc433_)
      (for-each
       (lambda (_cs435_)
         (std/srfi/14#%string-iter
          (lambda (_i437_ _v438_)
            (if (not (zero? _v438_))
                (if (std/srfi/14#si=1? _diff430_ _i437_)
                    (begin
                      (std/srfi/14#%set0! _diff430_ _i437_)
                      (std/srfi/14#%set1! _int431_ _i437_))
                    '#!void)
                '#!void))
          (std/srfi/14#%char-set:s/check _cs435_ _proc433_)))
       _csets432_)))
  (define std/srfi/14#char-set-diff+intersection!
    (lambda (_cs1420_ _cs2421_ . _csets422_)
      (let ((_s1424_ (std/srfi/14#%char-set:s/check
                      _cs1420_
                      std/srfi/14#char-set-diff+intersection!))
            (_s2425_ (std/srfi/14#%char-set:s/check
                      _cs2421_
                      std/srfi/14#char-set-diff+intersection!)))
        (std/srfi/14#%string-iter
         (lambda (_i427_ _v428_)
           (if (zero? _v428_)
               (std/srfi/14#%set0! _s2425_ _i427_)
               (if (std/srfi/14#si=1? _s2425_ _i427_)
                   (std/srfi/14#%set0! _s1424_ _i427_)
                   '#!void)))
         _s1424_)
        (std/srfi/14#%char-set-diff+intersection!
         _s1424_
         _s2425_
         _csets422_
         std/srfi/14#char-set-diff+intersection!))
      (values _cs1420_ _cs2421_)))
  (define std/srfi/14#char-set-diff+intersection
    (lambda (_cs1414_ . _csets415_)
      (let ((_diff417_
             (string-copy
              (std/srfi/14#%char-set:s/check
               _cs1414_
               std/srfi/14#char-set-diff+intersection)))
            (_int418_ (make-string '256 std/srfi/14#c0)))
        (std/srfi/14#%char-set-diff+intersection!
         _diff417_
         _int418_
         _csets415_
         std/srfi/14#char-set-diff+intersection)
        (values (let ()
                  (declare (not safe))
                  (##structure std/srfi/14#:char-set _diff417_))
                (let ()
                  (declare (not safe))
                  (##structure std/srfi/14#:char-set _int418_))))))
  (define std/srfi/14#char-set:empty (std/srfi/14#char-set))
  (define std/srfi/14#char-set:full
    (std/srfi/14#char-set-complement std/srfi/14#char-set:empty))
  (define std/srfi/14#char-set:lower-case
    (let* ((_a-z407_ (std/srfi/14#ucs-range->char-set '97 '123))
           (_latin1409_
            (std/srfi/14#ucs-range->char-set! '223 '247 '#t _a-z407_))
           (_latin2411_
            (std/srfi/14#ucs-range->char-set! '248 '256 '#t _latin1409_)))
      (std/srfi/14#char-set-adjoin!
       _latin2411_
       (std/srfi/14#%latin1->char '181))))
  (define std/srfi/14#char-set:upper-case
    (let ((_A-Z405_ (std/srfi/14#ucs-range->char-set '65 '91)))
      (std/srfi/14#ucs-range->char-set!
       '216
       '223
       '#t
       (std/srfi/14#ucs-range->char-set! '192 '215 '#t _A-Z405_))))
  (define std/srfi/14#char-set:title-case std/srfi/14#char-set:empty)
  (define std/srfi/14#char-set:letter
    (let ((_u/l403_
           (std/srfi/14#char-set-union
            std/srfi/14#char-set:upper-case
            std/srfi/14#char-set:lower-case)))
      (std/srfi/14#char-set-adjoin!
       _u/l403_
       (std/srfi/14#%latin1->char '170)
       (std/srfi/14#%latin1->char '186))))
  (define std/srfi/14#char-set:digit
    (std/srfi/14#string->char-set '"0123456789"))
  (define std/srfi/14#char-set:hex-digit
    (std/srfi/14#string->char-set '"0123456789abcdefABCDEF"))
  (define std/srfi/14#char-set:letter+digit
    (std/srfi/14#char-set-union
     std/srfi/14#char-set:letter
     std/srfi/14#char-set:digit))
  (define std/srfi/14#char-set:punctuation
    (let ((_ascii400_
           (std/srfi/14#string->char-set '"!\"#%&'()*,-./:;?@[\\]_{}"))
          (_latin-1-chars401_
           (map std/srfi/14#%latin1->char '(161 171 173 183 187 191))))
      (std/srfi/14#list->char-set! _latin-1-chars401_ _ascii400_)))
  (define std/srfi/14#char-set:symbol
    (let ((_ascii397_ (std/srfi/14#string->char-set '"$+<=>^`|~"))
          (_latin-1-chars398_
           (map std/srfi/14#%latin1->char
                '(162
                  163
                  164
                  165
                  166
                  167
                  168
                  169
                  172
                  174
                  175
                  176
                  177
                  180
                  182
                  184
                  215
                  247))))
      (std/srfi/14#list->char-set! _latin-1-chars398_ _ascii397_)))
  (define std/srfi/14#char-set:graphic
    (std/srfi/14#char-set-union
     std/srfi/14#char-set:letter+digit
     std/srfi/14#char-set:punctuation
     std/srfi/14#char-set:symbol))
  (define std/srfi/14#char-set:whitespace
    (std/srfi/14#list->char-set
     (map std/srfi/14#%latin1->char '(9 10 11 12 13 32 160))))
  (define std/srfi/14#char-set:printing
    (std/srfi/14#char-set-union
     std/srfi/14#char-set:whitespace
     std/srfi/14#char-set:graphic))
  (define std/srfi/14#char-set:blank
    (std/srfi/14#list->char-set (map std/srfi/14#%latin1->char '(9 32 160))))
  (define std/srfi/14#char-set:iso-control
    (std/srfi/14#ucs-range->char-set!
     '127
     '160
     '#t
     (std/srfi/14#ucs-range->char-set '0 '32)))
  (define std/srfi/14#char-set:ascii
    (std/srfi/14#ucs-range->char-set '0 '128)))
