/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.algo;

import generic.util.DequePush;
import ghidra.generic.util.datastruct.DynamicValueSortedTreeMap;
import ghidra.graph.GEdge;
import ghidra.graph.GEdgeWeightMetric;
import ghidra.graph.GImplicitDirectedGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.LazyMap;

public class DijkstraShortestPathsAlgorithm<V, E extends GEdge<V>> {
    protected final Map<V, OneSourceToAll> sources = LazyMap.lazyMap(new HashMap(), src -> new OneSourceToAll(src));
    protected final GImplicitDirectedGraph<V, E> graph;
    protected final double maxDistance;
    protected final GEdgeWeightMetric<E> metric;

    public DijkstraShortestPathsAlgorithm(GImplicitDirectedGraph<V, E> graph) {
        this.graph = graph;
        this.maxDistance = Double.POSITIVE_INFINITY;
        this.metric = GEdgeWeightMetric.naturalMetric();
    }

    public DijkstraShortestPathsAlgorithm(GImplicitDirectedGraph<V, E> graph, double maxDistance) {
        this.graph = graph;
        this.maxDistance = maxDistance;
        this.metric = GEdgeWeightMetric.naturalMetric();
    }

    public DijkstraShortestPathsAlgorithm(GImplicitDirectedGraph<V, E> graph, GEdgeWeightMetric<E> metric) {
        this.graph = graph;
        this.maxDistance = Double.POSITIVE_INFINITY;
        this.metric = metric;
    }

    public DijkstraShortestPathsAlgorithm(GImplicitDirectedGraph<V, E> graph, double maxDistance, GEdgeWeightMetric<E> metric) {
        this.graph = graph;
        this.maxDistance = maxDistance;
        this.metric = metric;
    }

    public Map<V, Double> getDistancesFromSource(V v) {
        OneSourceToAll info = this.sources.get(v);
        return Collections.unmodifiableMap(info.visitedDistance);
    }

    public Collection<Deque<E>> computeOptimalPaths(V src, V dst) {
        return this.sources.get(src).computeOptimalPathsTo(dst);
    }

    protected class OneSourceToAll {
        protected final DynamicValueSortedTreeMap<V, Double> queueByDistance = new DynamicValueSortedTreeMap();
        protected final Map<V, Double> visitedDistance = new LinkedHashMap();
        protected final Map<V, Set<E>> bestIns = LazyMap.lazyMap(new HashMap(), () -> new HashSet());
        protected final V source;

        protected OneSourceToAll(V src) {
            this.source = src;
            this.queueByDistance.put(src, (Object)0.0);
            this.fill();
        }

        public Collection<Deque<E>> computeOptimalPathsTo(V dst) {
            HashSet paths = new HashSet();
            this.addPathsTo(paths, dst);
            return paths;
        }

        protected void addPathsTo(Collection<Deque<E>> paths, V dst) {
            this.addPathsTo(paths, dst, new LinkedList());
        }

        protected void addPathsTo(Collection<Deque<E>> paths, V prev, Deque<E> soFar) {
            if (prev.equals(this.source)) {
                paths.add(new LinkedList(soFar));
            } else {
                for (GEdge e : this.bestIns.get(prev)) {
                    Object nextPrev = e.getStart();
                    DequePush push = DequePush.push(soFar, (Object)e);
                    try {
                        this.addPathsTo(paths, nextPrev, soFar);
                    }
                    finally {
                        if (push == null) continue;
                        push.close();
                    }
                }
            }
        }

        protected boolean addOrUpdate(V dest, double newDist) {
            Double curDist = this.visitedDistance.get(dest);
            if (curDist != null) {
                return false;
            }
            curDist = (Double)this.queueByDistance.get(dest);
            if (curDist == null) {
                this.queueByDistance.put(dest, (Object)newDist);
                return true;
            }
            if (newDist < curDist) {
                this.queueByDistance.put(dest, (Object)newDist);
                this.bestIns.get(dest).clear();
                return true;
            }
            return newDist == curDist;
        }

        protected void fill() {
            DynamicValueSortedTreeMap.Node next;
            while ((next = this.queueByDistance.entrySet().poll()) != null) {
                this.visitedDistance.put((Double)next.getKey(), (Double)next.getValue());
                this.fillStep(next.getKey(), (Double)next.getValue());
            }
        }

        protected void fillStep(V from, double dist) {
            for (GEdge e : DijkstraShortestPathsAlgorithm.this.graph.getOutEdges(from)) {
                Object dest;
                double newDist = dist + DijkstraShortestPathsAlgorithm.this.metric.computeWeight(e);
                if (newDist > DijkstraShortestPathsAlgorithm.this.maxDistance || !this.addOrUpdate(dest = e.getEnd(), newDist)) continue;
                this.bestIns.get(dest).add(e);
            }
        }
    }
}

