/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.markuptype;

import ghidra.feature.vt.api.impl.MarkupItemImpl;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.stringable.DataTypeStringable;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.List;

public class DataTypeMarkupType
extends VTMarkupType {
    public static final VTMarkupType INSTANCE = new DataTypeMarkupType();

    @Override
    public List<VTMarkupItem> createMarkupItems(VTAssociation association) {
        ArrayList<VTMarkupItem> list = new ArrayList<VTMarkupItem>();
        VTSession session = association.getSession();
        Program sourceProgram = session.getSourceProgram();
        Listing sourceListing = sourceProgram.getListing();
        Address sourceAddress = association.getSourceAddress();
        Data sourceData = sourceListing.getDataAt(sourceAddress);
        Program destinationProgram = session.getDestinationProgram();
        Listing destinationListing = destinationProgram.getListing();
        Address destinationAddress = association.getDestinationAddress();
        Data destinationData = destinationListing.getDataAt(destinationAddress);
        if (sourceData == null || destinationData == null) {
            return list;
        }
        MarkupItemImpl markupItem = new MarkupItemImpl(association, this, sourceAddress);
        if (destinationAddress != null) {
            markupItem.setDefaultDestinationAddress(destinationAddress, "Data");
        }
        list.add(markupItem);
        return list;
    }

    @Override
    public Address validateDestinationAddress(VTAssociation association, Address sourceAddress, Address suggestedDestinationAddress) {
        return association.getDestinationAddress();
    }

    private DataTypeMarkupType() {
        super("Data Type");
    }

    @Override
    public boolean supportsApplyAction(VTMarkupItemApplyActionType applyAction) {
        return applyAction == VTMarkupItemApplyActionType.REPLACE_DEFAULT_ONLY || applyAction == VTMarkupItemApplyActionType.REPLACE_FIRST_ONLY || applyAction == VTMarkupItemApplyActionType.REPLACE;
    }

    @Override
    public boolean supportsAssociationType(VTAssociationType matchType) {
        return matchType == VTAssociationType.DATA;
    }

    private Data getSourceData(VTAssociation association, Address sourceAddress) {
        VTSession session = association.getSession();
        Program sourceProgram = session.getSourceProgram();
        Listing sourceListing = sourceProgram.getListing();
        return sourceListing.getDataAt(sourceAddress);
    }

    private Data getDestinationData(VTAssociation association, Address destinationAddress) {
        VTSession session = association.getSession();
        Program destinationProgram = session.getDestinationProgram();
        Listing destinationListing = destinationProgram.getListing();
        return destinationListing.getDataAt(destinationAddress);
    }

    @Override
    public Stringable getSourceValue(VTAssociation association, Address sourceAddress) {
        VTSession session = association.getSession();
        Program sourceProgram = session.getSourceProgram();
        Listing sourceListing = sourceProgram.getListing();
        Data sourceData = sourceListing.getDataAt(sourceAddress);
        if (sourceData == null) {
            return null;
        }
        DataType dataType = sourceData.getDataType();
        int length = sourceData.getLength();
        DataTypeManager dataTypeManager = sourceProgram.getDataTypeManager();
        return new DataTypeStringable(dataType, dataTypeManager, length);
    }

    @Override
    public Stringable getCurrentDestinationValue(VTAssociation association, Address destinationAddress) {
        if (destinationAddress == null || destinationAddress == Address.NO_ADDRESS) {
            return null;
        }
        VTSession session = association.getSession();
        Program destinationProgram = session.getDestinationProgram();
        Listing destinationListing = destinationProgram.getListing();
        Data destinationData = destinationListing.getDataAt(destinationAddress);
        if (destinationData == null) {
            return null;
        }
        DataType dataType = destinationData.getDataType();
        DataTypeManager dataTypeManager = destinationProgram.getDataTypeManager();
        return new DataTypeStringable(dataType, dataTypeManager, destinationData.getLength());
    }

    @Override
    public Stringable getOriginalDestinationValue(VTAssociation association, Address destinationAddress) {
        return this.getCurrentDestinationValue(association, destinationAddress);
    }

    @Override
    public VTMarkupItemApplyActionType getApplyAction(ToolOptions options) {
        VTMatchApplyChoices.ReplaceDataChoices replaceChoice;
        try {
            replaceChoice = (VTMatchApplyChoices.ReplaceDataChoices)options.getEnum("Apply Markup Options.Data Match Data Type", (Enum)VTMatchApplyChoices.ReplaceDataChoices.REPLACE_UNDEFINED_DATA_ONLY);
        }
        catch (ClassCastException e) {
            options.removeOption("Apply Markup Options.Data Match Data Type");
            replaceChoice = (VTMatchApplyChoices.ReplaceDataChoices)options.getEnum("Apply Markup Options.Data Match Data Type", (Enum)VTMatchApplyChoices.ReplaceDataChoices.REPLACE_UNDEFINED_DATA_ONLY);
        }
        switch (replaceChoice) {
            case REPLACE_FIRST_DATA_ONLY: 
            case REPLACE_ALL_DATA: 
            case REPLACE_UNDEFINED_DATA_ONLY: {
                return VTMarkupItemApplyActionType.REPLACE;
            }
        }
        return null;
    }

    @Override
    public Options convertOptionsToForceApplyOfMarkupItem(VTMarkupItemApplyActionType applyAction, ToolOptions applyOptions) {
        ToolOptions options = applyOptions.copy();
        switch (applyAction) {
            case ADD: {
                throw new IllegalArgumentException(this.getDisplayName() + " markup items cannot perform a Add action.");
            }
            case ADD_AS_PRIMARY: {
                throw new IllegalArgumentException(this.getDisplayName() + " markup items cannot perform an Add As Primary action.");
            }
            case REPLACE_DEFAULT_ONLY: {
                options.setEnum("Apply Markup Options.Data Match Data Type", (Enum)VTMatchApplyChoices.ReplaceDataChoices.REPLACE_UNDEFINED_DATA_ONLY);
                break;
            }
            case REPLACE_FIRST_ONLY: {
                options.setEnum("Apply Markup Options.Data Match Data Type", (Enum)VTMatchApplyChoices.ReplaceDataChoices.REPLACE_FIRST_DATA_ONLY);
                break;
            }
            case REPLACE: {
                options.setEnum("Apply Markup Options.Data Match Data Type", (Enum)VTMatchApplyChoices.ReplaceDataChoices.REPLACE_ALL_DATA);
            }
        }
        return options;
    }

    private boolean setDataType(Program program, Address startAddress, DataType dataType, int dataLength, VTMatchApplyChoices.ReplaceDataChoices replaceChoice) throws CodeUnitInsertionException, DataTypeConflictException, VersionTrackingApplyException {
        boolean hasOtherDefinedData;
        Address endAddress;
        Listing listing = program.getListing();
        Data originalData = listing.getDataAt(startAddress);
        if (originalData == null) {
            throw new VersionTrackingApplyException("Data Type Markup cannot be applied since there isn't Data at the destination address!");
        }
        DataType originalDataType = originalData.getDataType();
        int originalDataLength = originalData.getLength();
        try {
            endAddress = startAddress.add((long)(dataLength - 1));
        }
        catch (AddressOutOfBoundsException e) {
            endAddress = null;
        }
        if (endAddress == null || !startAddress.hasSameAddressSpace(endAddress)) {
            throw new VersionTrackingApplyException("Data Type Markup cannot be applied since there isn't enough space at the destination address!");
        }
        AddressSet addressSet = new AddressSet(startAddress, endAddress);
        InstructionIterator instructions = listing.getInstructions((AddressSetView)addressSet, true);
        boolean hasInstructions = instructions.hasNext();
        if (hasInstructions) {
            String message = "Data Type Markup cannot be applied because instructions exist where the data type is to be applied. Instructions must be cleared in the destination program from " + startAddress.toString() + " to " + endAddress.toString() + " before this Data Type Markup can be applied.";
            throw new VersionTrackingApplyException(message);
        }
        boolean replaceUndefinedDataOnly = replaceChoice == VTMatchApplyChoices.ReplaceDataChoices.REPLACE_UNDEFINED_DATA_ONLY;
        boolean replaceFirstOnly = replaceChoice == VTMatchApplyChoices.ReplaceDataChoices.REPLACE_FIRST_DATA_ONLY;
        DataIterator definedData = listing.getDefinedData((AddressSetView)addressSet, true);
        boolean hasDefinedData = definedData.hasNext();
        Data nextNonUndefinedDataAfter = DataUtilities.getNextNonUndefinedDataAfter((Program)program, (Address)startAddress, (Address)endAddress);
        boolean bl = hasOtherDefinedData = nextNonUndefinedDataAfter != null;
        if (replaceUndefinedDataOnly && hasDefinedData) {
            return false;
        }
        if (replaceFirstOnly && hasOtherDefinedData) {
            return false;
        }
        listing.clearCodeUnits(startAddress, endAddress, false);
        try {
            listing.createData(startAddress, dataType, dataLength);
        }
        catch (CodeUnitInsertionException e) {
            this.tryToRestoreOriginalData(listing, startAddress, originalDataType, originalDataLength);
            throw e;
        }
        catch (DataTypeConflictException e) {
            this.tryToRestoreOriginalData(listing, startAddress, originalDataType, originalDataLength);
            throw e;
        }
        return true;
    }

    private void tryToRestoreOriginalData(Listing listing, Address address, DataType originalDataType, int originalDataLength) {
        try {
            listing.createData(address, originalDataType, originalDataLength);
        }
        catch (CodeUnitInsertionException e2) {
            Msg.error((Object)this, (Object)("Couldn't restore data type of " + originalDataType.getName() + " after failing to set data type markup at " + address.toString() + ".\n" + e2.getMessage()));
        }
        catch (DataTypeConflictException e2) {
            Msg.error((Object)this, (Object)("Couldn't restore data type of " + originalDataType.getName() + " after failing to set data type markup at " + address.toString() + ".\n" + e2.getMessage()));
        }
    }

    @Override
    public boolean applyMarkup(VTMarkupItem markupItem, ToolOptions markupOptions) throws VersionTrackingApplyException {
        DataType destinationDataType;
        VTMatchApplyChoices.ReplaceDataChoices replaceChoice = (VTMatchApplyChoices.ReplaceDataChoices)markupOptions.getEnum("Apply Markup Options.Data Match Data Type", (Enum)VTMatchApplyChoices.ReplaceDataChoices.REPLACE_UNDEFINED_DATA_ONLY);
        VTAssociation association = markupItem.getAssociation();
        Address sourceAddress = markupItem.getSourceAddress();
        Address destinationAddress = markupItem.getDestinationAddress();
        if (destinationAddress == null) {
            throw new VersionTrackingApplyException("The destination address cannot be null!");
        }
        if (destinationAddress == Address.NO_ADDRESS) {
            throw new VersionTrackingApplyException("The destination address cannot be No Address!");
        }
        Data sourceData = this.getSourceData(association, sourceAddress);
        Data destinationData = this.getDestinationData(association, destinationAddress);
        if (sourceData == null) {
            throw new VersionTrackingApplyException("The source Data cannot be null!");
        }
        if (destinationData == null) {
            throw new VersionTrackingApplyException("The destination Data cannot be null!");
        }
        DataType sourceDataType = sourceData.getDataType();
        if (SystemUtilities.isEqual((Object)sourceDataType, (Object)(destinationDataType = destinationData.getDataType()))) {
            return false;
        }
        VTSession session = association.getSession();
        Program destinationProgram = session.getDestinationProgram();
        int sourceDataLength = sourceDataType.getLength();
        if (sourceDataLength <= 0) {
            sourceDataLength = sourceData.getLength();
        }
        try {
            return this.setDataType(destinationProgram, destinationAddress, sourceDataType, sourceDataLength, replaceChoice);
        }
        catch (CodeUnitInsertionException e) {
            throw new VersionTrackingApplyException(this.getApplyFailedMessage(sourceAddress, destinationAddress, (Exception)((Object)e), sourceDataLength, destinationData.getLength()), e);
        }
        catch (DataTypeConflictException e) {
            throw new VersionTrackingApplyException(this.getApplyFailedMessage(sourceAddress, destinationAddress, (Exception)((Object)e), sourceDataLength, destinationData.getLength()), e);
        }
    }

    private String getApplyFailedMessage(Address sourceAddress, Address destinationAddress, Exception e, int newLength, int oldLength) {
        Address startAddress = destinationAddress.add((long)oldLength);
        Address endAddress = destinationAddress.add((long)(newLength - 1));
        String message = "Couldn't apply Data Type Markup from source address " + sourceAddress.toString() + " to destination address " + destinationAddress.toString() + e.getMessage() + ".";
        if (newLength > oldLength) {
            message = message + " Any Defined Data must be cleared in the destination program from " + startAddress.toString() + " to " + endAddress.toString() + " before this Data Type Markup can be applied.";
        }
        return message;
    }

    @Override
    public void unapplyMarkup(VTMarkupItem markupItem) throws VersionTrackingApplyException {
        VTMarkupItemStatus status = markupItem.getStatus();
        if (status == VTMarkupItemStatus.DONT_CARE) {
            return;
        }
        Address destinationAddress = markupItem.getDestinationAddress();
        Program destinationProgram = this.getDestinationProgram(markupItem.getAssociation());
        DataTypeManager destinationDTM = destinationProgram.getDataTypeManager();
        DataTypeStringable dataTypeStringable = (DataTypeStringable)markupItem.getOriginalDestinationValue();
        long originalDataTypeID = dataTypeStringable.getDataTypeID();
        long savedUniversalID = dataTypeStringable.getDataTypeManagerID();
        long actualUniversalID = destinationDTM.getUniversalID().getValue();
        if (actualUniversalID != savedUniversalID) {
            throw new AssertException("Destination data type manager ID of " + actualUniversalID + " doesn't match saved ID of " + savedUniversalID + ".");
        }
        DataType originalDataType = destinationDTM.getDataType(originalDataTypeID);
        int originalDataLength = originalDataType.getLength();
        if (originalDataLength <= 0) {
            originalDataLength = dataTypeStringable.getLength();
        }
        try {
            this.setDataType(destinationProgram, destinationAddress, originalDataType, originalDataLength, VTMatchApplyChoices.ReplaceDataChoices.REPLACE_ALL_DATA);
        }
        catch (CodeUnitInsertionException e) {
            throw new VersionTrackingApplyException("Couldn't unapply data type markup @ " + destinationAddress.toString() + "." + e.getMessage() + ".", e);
        }
        catch (DataTypeConflictException e) {
            throw new VersionTrackingApplyException("Couldn't unapply data type markup @ " + destinationAddress.toString() + "." + e.getMessage() + ".", e);
        }
    }

    @Override
    public ProgramLocation getDestinationLocation(VTAssociation association, Address destinationAddress) {
        return this.getListingDataTypeLocation(association, destinationAddress, false);
    }

    @Override
    public ProgramLocation getSourceLocation(VTAssociation association, Address sourceAddress) {
        return this.getListingDataTypeLocation(association, sourceAddress, true);
    }

    private ProgramLocation getListingDataTypeLocation(VTAssociation association, Address address, boolean isSource) {
        if (address == null || address == Address.NO_ADDRESS) {
            return null;
        }
        Program program = isSource ? this.getSourceProgram(association) : this.getDestinationProgram(association);
        Data data = program.getListing().getDataContaining(address);
        if (data == null) {
            return new AddressFieldLocation(program, address);
        }
        Stringable value = isSource ? this.getSourceValue(association, address) : this.getCurrentDestinationValue(association, address);
        String displayString = value != null ? value.getDisplayString() : null;
        return new MnemonicFieldLocation(program, address, null, null, displayString, 0);
    }

    @Override
    public boolean hasSameSourceAndDestinationValues(VTMarkupItem markupItem) {
        int destinationLength;
        VTAssociation association = markupItem.getAssociation();
        Address sourceAddress = markupItem.getSourceAddress();
        Address destinationAddress = markupItem.getDestinationAddress();
        if (destinationAddress == null || destinationAddress == Address.NO_ADDRESS) {
            return false;
        }
        Data sourceData = this.getSourceData(association, sourceAddress);
        Data destinationData = this.getDestinationData(association, destinationAddress);
        if (sourceData == null) {
            return true;
        }
        if (destinationData == null) {
            return false;
        }
        int sourceLength = sourceData.getLength();
        if (sourceLength != (destinationLength = destinationData.getLength())) {
            return false;
        }
        DataType sourceDataType = sourceData.getDataType();
        DataType destinationDataType = destinationData.getDataType();
        return sourceDataType.isEquivalent(destinationDataType);
    }
}

