/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.action.MultiActionDockingActionIf;
import docking.action.ToggleDockingActionIf;
import docking.action.ToolBarData;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class DockingActionProxy
implements ToggleDockingActionIf,
MultiActionDockingActionIf,
PropertyChangeListener {
    private WeakSet<PropertyChangeListener> propertyListeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private final DockingActionIf dockingAction;

    public DockingActionProxy(DockingActionIf dockingAction) {
        this.dockingAction = dockingAction;
        dockingAction.addPropertyChangeListener(this);
    }

    public DockingActionIf getAction() {
        return this.dockingAction;
    }

    @Override
    public void actionPerformed(ActionContext context) {
        this.dockingAction.actionPerformed(context);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.add((Object)listener);
    }

    @Override
    public String getDescription() {
        return this.dockingAction.getDescription();
    }

    @Override
    public String getFullName() {
        return this.dockingAction.getFullName();
    }

    @Override
    public String getInceptionInformation() {
        return this.dockingAction.getInceptionInformation();
    }

    @Override
    public KeyBindingData getKeyBindingData() {
        return this.dockingAction.getKeyBindingData();
    }

    @Override
    public KeyBindingData getDefaultKeyBindingData() {
        return this.dockingAction.getDefaultKeyBindingData();
    }

    @Override
    public MenuData getMenuBarData() {
        return this.dockingAction.getMenuBarData();
    }

    @Override
    public String getName() {
        return this.dockingAction.getName();
    }

    @Override
    public String getOwner() {
        return this.dockingAction.getOwner();
    }

    @Override
    public MenuData getPopupMenuData() {
        return this.dockingAction.getPopupMenuData();
    }

    @Override
    public ToolBarData getToolBarData() {
        return this.dockingAction.getToolBarData();
    }

    @Override
    public boolean isEnabled() {
        return this.dockingAction.isEnabled();
    }

    @Override
    public boolean isAddToPopup(ActionContext context) {
        return this.dockingAction.isAddToPopup(context);
    }

    @Override
    public boolean isValidContext(ActionContext context) {
        return this.dockingAction.isValidContext(context);
    }

    @Override
    public boolean isValidGlobalContext(ActionContext context) {
        return this.dockingAction.isValidGlobalContext(context);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.remove((Object)listener);
    }

    @Override
    public boolean setEnabled(boolean newValue) {
        boolean oldValue = this.dockingAction.setEnabled(newValue);
        return oldValue;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PropertyChangeEvent myEvent = new PropertyChangeEvent(this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        this.firePropertyChanged(myEvent);
    }

    protected void firePropertyChanged(PropertyChangeEvent event) {
        for (PropertyChangeListener listener : this.propertyListeners) {
            listener.propertyChange(event);
        }
    }

    public DockingActionIf getProxyAction() {
        return this.dockingAction;
    }

    @Override
    public boolean isSelected() {
        if (this.dockingAction instanceof ToggleDockingActionIf) {
            return ((ToggleDockingActionIf)this.dockingAction).isSelected();
        }
        return false;
    }

    @Override
    public void setSelected(boolean newValue) {
        if (this.dockingAction instanceof ToggleDockingActionIf) {
            ((ToggleDockingActionIf)this.dockingAction).setSelected(newValue);
        }
    }

    @Override
    public List<DockingActionIf> getActionList(ActionContext context) {
        if (this.dockingAction instanceof MultiActionDockingActionIf) {
            ((MultiActionDockingActionIf)((Object)this.dockingAction)).getActionList(context);
        }
        throw new AssertException("Attempted to set selection state on non-toggle action!");
    }

    @Override
    public JButton createButton() {
        return this.dockingAction.createButton();
    }

    @Override
    public JMenuItem createMenuItem(boolean isPopup) {
        return this.dockingAction.createMenuItem(isPopup);
    }

    @Override
    public boolean shouldAddToWindow(boolean isMainWindow, Set<Class<?>> contextTypes) {
        return this.dockingAction.shouldAddToWindow(isMainWindow, contextTypes);
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return this.dockingAction.isEnabledForContext(context);
    }

    @Override
    public KeyStroke getKeyBinding() {
        return this.dockingAction.getKeyBinding();
    }

    @Override
    public KeyBindingType getKeyBindingType() {
        return this.dockingAction.getKeyBindingType();
    }

    @Override
    public void setKeyBindingData(KeyBindingData keyBindingData) {
        this.dockingAction.setKeyBindingData(keyBindingData);
    }

    @Override
    public void setUnvalidatedKeyBindingData(KeyBindingData newKeyBindingData) {
        this.dockingAction.setUnvalidatedKeyBindingData(newKeyBindingData);
    }

    @Override
    public void dispose() {
        this.dockingAction.dispose();
    }

    @Override
    public String getHelpInfo() {
        return this.dockingAction.getHelpInfo();
    }

    @Override
    public Object getHelpObject() {
        return this.dockingAction;
    }

    public String toString() {
        return this.dockingAction.getName();
    }
}

