/*
 * Decompiled with CFR 0.152.
 */
package ghidra.docking.settings;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class JavaEnumSettingsDefinition<T extends Enum<T>>
implements EnumSettingsDefinition {
    private final String name;
    private final String settingName;
    private final String description;
    private final T[] values;
    protected final String[] valueNames;
    private final T defaultValue;

    public JavaEnumSettingsDefinition(String settingName, String name, String description, T defaultValue) {
        this.name = name;
        this.settingName = settingName;
        this.description = description;
        this.values = (Enum[])((Enum)defaultValue).getDeclaringClass().getEnumConstants();
        this.defaultValue = defaultValue;
        String[] tmp = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            tmp[i] = ((Enum)this.values[i]).toString();
        }
        this.valueNames = tmp;
    }

    public T getDefaultEnum() {
        return this.defaultValue;
    }

    public T getEnumValue(Settings settings) {
        return this.getEnumValue(settings, this.defaultValue);
    }

    public T getEnumValue(Settings settings, T defaultValueOverride) {
        Long lvalue = settings.getLong(this.getSettingName());
        if (lvalue == null) {
            return defaultValueOverride;
        }
        int valueOrdinal = (int)lvalue.longValue();
        return 0 <= valueOrdinal && valueOrdinal < this.values.length ? this.values[valueOrdinal] : defaultValueOverride;
    }

    public void setEnumValue(Settings settings, T enumValue) {
        this.setChoice(settings, ((Enum)enumValue).ordinal());
    }

    public T getEnumByOrdinal(int ordinal) {
        return this.values[ordinal];
    }

    public int getOrdinalByString(String stringValue) {
        for (int i = 0; i < this.valueNames.length; ++i) {
            if (!this.valueNames[i].equals(stringValue)) continue;
            return i;
        }
        return -1;
    }

    public String getSettingName() {
        return this.settingName;
    }

    @Override
    public boolean hasValue(Settings setting) {
        return setting.getValue(this.getSettingName()) != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void clear(Settings settings) {
        settings.clearSetting(this.getSettingName());
    }

    @Override
    public void copySetting(Settings srcSettings, Settings destSettings) {
        Long l = srcSettings.getLong(this.getSettingName());
        if (l == null) {
            this.clear(destSettings);
        } else {
            this.setChoice(destSettings, (int)l.longValue());
        }
    }

    @Override
    public int getChoice(Settings settings) {
        Long lvalue = settings.getLong(this.getSettingName());
        int value = lvalue != null ? (int)lvalue.longValue() : ((Enum)this.defaultValue).ordinal();
        return Math.min(Math.max(value, 0), this.values.length - 1);
    }

    @Override
    public void setChoice(Settings settings, int value) {
        settings.setLong(this.getSettingName(), value);
    }

    @Override
    public String getDisplayChoice(int value, Settings settings) {
        return ((Enum)this.values[value]).toString();
    }

    @Override
    public String[] getDisplayChoices(Settings settings) {
        return this.valueNames;
    }
}

