/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.wizard.AbstractWizardJPanel;
import docking.wizard.PanelManager;
import docking.wizard.WizardManager;
import ghidra.framework.main.NewProjectPanelManager;
import ghidra.framework.main.ServerInfoComponent;
import ghidra.framework.model.ServerInfo;
import ghidra.util.HelpLocation;
import ghidra.util.StatusListener;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ServerInfoPanel
extends AbstractWizardJPanel {
    private ServerInfoComponent serverInfoComponent;
    private PanelManager panelManager;
    private HelpLocation helpLoc;

    public ServerInfoPanel(PanelManager panelManager) {
        super((LayoutManager)new BorderLayout(10, 10));
        this.panelManager = panelManager;
        this.setBorder(NewProjectPanelManager.EMPTY_BORDER);
        this.buildMainPanel();
    }

    public String getTitle() {
        return "Specify Server Information";
    }

    public HelpLocation getHelpLocation() {
        if (this.helpLoc != null) {
            return this.helpLoc;
        }
        return new HelpLocation("FrontEndPlugin", "ServerInfo");
    }

    public void initialize() {
        this.serverInfoComponent.setStatusListener((StatusListener)this.panelManager.getWizardManager());
    }

    public boolean isValidInformation() {
        return this.serverInfoComponent.isValidInformation();
    }

    String getServerName() {
        return this.serverInfoComponent.getServerName();
    }

    int getPortNumber() {
        return this.serverInfoComponent.getPortNumber();
    }

    public void setServerInfo(ServerInfo info) {
        this.serverInfoComponent.setServerInfo(info);
    }

    void setHelpLocation(HelpLocation helpLoc) {
        this.helpLoc = helpLoc;
    }

    private void buildMainPanel() {
        this.serverInfoComponent = new ServerInfoComponent();
        this.serverInfoComponent.setChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WizardManager wm = ServerInfoPanel.this.panelManager.getWizardManager();
                if (wm.getCurrentWizardPanel() != null) {
                    wm.validityChanged();
                }
            }
        });
        this.add(this.serverInfoComponent, "Center");
    }
}

