/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.util.Leb128;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class EncodedTypeAddressPair
implements StructConverter {
    private int typeIndex;
    private int address;
    private int typeIndexLength;
    private int addressLength;

    public EncodedTypeAddressPair(BinaryReader reader) throws IOException {
        this.typeIndex = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
        this.typeIndexLength = Leb128.unsignedLeb128Size(this.typeIndex);
        reader.readNextByteArray(this.typeIndexLength);
        this.address = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
        this.addressLength = Leb128.unsignedLeb128Size(this.address);
        reader.readNextByteArray(this.addressLength);
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public int getAddress() {
        return this.address;
    }

    String getDataTypeIdString() {
        return "" + this.typeIndexLength + this.addressLength;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("encoded_type_addr_pair_" + this.typeIndexLength + "_" + this.addressLength, 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.typeIndexLength, BYTE.getLength()), "type_idx", null);
        structure.add((DataType)new ArrayDataType(BYTE, this.addressLength, BYTE.getLength()), "addr", null);
        structure.setCategoryPath(new CategoryPath("/dex/encoded_type_addr_pair"));
        return structure;
    }
}

