/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.zip;

import ghidra.file.formats.zip.ZipFileSystemFactory;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@FileSystemInfo(type="zip", description="ZIP", factory=ZipFileSystemFactory.class, priority=10)
public class ZipFileSystem
implements GFileSystem {
    private FileSystemIndexHelper<ZipEntry> fsIndexHelper;
    private FSRLRoot fsrl;
    private ZipFile zipFile;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);

    public ZipFileSystem(FSRLRoot fsrl) {
        this.fsrl = fsrl;
        this.fsIndexHelper = new FileSystemIndexHelper((GFileSystem)this, fsrl);
    }

    public String getName() {
        return this.fsrl.getContainer().getName();
    }

    public void close() throws IOException {
        this.refManager.onClose();
        if (this.zipFile != null) {
            this.zipFile.close();
            this.zipFile = null;
        }
        this.fsIndexHelper.clear();
    }

    public boolean isClosed() {
        return this.zipFile == null;
    }

    public FSRLRoot getFSRL() {
        return this.fsrl;
    }

    public int getFileCount() {
        return this.fsIndexHelper.getFileCount();
    }

    public void mount(File f, TaskMonitor monitor) throws CancelledException, IOException {
        this.zipFile = new ZipFile(f);
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            monitor.checkCanceled();
            ZipEntry currentEntry = entries.nextElement();
            this.fsIndexHelper.storeFile(currentEntry.getName(), -1, currentEntry.isDirectory(), currentEntry.getSize(), (Object)currentEntry);
        }
    }

    public Map<String, String> getInfoMap(ZipEntry blob) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Name", blob.getName());
        info.put("Comment", blob.getComment());
        info.put("Compressed Size", "0x" + Long.toHexString(blob.getCompressedSize()));
        info.put("Uncompressed Size", "0x" + Long.toHexString(blob.getSize()));
        info.put("CRC", "0x" + Long.toHexString(blob.getCrc()));
        info.put("Compression Method", "0x" + Integer.toHexString(blob.getMethod()));
        info.put("Time", new Date(blob.getTime()).toString());
        info.put("Extra Bytes", blob.getExtra() == null ? "null" : Arrays.toString(blob.getExtra()));
        return info;
    }

    public String toString() {
        return "ZipFilesystem [ fsrl=" + this.fsrl + ", filename=" + this.zipFile.getName() + " ]";
    }

    public GFile lookup(String path) throws IOException {
        return this.fsIndexHelper.lookup(path);
    }

    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        ZipEntry zipEntry = (ZipEntry)this.fsIndexHelper.getMetadata(file);
        return zipEntry != null ? this.zipFile.getInputStream(zipEntry) : null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsIndexHelper.getListing(directory);
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        ZipEntry zipEntry = (ZipEntry)this.fsIndexHelper.getMetadata(file);
        return zipEntry != null ? FSUtilities.infoMapToString(this.getInfoMap(zipEntry)) : null;
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }
}

