/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree;

import docking.ComponentProvider;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.plugin.core.symboltree.SymbolGTree;
import ghidra.app.plugin.core.symboltree.SymbolTreeProvider;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.program.model.listing.Program;
import java.awt.Component;
import javax.swing.tree.TreePath;

public class SymbolTreeActionContext
extends ProgramSymbolActionContext {
    private TreePath[] selectionPaths;

    SymbolTreeActionContext(SymbolTreeProvider provider, Program program, SymbolGTree tree, TreePath[] selectionPaths) {
        super((ComponentProvider)provider, program, SymbolTreeActionContext.getSymbolIDs(selectionPaths), (Component)((Object)tree));
        this.selectionPaths = selectionPaths;
    }

    public SymbolTreeProvider getSymbolTreeProvider() {
        return (SymbolTreeProvider)this.getComponentProvider();
    }

    public SymbolGTree getSymbolTree() {
        return (SymbolGTree)((Object)this.getContextObject());
    }

    public TreePath[] getSelectedSymbolTreePaths() {
        return this.selectionPaths;
    }

    public TreePath getSelectedPath() {
        if (this.selectionPaths.length == 1) {
            return this.selectionPaths[0];
        }
        return null;
    }

    private static long[] getSymbolIDs(TreePath[] selectionPaths) {
        if (selectionPaths == null) {
            return null;
        }
        long[] symbolIDs = new long[selectionPaths.length];
        int index = 0;
        for (TreePath treePath : selectionPaths) {
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof SymbolNode)) {
                return null;
            }
            SymbolNode symbolNode = (SymbolNode)object;
            symbolIDs[index++] = symbolNode.getSymbolID();
        }
        return symbolIDs;
    }
}

