/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis.gui;

import ghidra.app.services.AnalyzerType;
import ghidra.util.exception.AssertException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class AnalyzerUtil {
    private static final Icon BYTES_ICON = ResourceManager.loadImage((String)"images/mem_chip3.png");
    private static final Icon DATA_ICON = ResourceManager.loadImage((String)"images/Data_32.png");
    private static final Icon FUNCTION_ICON = new MultiIcon((Icon)ResourceManager.getScaledIcon((Icon)ResourceManager.loadImage((String)"images/FunctionScope.gif"), (int)28, (int)28), false, 32, 32);
    private static final Icon FUNCTION_MODIFIER_ICON = AnalyzerUtil.getIconForFunctionModifiersChanged();
    private static final Icon FUNCTION_SIGNATURE_ICON = AnalyzerUtil.getIconForFunctionSignatureChanged();
    private static final Icon INSTRUCTION_ICON = ResourceManager.loadImage((String)"images/Instructions_32.png");
    private static final Icon MANUAL_ICON = new MultiIcon((Icon)new TranslateIcon((Icon)ResourceManager.loadImage((String)"images/play.png"), 5, 5), false, 32, 32);

    private static Icon getIconForFunctionModifiersChanged() {
        TranslateIcon baseIcon = new TranslateIcon((Icon)ResourceManager.getScaledIcon((Icon)ResourceManager.loadImage((String)"images/FunctionScope.gif"), (int)22, (int)22), 10, 5);
        ImageIcon hammerIcon = ResourceManager.loadImage((String)"images/applications-development16.png");
        MultiIcon multiIcon = new MultiIcon((Icon)baseIcon, false, 32, 32);
        multiIcon.addIcon((Icon)hammerIcon);
        return multiIcon;
    }

    private static Icon getIconForFunctionSignatureChanged() {
        TranslateIcon baseIcon = new TranslateIcon((Icon)ResourceManager.getScaledIcon((Icon)ResourceManager.loadImage((String)"images/FunctionScope.gif"), (int)22, (int)22), 10, 5);
        ImageIcon pencilIcon = ResourceManager.loadImage((String)"images/pencil.png");
        MultiIcon multiIcon = new MultiIcon((Icon)baseIcon, false, 32, 32);
        multiIcon.addIcon((Icon)pencilIcon);
        return multiIcon;
    }

    public static Icon getIcon(AnalyzerType type) {
        switch (type) {
            case BYTE_ANALYZER: {
                return BYTES_ICON;
            }
            case DATA_ANALYZER: {
                return DATA_ICON;
            }
            case FUNCTION_ANALYZER: {
                return FUNCTION_ICON;
            }
            case FUNCTION_MODIFIERS_ANALYZER: {
                return FUNCTION_MODIFIER_ICON;
            }
            case FUNCTION_SIGNATURES_ANALYZER: {
                return FUNCTION_SIGNATURE_ICON;
            }
            case INSTRUCTION_ANALYZER: {
                return INSTRUCTION_ICON;
            }
            case ONE_SHOT_ANALYZER: {
                return MANUAL_ICON;
            }
        }
        throw new AssertException("Missing case statement for icons");
    }
}

