/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeSlowLoadingNode;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class FSBDirNode
extends GTreeSlowLoadingNode
implements FSBNode {
    private FSRL fsrl;

    FSBDirNode(FSRL fsrl) {
        this.fsrl = fsrl;
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        List<GTreeNode> list;
        block8: {
            RefdFile dir = FileSystemService.getInstance().getRefdFile(this.fsrl, monitor);
            try {
                list = FSBNode.getNodesFromFileList(dir.file.getListing());
                if (dir == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dir != null) {
                        try {
                            dir.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Msg.showError((Object)this, null, (String)"loadChildren", (Object)e);
                    return Collections.emptyList();
                }
            }
            dir.close();
        }
        return list;
    }

    public Icon getIcon(boolean expanded) {
        return null;
    }

    public String getName() {
        return this.fsrl.getName();
    }

    @Override
    public FSRL getFSRL() {
        return this.fsrl;
    }

    public String getToolTip() {
        return this.fsrl.getName();
    }

    public boolean isLeaf() {
        return false;
    }

    public int hashCode() {
        return this.fsrl.hashCode();
    }
}

