/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.database.properties.UnsupportedMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.GlobalSymbol;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkComparator;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.BookmarkTypeComparator;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.OffsetReference;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.ShiftedReference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.StackReference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.util.TypeMismatchException;
import ghidra.program.util.AddressRangeIteratorConverter;
import ghidra.program.util.AddressTranslator;
import ghidra.program.util.CombinedAddressRangeIterator;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.FunctionTagComparator;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.program.util.ProgramMemoryComparator;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.Msg;
import ghidra.util.Saveable;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NoValueException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class ProgramDiff {
    private ProgramDiffFilter reDiffFilter;
    private Program program1;
    private Program program2;
    private Listing listing1;
    private Listing listing2;
    private ProgramMemoryComparator pgmMemComp;
    private boolean sameProgramContext;
    private static boolean showAddressSpace = true;
    private static final int BYTE_DIFF_GRAB_SIZE = 1024;
    private ProgramDiffFilter pdf;
    private Hashtable<Integer, AddressSet> diffAddrSets = new Hashtable();
    private boolean cancelled = false;
    private AddressSet currentDiffs;
    private AddressSet diffsToReturn;
    private AddressSetView checkAddressSet;
    private AddressSetView restrictAddressSet;
    private AddressSet ignoreAddressSet;
    private boolean filterChanged = true;
    private static String monitorMsg = "Checking Differences";
    private String warnings = null;
    private static final BookmarkTypeComparator BOOKMARK_TYPE_COMPARATOR = new BookmarkTypeComparator();
    private static final BookmarkComparator BOOKMARK_COMPARATOR = new BookmarkComparator();

    public ProgramDiff(Program program1, Program program2) throws ProgramConflictException, IllegalArgumentException {
        this(program1, program2, null);
    }

    public ProgramDiff(Program program1, Program program2, AddressSetView checkAddressSet) throws ProgramConflictException, IllegalArgumentException {
        if (program1 == null || program2 == null) {
            throw new IllegalArgumentException("program cannot be null.");
        }
        this.program1 = program1;
        this.program2 = program2;
        this.listing1 = program1.getListing();
        this.listing2 = program2.getListing();
        this.pgmMemComp = new ProgramMemoryComparator(program1, program2);
        this.checkAddressSet = this.getCombinedAddressSet(checkAddressSet);
        this.ignoreAddressSet = new AddressSet();
        this.pdf = new ProgramDiffFilter(Short.MAX_VALUE);
        this.reDiffFilter = new ProgramDiffFilter();
        this.sameProgramContext = ProgramMemoryComparator.sameProgramContextRegisterNames(program1, program2);
        if (!this.sameProgramContext) {
            this.warnings = "Program Context Registers don't match between the programs.\nProgram Context Register differences will not be checked.";
        }
    }

    AddressSet getCombinedAddressSet(AddressSetView addrs) {
        AddressSet combined = ProgramMemoryComparator.getCombinedAddresses(this.program1, this.program2);
        if (addrs != null) {
            combined = combined.intersect(addrs);
        }
        return combined;
    }

    AddressSet getInCommonAddressSet(AddressSetView addrs) {
        AddressSet inCommon = this.pgmMemComp.getAddressesInCommon();
        if (addrs != null) {
            inCommon = inCommon.intersect(addrs);
        }
        return inCommon;
    }

    AddressSet getCommonInitializedAddressSet(AddressSetView addrs) {
        AddressSet initialized = this.pgmMemComp.getInitializedAddressesInCommon();
        if (addrs != null) {
            initialized = initialized.intersect(addrs);
        }
        return initialized;
    }

    AddressSet getCommonUninitializedAddressSet(AddressSetView addrs) {
        AddressSet inCommon = this.pgmMemComp.getAddressesInCommon();
        AddressSet initialized = this.pgmMemComp.getInitializedAddressesInCommon();
        AddressSet unInit = inCommon.subtract((AddressSetView)initialized);
        if (addrs != null) {
            unInit = unInit.intersect(addrs);
        }
        return unInit;
    }

    AddressSet getInitializationDiffersAddressSet(AddressSetView addrs) {
        AddressSet inCommon = this.pgmMemComp.getAddressesInCommon();
        AddressSet sameType = this.pgmMemComp.getSameMemTypeAddressesInCommon();
        AddressSet initDiffers = inCommon.subtract((AddressSetView)sameType);
        if (addrs != null) {
            initDiffers = initDiffers.intersect(addrs);
        }
        return initDiffers;
    }

    AddressSet getNonCommonAddressSet(AddressSetView addrs) {
        AddressSet addressesOnlyInOne = this.pgmMemComp.getAddressesOnlyInOne();
        AddressSet addressesOnlyInTwo = this.pgmMemComp.getAddressesOnlyInTwo();
        AddressSet onlyInTwoCompatibleWith1 = DiffUtility.getCompatibleAddressSet((AddressSetView)addressesOnlyInTwo, this.program1);
        AddressSet nonCommon = addressesOnlyInOne.union((AddressSetView)onlyInTwoCompatibleWith1);
        if (addrs != null) {
            nonCommon = nonCommon.intersect(addrs);
        }
        return nonCommon;
    }

    public boolean memoryMatches() {
        return !this.pgmMemComp.hasMemoryDifferences();
    }

    protected Object clone() {
        ProgramDiff diff = null;
        try {
            diff = new ProgramDiff(this.program1, this.program2, this.checkAddressSet);
            diff.ignoreAddressSet.add((AddressSetView)this.ignoreAddressSet);
            diff.restrictAddressSet = new AddressSet(this.restrictAddressSet);
            diff.pdf = this.pdf;
            diff.diffAddrSets = new Hashtable<Integer, AddressSet>(this.diffAddrSets);
            Enumeration<Integer> enu = diff.diffAddrSets.keys();
            while (enu.hasMoreElements()) {
                Integer key = enu.nextElement();
                AddressSet addrSet = diff.diffAddrSets.get(key);
                diff.diffAddrSets.put(key, new AddressSet((AddressSetView)addrSet));
            }
            diff.cancelled = this.cancelled;
            diff.currentDiffs = new AddressSet((AddressSetView)this.currentDiffs);
            diff.diffsToReturn = new AddressSet((AddressSetView)this.diffsToReturn);
            diff.filterChanged = this.filterChanged;
            diff.sameProgramContext = this.sameProgramContext;
            diff.warnings = this.warnings == null ? null : new String(this.warnings);
        }
        catch (ProgramConflictException exc) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + exc.getMessage()), (Throwable)((Object)exc));
        }
        return diff;
    }

    public String getWarnings() {
        return this.warnings;
    }

    public ProgramDiffFilter getFilter() {
        return new ProgramDiffFilter(this.pdf);
    }

    public void setFilter(ProgramDiffFilter filter) {
        ProgramDiffFilter tmpFilter = filter != null ? new ProgramDiffFilter(filter) : new ProgramDiffFilter(Short.MAX_VALUE);
        if (!tmpFilter.equals(this.pdf)) {
            this.pdf = tmpFilter;
            this.filterChanged = true;
        }
    }

    public Program getProgramOne() {
        return this.program1;
    }

    public Program getProgramTwo() {
        return this.program2;
    }

    public AddressSetView getCombinedAddresses() {
        return ProgramMemoryComparator.getCombinedAddresses(this.program1, this.program2);
    }

    public AddressSet getInitializedInCommon() {
        return this.pgmMemComp.getInitializedAddressesInCommon();
    }

    public AddressSet getAddressesInCommon() {
        return this.pgmMemComp.getAddressesInCommon();
    }

    public AddressSet getAddressesOnlyInOne() {
        return this.pgmMemComp.getAddressesOnlyInOne();
    }

    public AddressSet getAddressesOnlyInTwo() {
        return this.pgmMemComp.getAddressesOnlyInTwo();
    }

    public synchronized AddressSetView getDifferences(TaskMonitor monitor) throws CancelledException {
        return this.getDifferences(this.pdf, monitor);
    }

    public synchronized AddressSetView getDifferences(ProgramDiffFilter filter, TaskMonitor monitor) throws CancelledException {
        int[] pt;
        this.cancelled = false;
        if (monitor == null) {
            monitor = TaskMonitorAdapter.DUMMY_MONITOR;
        }
        if (!this.filterChanged && filter != null && filter.equals(this.pdf)) {
            return this.diffsToReturn;
        }
        this.pdf = filter;
        this.reDiffFilter.addToFilter(filter);
        this.filterChanged = false;
        this.currentDiffs = new AddressSet();
        for (int element : pt = ProgramDiffFilter.getPrimaryTypes()) {
            if (!this.pdf.getFilter(element)) continue;
            Integer key = new Integer(element);
            if (!this.diffAddrSets.containsKey(key)) {
                if (!this.cancelled) {
                    try {
                        this.createAddressSet(element, monitor);
                    }
                    catch (ProgramConflictException programConflictException) {}
                } else {
                    this.pdf.setFilter(element, false);
                }
            }
            if (this.diffAddrSets.containsKey(key)) {
                AddressSet addrSetToAdd = this.diffAddrSets.get(key);
                this.currentDiffs.add((AddressSetView)addrSetToAdd);
            }
            this.checkCancelled(monitor);
        }
        this.checkCancelled(monitor);
        monitor.setMessage("Adjusting Diff set...");
        monitor.setProgress(0L);
        this.computeDiffsToReturn();
        return this.diffsToReturn;
    }

    synchronized void reDiffSubSet(AddressSetView subSet, TaskMonitor monitor) throws CancelledException {
        if (monitor == null) {
            monitor = TaskMonitorAdapter.DUMMY_MONITOR;
        }
        monitor.checkCanceled();
        try {
            int[] pt;
            ProgramDiff subDiff = new ProgramDiff(this.program1, this.program2, subSet);
            subDiff.getDifferences(this.reDiffFilter, monitor);
            monitor.setMessage("Adjusting differences due to apply.");
            for (int element : pt = ProgramDiffFilter.getPrimaryTypes()) {
                Integer key = new Integer(element);
                AddressSet thisSet = this.diffAddrSets.get(key);
                if (thisSet == null) continue;
                AddressSet otherSet = subDiff.diffAddrSets.get(key);
                thisSet = thisSet.subtract(subSet);
                thisSet.add((AddressSetView)otherSet);
                this.diffAddrSets.put(key, thisSet);
                this.filterChanged = true;
            }
        }
        catch (ProgramConflictException e1) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)((Object)e1));
        }
        catch (IllegalArgumentException e1) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
        }
    }

    public synchronized AddressSetView getUserDefinedDiffs(String property, AddressSetView addrs, TaskMonitor monitor) throws CancelledException {
        if (this.listing1.getPropertyMap(property) instanceof UnsupportedMapDB || this.listing2.getPropertyMap(property) instanceof UnsupportedMapDB) {
            return new AddressSet();
        }
        return this.getCuiDiffs(property, addrs, new UserDefinedComparator(this.program1, this.program2, property), monitor);
    }

    public synchronized AddressSetView getTypeDiffs(int diffType, AddressSetView addrs, TaskMonitor monitor) throws ProgramConflictException, CancelledException {
        AddressSet as = new AddressSet();
        monitor.setProgress(0L);
        switch (diffType) {
            case 2: {
                monitorMsg = "Checking Byte Differences";
                monitor.setMessage(monitorMsg);
                as = this.getByteDifferences(addrs, monitor);
                break;
            }
            case 4: {
                monitorMsg = "Checking Code Unit Differences";
                monitor.setMessage(monitorMsg);
                as = this.getCodeUnitDifferences(addrs, monitor);
                break;
            }
            case 1: {
                if (!this.sameProgramContext) break;
                monitorMsg = "Checking Program Context Differences";
                monitor.setMessage(monitorMsg);
                as = this.getProgramContextDifferences(addrs, monitor);
                break;
            }
            case 8: {
                monitorMsg = "Checking End of Line Comment Differences";
                monitor.setMessage(monitorMsg);
                as = this.getCommentDiffs(0, addrs, new CommentTypeComparator(this.program1, this.program2, 0), monitor);
                break;
            }
            case 128: {
                monitorMsg = "Checking Repeatable Comment Differences";
                monitor.setMessage(monitorMsg);
                as = this.getCommentDiffs(4, addrs, new CommentTypeComparator(this.program1, this.program2, 4), monitor);
                break;
            }
            case 16: {
                monitorMsg = "Checking Pre-Comment Differences";
                monitor.setMessage(monitorMsg);
                as = this.getCommentDiffs(1, addrs, new CommentTypeComparator(this.program1, this.program2, 1), monitor);
                break;
            }
            case 32: {
                monitorMsg = "Checking Post-Comment Differences";
                monitor.setMessage(monitorMsg);
                as = this.getCommentDiffs(2, addrs, new CommentTypeComparator(this.program1, this.program2, 2), monitor);
                break;
            }
            case 64: {
                monitorMsg = "Checking Plate Comment Differences";
                monitor.setMessage(monitorMsg);
                as = this.getCommentDiffs(3, addrs, new CommentTypeComparator(this.program1, this.program2, 3), monitor);
                break;
            }
            case 256: {
                monitorMsg = "Checking Reference Differences";
                monitor.setMessage(monitorMsg);
                as = this.getReferenceDifferences(addrs, monitor);
                break;
            }
            case 8192: {
                monitorMsg = "Checking User Defined Property Differences";
                monitor.setMessage(monitorMsg);
                as = this.getUserDefinedDifferences(addrs, monitor);
                break;
            }
            case 4096: {
                monitorMsg = "Checking Bookmark Differences";
                monitor.setMessage(monitorMsg);
                as = this.getBookmarkDifferences(addrs, monitor);
                break;
            }
            case 1024: {
                monitorMsg = "Checking Label Differences";
                monitor.setMessage(monitorMsg);
                as = this.getLabelDifferences(addrs, monitor);
                break;
            }
            case 512: {
                monitorMsg = "Checking Equate Differences";
                monitor.setMessage(monitorMsg);
                as = this.getEquateDifferences(addrs, monitor);
                break;
            }
            case 2048: {
                monitorMsg = "Checking Function Differences";
                monitor.setMessage(monitorMsg);
                as = this.getFunctionDifferences(addrs, monitor);
                break;
            }
            case 16384: {
                monitorMsg = "Checking Function Tag Differences";
                monitor.setMessage(monitorMsg);
                as = this.getFunctionTagDifferences(addrs, monitor);
            }
        }
        return as;
    }

    public synchronized AddressSetView getLimitedAddressSet() {
        return this.checkAddressSet;
    }

    synchronized void setLimitedAddressSet(AddressSetView checkSet) {
        this.checkAddressSet = this.getInCommonAddressSet(checkSet);
        this.diffAddrSets.clear();
        this.currentDiffs = new AddressSet();
        this.computeDiffsToReturn();
    }

    public synchronized AddressSetView getRestrictedAddressSet() {
        return this.restrictAddressSet;
    }

    synchronized void setRestrictedAddressSet(AddressSetView restrictSet) {
        this.restrictAddressSet = restrictSet;
        this.computeDiffsToReturn();
    }

    synchronized void removeRestrictedAddressSet() {
        this.restrictAddressSet = null;
        this.computeDiffsToReturn();
    }

    public synchronized AddressSetView getIgnoreAddressSet() {
        return this.ignoreAddressSet;
    }

    public synchronized void ignore(AddressSetView addrs) {
        this.ignoreAddressSet.add(addrs);
        if (this.diffsToReturn != null) {
            this.diffsToReturn.delete(addrs);
        }
    }

    synchronized void clearIgnoreAddressSet() {
        this.ignoreAddressSet.clear();
        this.computeDiffsToReturn();
    }

    private void computeDiffsToReturn() {
        this.diffsToReturn = new AddressSet((AddressSetView)this.currentDiffs);
        if (!this.ignoreAddressSet.isEmpty()) {
            this.diffsToReturn.delete((AddressSetView)this.ignoreAddressSet);
        }
        if (this.restrictAddressSet != null && !this.restrictAddressSet.isEmpty()) {
            this.diffsToReturn = this.diffsToReturn.intersect(this.restrictAddressSet);
        }
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized void checkCancelled(TaskMonitor monitor) throws CancelledException {
        if (this.cancelled) {
            throw new CancelledException();
        }
        if (monitor.isCancelled()) {
            monitor.setMessage("Cancelled Finding Differences");
            this.cancelled = true;
            throw new CancelledException();
        }
    }

    public synchronized void printDifferences() {
        Msg.info((Object)this, (Object)"");
        if (this.cancelled) {
            Msg.info((Object)this, (Object)"\nThe last getDifferences was cancelled.");
            Msg.info((Object)this, (Object)"Therefore the differences may be incomplete...");
        }
        this.printKnownDifferences(Short.MAX_VALUE);
    }

    public synchronized void printKnownDifferences(int type) {
        int[] pt;
        Msg.info((Object)this, (Object)("\n" + ProgramDiffFilter.typeToName(type) + " differences:"));
        AddressSet diffs = new AddressSet();
        for (int element : pt = ProgramDiffFilter.getPrimaryTypes()) {
            AddressSet as = this.diffAddrSets.get(new Integer(element));
            diffs.add((AddressSetView)as);
        }
        AddressRangeIterator iter = diffs.getAddressRanges();
        while (iter.hasNext()) {
            Msg.info((Object)this, (Object)("  " + iter.next()));
        }
    }

    public synchronized void printKnownDifferencesByType(int type) {
        int[] pt;
        for (int element : pt = ProgramDiffFilter.getPrimaryTypes()) {
            Msg.info((Object)this, (Object)("\n" + ProgramDiffFilter.typeToName(element) + " differences:"));
            AddressSet as = this.diffAddrSets.get(new Integer(element));
            if (as == null) continue;
            AddressRangeIterator iter = as.getAddressRanges();
            while (iter.hasNext()) {
                Msg.info((Object)this, (Object)("  " + iter.next()));
            }
        }
    }

    private void createAddressSet(int diffType, TaskMonitor monitor) throws ProgramConflictException, CancelledException {
        AddressSet as = null;
        switch (diffType) {
            case 2: {
                monitorMsg = "Checking Byte Differences";
                monitor.setMessage(monitorMsg);
                as = this.getByteDifferences(this.checkAddressSet, monitor);
                break;
            }
            case 4: {
                monitorMsg = "Checking Code Unit Differences";
                monitor.setMessage(monitorMsg);
                as = this.getCodeUnitDifferences(this.checkAddressSet, monitor);
                break;
            }
            case 1: {
                if (!this.sameProgramContext) break;
                monitorMsg = "Checking Program Context Differences";
                monitor.setMessage(monitorMsg);
                as = this.getProgramContextDifferences(this.checkAddressSet, monitor);
                break;
            }
            case 8: {
                monitorMsg = "Checking End of Line Comment Differences";
                monitor.setMessage(monitorMsg);
                as = this.getCommentDiffs(0, this.checkAddressSet, new CommentTypeComparator(this.program1, this.program2, 0), monitor);
                break;
            }
            case 128: {
                monitorMsg = "Checking Repeatable Comment Differences";
                monitor.setMessage(monitorMsg);
                as = this.getCommentDiffs(4, this.checkAddressSet, new CommentTypeComparator(this.program1, this.program2, 4), monitor);
                break;
            }
            case 16: {
                monitorMsg = "Checking Pre-Comment Differences";
                monitor.setMessage(monitorMsg);
                as = this.getCommentDiffs(1, this.checkAddressSet, new CommentTypeComparator(this.program1, this.program2, 1), monitor);
                break;
            }
            case 32: {
                monitorMsg = "Checking Post-Comment Differences";
                monitor.setMessage(monitorMsg);
                as = this.getCommentDiffs(2, this.checkAddressSet, new CommentTypeComparator(this.program1, this.program2, 2), monitor);
                break;
            }
            case 64: {
                monitorMsg = "Checking Plate Comment Differences";
                monitor.setMessage(monitorMsg);
                as = this.getCommentDiffs(3, this.checkAddressSet, new CommentTypeComparator(this.program1, this.program2, 3), monitor);
                break;
            }
            case 256: {
                monitorMsg = "Checking Reference Differences";
                monitor.setMessage(monitorMsg);
                as = this.getReferenceDifferences(this.checkAddressSet, monitor);
                break;
            }
            case 8192: {
                monitorMsg = "Checking User Defined Property Differences";
                monitor.setMessage(monitorMsg);
                as = this.getUserDefinedDifferences(this.checkAddressSet, monitor);
                break;
            }
            case 4096: {
                monitorMsg = "Checking Bookmark Differences";
                monitor.setMessage(monitorMsg);
                as = this.getBookmarkDifferences(this.checkAddressSet, monitor);
                break;
            }
            case 1024: {
                monitorMsg = "Checking Label Differences";
                monitor.setMessage(monitorMsg);
                as = this.getLabelDifferences(this.checkAddressSet, monitor);
                break;
            }
            case 512: {
                monitor.setMessage("Checking Equate Differences");
                monitor.setMessage(monitorMsg);
                as = this.getEquateDifferences(this.checkAddressSet, monitor);
                break;
            }
            case 2048: {
                monitorMsg = "Checking Function Differences";
                monitor.setMessage(monitorMsg);
                as = this.getFunctionDifferences(this.checkAddressSet, monitor);
                break;
            }
            case 16384: {
                monitorMsg = "Checking Function Tag Differences";
                monitor.setMessage(monitorMsg);
                as = this.getFunctionTagDifferences(this.checkAddressSet, monitor);
            }
        }
        if (as != null) {
            this.diffAddrSets.put(new Integer(diffType), as);
        }
    }

    private void compareBytes(AddressRange limitedRange, AddressSet differences, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        Memory mem1 = this.program1.getMemory();
        Memory mem2 = this.program2.getMemory();
        byte[] temp1 = new byte[1024];
        byte[] temp2 = new byte[1024];
        Address min = limitedRange.getMinAddress();
        Address max = limitedRange.getMaxAddress();
        Address addr = min;
        Address addr2 = SimpleDiffUtility.getCompatibleAddress((Program)this.program1, (Address)addr, (Program)this.program2);
        Address endAddr = max;
        int addressSize = min.getAddressSpace().getAddressableUnitSize();
        do {
            MemoryBlock b1 = mem1.getBlock(addr);
            Address addrCompatibleWith2 = SimpleDiffUtility.getCompatibleAddress((Program)this.program1, (Address)addr, (Program)this.program2);
            MemoryBlock b2 = mem2.getBlock(addrCompatibleWith2);
            Address b1End = b1.getEnd();
            Address b2End = b2.getEnd();
            Address b2EndCompatibleWith1 = SimpleDiffUtility.getCompatibleAddress((Program)this.program2, (Address)b2End, (Program)this.program1);
            Address address = endAddr = b1End.compareTo((Object)max) < 0 ? b1End : max;
            if (b2EndCompatibleWith1 != null) {
                endAddr = b2EndCompatibleWith1.compareTo((Object)endAddr) < 0 ? b2EndCompatibleWith1 : endAddr;
            }
            long size = endAddr.subtract(addr) + 1L;
            int index = 0;
            while ((long)index < size) {
                int bytesToGet = (int)Math.min(size - (long)index, 1024L);
                int n1 = b1.getBytes(addr, temp1, 0, bytesToGet);
                int n2 = b2.getBytes(addr2, temp2, 0, bytesToGet);
                int nBytes = Math.min(n1, n2);
                Address start = null;
                boolean same = true;
                for (int i = 0; i < nBytes; ++i) {
                    if (temp1[i] != temp2[i]) {
                        if (!same) continue;
                        same = false;
                        start = addr.addWrap((long)i);
                        continue;
                    }
                    if (same) continue;
                    same = true;
                    differences.addRange(start, addr.addWrap((long)(i - 1)));
                }
                if (!same) {
                    same = true;
                    differences.addRange(start, addr.addWrap((long)(nBytes - 1)));
                }
                monitor.setProgress(monitor.getProgress() + (long)(nBytes / addressSize));
                monitor.setMessage(monitorMsg + ": " + addr.toString(showAddressSpace));
                try {
                    addr = addr.addNoWrap((long)nBytes);
                    addr2 = SimpleDiffUtility.getCompatibleAddress((Program)this.program1, (Address)addr, (Program)this.program2);
                }
                catch (AddressOverflowException addressOverflowException) {
                    // empty catch block
                }
                this.checkCancelled(monitor);
                index += nBytes;
            }
            this.checkCancelled(monitor);
        } while (endAddr.compareTo((Object)max) < 0);
    }

    private AddressSet getByteDifferences(AddressSetView addrs, TaskMonitor monitor) throws CancelledException {
        AddressSet differences = new AddressSet();
        differences.add((AddressSetView)this.getNonCommonAddressSet(addrs));
        differences.add((AddressSetView)this.getInitializationDiffersAddressSet(addrs));
        AddressSet inCommon = this.getAddressesInCommon();
        if (addrs != null) {
            inCommon = inCommon.intersect(addrs);
        }
        monitor.initialize(inCommon.getNumAddresses());
        AddressRangeIterator iter = inCommon.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            try {
                this.compareBytes(range, differences, monitor);
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
            this.checkCancelled(monitor);
        }
        this.checkCancelled(monitor);
        return differences;
    }

    private AddressSet getCodeUnitDifferences(AddressSetView addrs, TaskMonitor monitor) throws CancelledException {
        AddressSet differences = new AddressSet();
        monitorMsg = "Checking Instruction Differences";
        AddressSet instrDiffs = this.getAdjustedCuiDiffs("INSTRUCTION__GHIDRA_", addrs, new InstructionComparator(this.program1, this.program2), monitor);
        instrDiffs = instrDiffs.intersect((AddressSetView)this.pgmMemComp.getAddressesInCommon());
        differences.add((AddressSetView)instrDiffs);
        monitorMsg = "Checking Defined Data Differences";
        AddressSet dataDiffs = this.getAdjustedCuiDiffs("DEFINED_DATA__GHIDRA_", addrs, new DefinedDataComparator(this.program1, this.program2), monitor);
        differences.add((AddressSetView)dataDiffs);
        AddressSet contextRegDifferences = this.getContextRegisterDifferences(addrs, monitor);
        differences.add((AddressSetView)contextRegDifferences);
        return differences;
    }

    private AddressSet getProgramContextDifferences(AddressSetView addressSet, TaskMonitor monitor) throws ProgramConflictException, CancelledException {
        AddressSet differences = new AddressSet();
        ProgramContext pc1 = this.program1.getProgramContext();
        ProgramContext pc2 = this.program2.getProgramContext();
        Object[] names1 = pc1.getRegisterNames();
        Object[] names2 = pc2.getRegisterNames();
        Arrays.sort(names1);
        Arrays.sort(names2);
        if (!Arrays.equals(names1, names2)) {
            throw new ProgramConflictException("Program Context Registers don't match between the programs.");
        }
        AddressSet inCommon = this.pgmMemComp.getAddressesInCommon();
        addressSet = addressSet != null ? inCommon.intersect(addressSet) : inCommon;
        for (Object element : names1) {
            monitor.checkCanceled();
            Register rb1 = pc1.getRegister((String)element);
            Register rb2 = pc2.getRegister((String)element);
            if (rb1.isProcessorContext() || rb2.isProcessorContext()) continue;
            Register p1 = rb1.getParentRegister();
            Register p2 = rb2.getParentRegister();
            if (p1 != null && p2 != null && p1.getName().equals(p2.getName())) continue;
            this.getProgramContextDifferences(pc1, rb1, pc2, rb2, addressSet, differences, monitor);
        }
        return differences;
    }

    private void getProgramContextDifferences(ProgramContext pc1, Register reg1, ProgramContext pc2, Register reg2, AddressSetView addressSet, AddressSet differences, TaskMonitor monitor) throws CancelledException {
        AddressRangeIterator iter = addressSet.getAddressRanges();
        while (iter.hasNext()) {
            monitor.checkCanceled();
            AddressRange range = (AddressRange)iter.next();
            Address min = range.getMinAddress();
            Address max = range.getMaxAddress();
            monitor.setMessage("Checking Program Context Differences: " + reg1.getName() + " @ " + min.toString(true));
            Address min2 = SimpleDiffUtility.getCompatibleAddress((Program)this.program1, (Address)min, (Program)this.program2);
            Address max2 = SimpleDiffUtility.getCompatibleAddress((Program)this.program1, (Address)max, (Program)this.program2);
            AddressRangeIterator it1 = pc1.getRegisterValueAddressRanges(reg1, min, max);
            AddressRangeIterator it2 = pc2.getRegisterValueAddressRanges(reg2, min2, max2);
            AddressRangeIteratorConverter convertedIt2 = new AddressRangeIteratorConverter(it2, this.program1);
            CombinedAddressRangeIterator p1CombinedIterator = new CombinedAddressRangeIterator(it1, convertedIt2);
            while (p1CombinedIterator.hasNext()) {
                monitor.checkCanceled();
                AddressRange addrRange = (AddressRange)p1CombinedIterator.next();
                Address rangeMin1 = addrRange.getMinAddress();
                Address rangeMin2 = SimpleDiffUtility.getCompatibleAddress((Program)this.program1, (Address)rangeMin1, (Program)this.program2);
                RegisterValue value1 = pc1.getRegisterValue(reg1, rangeMin1);
                RegisterValue value2 = pc2.getRegisterValue(reg2, rangeMin2);
                boolean sameValue = value1 == null || value2 == null ? value1 == value2 : Arrays.equals(value1.toBytes(), value2.toBytes());
                if (sameValue) continue;
                differences.addRange(addrRange.getMinAddress(), addrRange.getMaxAddress());
            }
        }
    }

    private AddressSet getContextRegisterDifferences(AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
        AddressSet differences = new AddressSet();
        ProgramContext pc1 = this.program1.getProgramContext();
        ProgramContext pc2 = this.program2.getProgramContext();
        Register contextReg1 = pc1.getBaseContextRegister();
        Register contextReg2 = pc2.getBaseContextRegister();
        if (contextReg1 != null && contextReg2 != null) {
            AddressSet inCommon = this.pgmMemComp.getAddressesInCommon();
            addressSet = addressSet != null ? inCommon.intersect(addressSet) : inCommon;
            this.getProgramContextDifferences(pc1, pc1.getBaseContextRegister(), pc2, pc2.getBaseContextRegister(), addressSet, differences, monitor);
        }
        return differences;
    }

    private AddressSet getUserDefinedDifferences(AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
        AddressSet differences = new AddressSet();
        Iterator props1 = this.listing1.getUserDefinedProperties();
        Iterator props2 = this.listing2.getUserDefinedProperties();
        ArrayList<String> list = new ArrayList<String>();
        while (props1.hasNext()) {
            list.add((String)props1.next());
        }
        while (props2.hasNext()) {
            String propName = (String)props2.next();
            if (list.contains(propName)) continue;
            list.add(propName);
        }
        int numProps = list.size();
        for (int i = 0; i < numProps; ++i) {
            String property = (String)list.get(i);
            if (property.equals("Bookmarks") || this.listing1.getPropertyMap(property) instanceof UnsupportedMapDB || this.listing2.getPropertyMap(property) instanceof UnsupportedMapDB) continue;
            differences.add((AddressSetView)this.getCuiDiffs(property, addressSet, new UserDefinedComparator(this.program1, this.program2, property), monitor));
        }
        return differences;
    }

    private AddressSet getBookmarkDifferences(AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
        AddressSet differences = new AddressSet();
        BookmarkManager bookmarkMgr1 = this.program1.getBookmarkManager();
        BookmarkManager bookmarkMgr2 = this.program2.getBookmarkManager();
        BookmarkType[] types1 = bookmarkMgr1.getBookmarkTypes();
        BookmarkType[] types2 = bookmarkMgr2.getBookmarkTypes();
        Arrays.sort(types1, BOOKMARK_TYPE_COMPARATOR);
        Arrays.sort(types2, BOOKMARK_TYPE_COMPARATOR);
        ArrayList<BookmarkType> list = new ArrayList<BookmarkType>();
        for (BookmarkType element : types1) {
            list.add(element);
        }
        for (BookmarkType element : types2) {
            boolean found = false;
            for (int i = 0; i < list.size(); ++i) {
                BookmarkType type = (BookmarkType)list.get(i);
                if (element.getTypeString().compareTo(type.getTypeString()) != 0) continue;
                found = true;
                break;
            }
            if (found) continue;
            list.add(element);
        }
        AddressSet addressSet2 = DiffUtility.getCompatibleAddressSet(addressSet, this.program2);
        int numTypes = list.size();
        AddressSet[] sets = new AddressSet[numTypes];
        for (int i = 0; i < numTypes; ++i) {
            BookmarkType type = (BookmarkType)list.get(i);
            AddressSetView addrs1 = bookmarkMgr1.getBookmarkAddresses(type.getTypeString());
            AddressSetView addrs2 = bookmarkMgr2.getBookmarkAddresses(type.getTypeString());
            addrs1 = addrs1.intersect(addressSet);
            addrs2 = addrs2.intersect((AddressSetView)addressSet2);
            sets[i] = this.getObjectDiffs(new BookmarksComparator(type, this.program1, this.program2), new IteratorWrapper(addrs1.getAddresses(true)), new IteratorWrapper(addrs2.getAddresses(true)), monitor);
            differences.add((AddressSetView)sets[i]);
        }
        return differences;
    }

    private AddressSet getLabelDifferences(AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
        SymbolIterator iter2;
        SymbolIterator iter1;
        if (addressSet == null) {
            iter1 = this.program1.getSymbolTable().getPrimarySymbolIterator(true);
            iter2 = this.program2.getSymbolTable().getPrimarySymbolIterator(true);
        } else {
            iter1 = this.program1.getSymbolTable().getPrimarySymbolIterator(addressSet, true);
            AddressSet addressSet2 = DiffUtility.getCompatibleAddressSet(addressSet, this.program2);
            iter2 = this.program2.getSymbolTable().getPrimarySymbolIterator((AddressSetView)addressSet2, true);
        }
        return this.getObjectDiffs(new SymbolComparator(this.program1, this.program2), new IteratorWrapper(iter1), new IteratorWrapper(iter2), monitor);
    }

    private AddressSet getEquateDifferences(AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
        AddressIterator iter2;
        AddressIterator iter1;
        if (addressSet == null) {
            iter1 = this.program1.getEquateTable().getEquateAddresses();
            iter2 = this.program2.getEquateTable().getEquateAddresses();
        } else {
            iter1 = this.program1.getEquateTable().getEquateAddresses(addressSet);
            AddressSet addressSet2 = DiffUtility.getCompatibleAddressSet(addressSet, this.program2);
            iter2 = this.program2.getEquateTable().getEquateAddresses((AddressSetView)addressSet2);
        }
        return this.getObjectDiffs(new EquateComparator(this.program1, this.program2), new IteratorWrapper(iter1), new IteratorWrapper(iter2), monitor);
    }

    public boolean isSameOperandEquates(Address address, int opIndex) {
        EquateTable et1 = this.program1.getEquateTable();
        EquateTable et2 = this.program2.getEquateTable();
        List l1 = et1.getEquates(address, opIndex);
        Address address2 = SimpleDiffUtility.getCompatibleAddress((Program)this.program1, (Address)address, (Program)this.program2);
        List l2 = et2.getEquates(address2, opIndex);
        int len1 = l1.size();
        if (len1 != l2.size()) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            Equate e2;
            Equate e1 = (Equate)l1.get(i);
            if (e1.equals(e2 = (Equate)l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private AddressSet getReferenceDifferences(AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
        AddressIterator iter2;
        AddressIterator iter1;
        ReferenceManager rm1 = this.program1.getReferenceManager();
        ReferenceManager rm2 = this.program2.getReferenceManager();
        if (addressSet == null) {
            iter1 = rm1.getReferenceSourceIterator(this.program1.getMinAddress(), true);
            iter2 = rm2.getReferenceSourceIterator(this.program2.getMinAddress(), true);
        } else {
            iter1 = rm1.getReferenceSourceIterator(addressSet, true);
            AddressSet addressSet2 = DiffUtility.getCompatibleAddressSet(addressSet, this.program2);
            iter2 = rm2.getReferenceSourceIterator((AddressSetView)addressSet2, true);
        }
        AddressSet addrs = this.getObjectDiffs(new ReferenceComparator(this.program1, this.program2), new IteratorWrapper(iter1), new IteratorWrapper(iter2), monitor);
        return addrs.intersect((AddressSetView)this.pgmMemComp.getSameMemTypeAddressesInCommon());
    }

    private AddressSet getFunctionDifferences(AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
        FunctionIterator iter2;
        FunctionIterator iter1;
        if (addressSet == null) {
            iter1 = this.program1.getListing().getFunctions(true);
            iter2 = this.program2.getListing().getFunctions(true);
        } else {
            iter1 = this.program1.getListing().getFunctions(addressSet, true);
            AddressSet addressSet2 = DiffUtility.getCompatibleAddressSet(addressSet, this.program2);
            iter2 = this.program2.getListing().getFunctions((AddressSetView)addressSet2, true);
        }
        return this.getObjectDiffs(new FunctionComparator(this.program1, this.program2), new IteratorWrapper(iter1), new IteratorWrapper(iter2), monitor);
    }

    private AddressSet getFunctionTagDifferences(AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
        FunctionIterator iter1 = this.program1.getListing().getFunctions(addressSet, true);
        AddressSet addressSet2 = DiffUtility.getCompatibleAddressSet(addressSet, this.program2);
        FunctionIterator iter2 = this.program2.getListing().getFunctions((AddressSetView)addressSet2, true);
        return this.getObjectDiffs(new FunctionTagComparator(this.program1, this.program2), new IteratorWrapper(iter1), new IteratorWrapper(iter2), monitor);
    }

    private AddressSet getCuiDiffs(String cuiType, AddressSetView addressSet, CodeUnitComparator c, TaskMonitor monitor) throws CancelledException {
        CodeUnitIterator iter1 = this.listing1.getCodeUnitIterator(cuiType, addressSet, true);
        AddressSet addressSet2 = DiffUtility.getCompatibleAddressSet(addressSet, this.program2);
        CodeUnitIterator iter2 = this.listing2.getCodeUnitIterator(cuiType, (AddressSetView)addressSet2, true);
        return this.getObjectDiffs(c, new IteratorWrapper(iter1), new IteratorWrapper(iter2), monitor);
    }

    private AddressSet getCommentDiffs(int commentType, AddressSetView addressSet, CommentTypeComparator c, TaskMonitor monitor) throws CancelledException {
        AddressIterator iter1 = this.listing1.getCommentAddressIterator(commentType, addressSet, true);
        AddressSet addressSet2 = DiffUtility.getCompatibleAddressSet(addressSet, this.program2);
        AddressIterator iter2 = this.listing2.getCommentAddressIterator(commentType, (AddressSetView)addressSet2, true);
        return this.getObjectDiffs(c, new IteratorWrapper(iter1), new IteratorWrapper(iter2), monitor);
    }

    private AddressSet getAdjustedCuiDiffs(String cuiType, AddressSetView addressSet, CodeUnitComparator c, TaskMonitor monitor) throws CancelledException {
        AddressSet inCommon = this.pgmMemComp.getAddressesInCommon();
        if (addressSet != null) {
            inCommon = inCommon.intersect(addressSet);
        }
        AddressSet as1 = this.adjustCodeUnitAddressSet((AddressSetView)inCommon, this.listing1, monitor);
        CodeUnitIterator iter1 = this.listing1.getCodeUnitIterator(cuiType, (AddressSetView)as1, true);
        AddressSet inCommonFrom2 = DiffUtility.getCompatibleAddressSet((AddressSetView)inCommon, this.program2);
        AddressSet as2 = this.adjustCodeUnitAddressSet((AddressSetView)inCommonFrom2, this.listing2, monitor);
        CodeUnitIterator iter2 = this.listing2.getCodeUnitIterator(cuiType, (AddressSetView)as2, true);
        return this.getObjectDiffs(c, new IteratorWrapper(iter1), new IteratorWrapper(iter2), monitor);
    }

    private AddressSet adjustCodeUnitAddressSet(AddressSetView initialAddressSet, Listing listing, TaskMonitor monitor) throws CancelledException {
        if (initialAddressSet == null) {
            return null;
        }
        monitor.initialize((long)initialAddressSet.getNumAddressRanges());
        int count = 0;
        AddressSet tmpAddrSet = new AddressSet();
        AddressRangeIterator iter = initialAddressSet.getAddressRanges();
        while (iter.hasNext()) {
            monitor.checkCanceled();
            AddressRange range = (AddressRange)iter.next();
            Address minAddr = range.getMinAddress();
            Address maxAddr = range.getMaxAddress();
            monitor.setMessage(monitorMsg + ": Adjusting code unit set @ " + minAddr.toString() + ".");
            CodeUnit cu = listing.getCodeUnitContaining(minAddr);
            if (cu != null) {
                minAddr = cu.getMinAddress();
            }
            if ((cu = listing.getCodeUnitContaining(maxAddr)) != null) {
                maxAddr = cu.getMaxAddress();
            }
            tmpAddrSet.addRange(minAddr, maxAddr);
            monitor.setProgress((long)(++count));
        }
        return tmpAddrSet;
    }

    private AddressSet getObjectDiffs(ProgramDiffComparator c, IteratorWrapper iter1, IteratorWrapper iter2, TaskMonitor monitor) throws CancelledException {
        AddressSet addrs = new AddressSet();
        Object o1 = null;
        Object o2 = null;
        AddressSet a1 = new AddressSet();
        AddressSet a2 = new AddressSet();
        AddressSet a2CompatibleWith1 = DiffUtility.getCompatibleAddressSet((AddressSetView)a2, this.program1);
        if (iter1.hasNext()) {
            o1 = iter1.next();
            a1 = c.getAddressSet(o1, c.getProgramOne());
        }
        if (iter2.hasNext()) {
            o2 = iter2.next();
            a2 = c.getAddressSet(o2, c.getProgramTwo());
            a2CompatibleWith1 = DiffUtility.getCompatibleAddressSet((AddressSetView)a2, this.program1);
        }
        while (o1 != null && o2 != null) {
            boolean move1 = false;
            boolean move2 = false;
            int result = c.compare(o1, o2);
            if (result < 0) {
                addrs.add((AddressSetView)a1);
                move1 = true;
            } else if (result > 0) {
                addrs.add((AddressSetView)a2CompatibleWith1);
                move2 = true;
            } else {
                if (!c.isSame(o1, o2)) {
                    addrs.add((AddressSetView)a1);
                    addrs.add((AddressSetView)a2CompatibleWith1);
                }
                move1 = true;
                move2 = true;
            }
            monitor.setMessage(monitorMsg + ": " + (move1 ? a1.getMinAddress().toString(showAddressSpace) : a2.getMinAddress().toString(showAddressSpace)));
            if (move1) {
                if (iter1.hasNext()) {
                    o1 = iter1.next();
                    a1 = c.getAddressSet(o1, c.getProgramOne());
                } else {
                    o1 = null;
                }
            }
            if (move2) {
                if (iter2.hasNext()) {
                    o2 = iter2.next();
                    a2 = c.getAddressSet(o2, c.getProgramTwo());
                    a2CompatibleWith1 = DiffUtility.getCompatibleAddressSet((AddressSetView)a2, this.program1);
                } else {
                    o2 = null;
                }
            }
            this.checkCancelled(monitor);
        }
        if (o1 != null) {
            addrs.add((AddressSetView)a1);
        }
        while (iter1.hasNext()) {
            o1 = iter1.next();
            a1 = c.getAddressSet(o1, c.getProgramOne());
            addrs.add((AddressSetView)a1);
            this.checkCancelled(monitor);
            monitor.setMessage(monitorMsg + ": " + a1.getMinAddress().toString(showAddressSpace));
        }
        if (o2 != null) {
            addrs.add((AddressSetView)a2CompatibleWith1);
        }
        while (iter2.hasNext()) {
            this.checkCancelled(monitor);
            o2 = iter2.next();
            a2 = c.getAddressSet(o2, c.getProgramTwo());
            Address min = a2.getMinAddress();
            if (min == null) continue;
            a2CompatibleWith1 = DiffUtility.getCompatibleAddressSet((AddressSetView)a2, this.program1);
            addrs.add((AddressSetView)a2CompatibleWith1);
            monitor.setMessage(monitorMsg + ": " + min.toString(showAddressSpace));
        }
        return addrs;
    }

    static boolean equivalentBookmarkArrays(Program pgm1, Program pgm2, Bookmark[] bookmarks1, Bookmark[] bookmarks2) {
        if (bookmarks1 == bookmarks2) {
            return true;
        }
        if (bookmarks1 == null || bookmarks2 == null) {
            return false;
        }
        int length = bookmarks1.length;
        if (bookmarks2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Bookmark bookmark1 = bookmarks1[i];
            Bookmark bookmark2 = bookmarks2[i];
            if (bookmark1 != null ? ProgramDiff.equivalentBookmarks(pgm1, pgm2, bookmark1, bookmark2) : bookmark2 == null) continue;
            return false;
        }
        return true;
    }

    static boolean equivalentBookmarks(Program pgm1, Program pgm2, Bookmark bookmark1, Bookmark bookmark2) {
        Address addr2;
        Address addr2AsP1;
        Address addr1 = bookmark1.getAddress();
        return SystemUtilities.isEqual((Object)addr1, (Object)(addr2AsP1 = SimpleDiffUtility.getCompatibleAddress((Program)pgm2, (Address)(addr2 = bookmark2.getAddress()), (Program)pgm1))) && bookmark1.getTypeString().equals(bookmark2.getTypeString()) && bookmark1.getCategory().equals(bookmark2.getCategory()) && bookmark1.getComment().equals(bookmark2.getComment());
    }

    static boolean equivalentVariableArrays(Variable[] vars1, Variable[] vars2, boolean checkParamStorage) {
        if (vars1 == vars2) {
            return true;
        }
        if (vars1 == null || vars2 == null) {
            return false;
        }
        int length = vars1.length;
        if (vars2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            boolean checkStorage;
            if (vars1[i] instanceof Parameter != vars2[i] instanceof Parameter) {
                return false;
            }
            boolean bl = checkStorage = !(vars1[i] instanceof Parameter) || checkParamStorage;
            if (vars1[i] != null ? ProgramDiff.equivalentVariables(vars1[i], vars2[i], checkStorage) : vars2[i] == null) continue;
            return false;
        }
        return true;
    }

    static boolean equivalentVariables(Variable var1, Variable var2, boolean checkStorage) {
        if (var1 instanceof Parameter != var2 instanceof Parameter) {
            return false;
        }
        boolean isReturn = false;
        if (var1 instanceof Parameter) {
            int ordinal2;
            int ordinal1 = ((Parameter)var1).getOrdinal();
            if (ordinal1 != (ordinal2 = ((Parameter)var2).getOrdinal())) {
                return false;
            }
            isReturn = ordinal1 == -1;
        } else if (var1.getFirstUseOffset() != var2.getFirstUseOffset()) {
            return false;
        }
        String comment1 = var1.getComment();
        String comment2 = var2.getComment();
        if (!(var1.equals(var2) && var1.getDataType().isEquivalent(var2.getDataType()) && SystemUtilities.isEqual((Object)comment1, (Object)comment2))) {
            return false;
        }
        if (checkStorage && !DiffUtility.variableStorageMatches(var1, var2)) {
            return false;
        }
        if (isReturn) {
            return true;
        }
        if (var1.getSource() == SourceType.DEFAULT && var2.getSource() == SourceType.DEFAULT) {
            return true;
        }
        return var1.getName().equals(var2.getName());
    }

    public static boolean equivalentFunctions(Function f1, Function f2) {
        return ProgramDiff.equivalentFunctions(f1, f2, false);
    }

    public static boolean equivalentFunctions(Function f1, Function f2, boolean ignoreName) {
        boolean f2IsExternal;
        boolean f2IsThunk;
        if (f1 == f2) {
            return true;
        }
        if (f1 == null || f2 == null) {
            return false;
        }
        boolean f1IsThunk = f1.isThunk();
        if (f1IsThunk != (f2IsThunk = f2.isThunk())) {
            return false;
        }
        Program program1 = f1.getProgram();
        Program program2 = f2.getProgram();
        boolean f1IsExternal = f1.isExternal();
        if (f1IsExternal != (f2IsExternal = f2.isExternal())) {
            return false;
        }
        if (!f1IsExternal) {
            AddressSetView body2;
            AddressSet body2AsP1;
            Address entry2;
            Address entry2AsP1;
            Address entry1 = f1.getEntryPoint();
            if (!entry1.equals((Object)(entry2AsP1 = SimpleDiffUtility.getCompatibleAddress((Program)program2, (Address)(entry2 = f2.getEntryPoint()), (Program)program1)))) {
                return false;
            }
            AddressSetView body1 = f1.getBody();
            if (!body1.equals(body2AsP1 = DiffUtility.getCompatibleAddressSet(body2 = f2.getBody(), program1))) {
                return false;
            }
        }
        if (f1IsThunk) {
            return ProgramDiff.isEquivalentThunk(f1, f2);
        }
        StackFrame frame1 = f1.getStackFrame();
        StackFrame frame2 = f2.getStackFrame();
        if (!ignoreName && !f1.getName().equals(f2.getName()) || f1.getStackPurgeSize() != f2.getStackPurgeSize() || f1.getSignatureSource() != f2.getSignatureSource() || f1.hasVarArgs() != f2.hasVarArgs() || f1.isInline() != f2.isInline() || f1.hasNoReturn() != f2.hasNoReturn() || !ProgramDiff.equivalentTagSets(f1.getTags(), f2.getTags()) || !f1.getCallingConventionName().equals(f2.getCallingConventionName()) || frame1.getReturnAddressOffset() != frame2.getReturnAddressOffset() || f1.hasCustomVariableStorage() != f2.hasCustomVariableStorage()) {
            return false;
        }
        boolean hasCustomStorage = f1.hasCustomVariableStorage();
        if (!ProgramDiff.equivalentVariables((Variable)f1.getReturn(), (Variable)f2.getReturn(), hasCustomStorage)) {
            return false;
        }
        if (!ProgramDiff.equivalentVariableArrays((Variable[])f1.getParameters(), (Variable[])f2.getParameters(), hasCustomStorage)) {
            return false;
        }
        return f1IsExternal || ProgramDiff.equivalentVariableArrays(f1.getLocalVariables(), f2.getLocalVariables(), false);
    }

    public static boolean isEquivalentThunk(Function thunkFunction1, Function thunkFunction2) {
        if (!thunkFunction1.isThunk() || !thunkFunction2.isThunk()) {
            return false;
        }
        Function thunkedFunction1 = thunkFunction1.getThunkedFunction(false);
        Address thunkedEntry1 = thunkedFunction1.getEntryPoint();
        Function thunkedFunction2 = thunkFunction2.getThunkedFunction(false);
        Address thunkedEntry2 = thunkedFunction2.getEntryPoint();
        if (thunkedFunction1.isExternal() != thunkedFunction2.isExternal()) {
            return false;
        }
        Symbol fSym1 = thunkFunction1.getSymbol();
        Symbol fSym2 = thunkFunction2.getSymbol();
        if (!(fSym1.getSource() == SourceType.DEFAULT && fSym2.getSource() == SourceType.DEFAULT || ProgramDiff.sameFunctionNames(thunkFunction1, thunkFunction2))) {
            return false;
        }
        if (!thunkedFunction1.isExternal()) {
            Address thunkedEntry2AsP1 = SimpleDiffUtility.getCompatibleAddress((Program)thunkFunction2.getProgram(), (Address)thunkedEntry2, (Program)thunkFunction1.getProgram());
            return thunkedEntry1.equals((Object)thunkedEntry2AsP1);
        }
        ExternalLocation external1 = thunkedFunction1.getExternalLocation();
        ExternalLocation external2 = thunkedFunction2.getExternalLocation();
        return external1.isEquivalent(external2);
    }

    public static boolean sameFunctionNames(Function f1, Function f2) {
        if (f1 == null) {
            return f2 == null;
        }
        if (f2 == null) {
            return false;
        }
        String name1 = f1.getName();
        String name2 = f2.getName();
        Symbol symbol1 = f1.getSymbol();
        Symbol symbol2 = f2.getSymbol();
        if (ProgramDiff.isDefaultName(symbol1)) {
            return ProgramDiff.isDefaultName(symbol2);
        }
        if (ProgramDiff.isDefaultName(symbol2)) {
            return false;
        }
        return name1.equals(name2);
    }

    private static boolean isDefaultName(Symbol symbol) {
        return symbol.getSource() == SourceType.DEFAULT;
    }

    static boolean equivalentTagSets(Set<FunctionTag> setA, Set<FunctionTag> setB) {
        ArrayList<FunctionTag> listA = new ArrayList<FunctionTag>(setA);
        ArrayList<FunctionTag> listB = new ArrayList<FunctionTag>(setB);
        Collections.sort(listA);
        Collections.sort(listB);
        return listA.equals(listB);
    }

    public boolean equalRefArrays(Reference[] refs1, Reference[] refs2) {
        return ProgramDiff.equivalentReferenceArrays(this.program1, this.program2, refs1, refs2);
    }

    static boolean equivalentReferenceArrays(Program pgm1, Program pgm2, Reference[] refs1, Reference[] refs2) {
        if (refs1 == refs2) {
            return true;
        }
        if (refs1 == null || refs2 == null) {
            return false;
        }
        int length = refs1.length;
        if (refs2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Reference ref1 = refs1[i];
            Reference ref2 = refs2[i];
            if (ref1 != null ? ProgramDiff.equivalentReferences(pgm1, pgm2, ref1, ref2) : ref2 == null) continue;
            return false;
        }
        return true;
    }

    public boolean equalRefs(Reference ref1, Reference ref2) {
        return ProgramDiff.equivalentReferences(this.program1, this.program2, ref1, ref2);
    }

    static boolean equivalentReferences(Program p1, Program p2, Reference ref1, Reference ref2) {
        Symbol p2Symbol;
        Address toAddr2;
        Address toAddr2AsP1;
        Address toAddr1;
        Address fromAddr2;
        Address fromAddr2AsP1;
        if (ref1 == ref2) {
            return true;
        }
        if (ref1 == null || ref2 == null) {
            return false;
        }
        if (ref1.getOperandIndex() != ref2.getOperandIndex() || ref1.getReferenceType() != ref2.getReferenceType() || ref1.isPrimary() != ref2.isPrimary()) {
            return false;
        }
        Address fromAddr1 = ref1.getFromAddress();
        if (!fromAddr1.equals((Object)(fromAddr2AsP1 = SimpleDiffUtility.getCompatibleAddress((Program)p2, (Address)(fromAddr2 = ref2.getFromAddress()), (Program)p1)))) {
            return false;
        }
        if (!ref1.isExternalReference() && !(toAddr1 = ref1.getToAddress()).equals((Object)(toAddr2AsP1 = SimpleDiffUtility.getCompatibleAddress((Program)p2, (Address)(toAddr2 = ref2.getToAddress()), (Program)p1)))) {
            return false;
        }
        Symbol p1Symbol = p1.getSymbolTable().getSymbol(ref1.getSymbolID());
        if (!ProgramDiff.equivalentSymbols(p1, p2, p1Symbol, p2Symbol = p2.getSymbolTable().getSymbol(ref2.getSymbolID()))) {
            return false;
        }
        if (ref1.isEntryPointReference()) {
            return ref2.isEntryPointReference();
        }
        if (ref1.isExternalReference()) {
            if (!ref2.isExternalReference()) {
                return false;
            }
            ExternalReference extRef1 = (ExternalReference)ref1;
            ExternalReference extRef2 = (ExternalReference)ref2;
            ExternalLocation extLoc1 = extRef1.getExternalLocation();
            ExternalLocation extLoc2 = extRef2.getExternalLocation();
            return ProgramDiff.isEquivalent(extLoc1, extLoc2);
        }
        if (ref1.isOffsetReference()) {
            if (!ref2.isOffsetReference()) {
                return false;
            }
            OffsetReference offsetRef1 = (OffsetReference)ref1;
            OffsetReference offsetRef2 = (OffsetReference)ref2;
            return offsetRef1.getOffset() == offsetRef2.getOffset();
        }
        if (ref1.isShiftedReference()) {
            if (!ref2.isShiftedReference()) {
                return false;
            }
            ShiftedReference shiftedRef1 = (ShiftedReference)ref1;
            ShiftedReference shiftedRef2 = (ShiftedReference)ref2;
            return shiftedRef1.getShift() == shiftedRef2.getShift();
        }
        if (ref1.isStackReference()) {
            if (!ref2.isStackReference()) {
                return false;
            }
            StackReference stackRef1 = (StackReference)ref1;
            StackReference stackRef2 = (StackReference)ref2;
            return stackRef1.getStackOffset() == stackRef2.getStackOffset();
        }
        if (ref1.isRegisterReference() && !ref2.isRegisterReference()) {
            return false;
        }
        if (ref1.isMemoryReference()) {
            return ref2.isMemoryReference();
        }
        return true;
    }

    private static boolean isEquivalent(ExternalLocation extLoc1, ExternalLocation extLoc2) {
        if (extLoc1 == null && extLoc2 == null) {
            return true;
        }
        if (extLoc1 == null || extLoc2 == null) {
            return false;
        }
        return extLoc1.isEquivalent(extLoc2);
    }

    static boolean equivalentReferences(AddressTranslator p2ToP1Translator, Reference p1Ref, Reference p2Ref) {
        Symbol p2Symbol;
        Address toAddr2;
        Address toAddr2AsP1;
        Address toAddr1;
        Address fromAddr2;
        Address fromAddr2AsP1;
        if (p1Ref == p2Ref) {
            return true;
        }
        if (p1Ref == null || p2Ref == null) {
            return false;
        }
        if (p1Ref.getOperandIndex() != p2Ref.getOperandIndex() || p1Ref.getReferenceType() != p2Ref.getReferenceType() || p1Ref.isPrimary() != p2Ref.isPrimary()) {
            return false;
        }
        Address fromAddr1 = p1Ref.getFromAddress();
        if (!fromAddr1.equals((Object)(fromAddr2AsP1 = p2ToP1Translator.getAddress(fromAddr2 = p2Ref.getFromAddress())))) {
            return false;
        }
        if (!p1Ref.isExternalReference() && !(toAddr1 = p1Ref.getToAddress()).equals((Object)(toAddr2AsP1 = p2ToP1Translator.getAddress(toAddr2 = p2Ref.getToAddress())))) {
            return false;
        }
        Symbol p1Symbol = p2ToP1Translator.getDestinationProgram().getSymbolTable().getSymbol(p1Ref.getSymbolID());
        if (!ProgramDiff.equivalentSymbols(p2ToP1Translator, p1Symbol, p2Symbol = p2ToP1Translator.getSourceProgram().getSymbolTable().getSymbol(p2Ref.getSymbolID()))) {
            return false;
        }
        if (p1Ref.isEntryPointReference()) {
            return p2Ref.isEntryPointReference();
        }
        if (p1Ref.isExternalReference()) {
            if (!p2Ref.isExternalReference()) {
                return false;
            }
            ExternalReference extRef1 = (ExternalReference)p1Ref;
            ExternalReference extRef2 = (ExternalReference)p2Ref;
            ExternalLocation extLoc1 = extRef1.getExternalLocation();
            ExternalLocation extLoc2 = extRef2.getExternalLocation();
            return SystemUtilities.isEqual((Object)extLoc1, (Object)extLoc2);
        }
        if (p1Ref.isOffsetReference()) {
            if (!p2Ref.isOffsetReference()) {
                return false;
            }
            OffsetReference offsetRef1 = (OffsetReference)p1Ref;
            OffsetReference offsetRef2 = (OffsetReference)p2Ref;
            return offsetRef1.getOffset() == offsetRef2.getOffset();
        }
        if (p1Ref.isShiftedReference()) {
            if (!p2Ref.isShiftedReference()) {
                return false;
            }
            ShiftedReference shiftedRef1 = (ShiftedReference)p1Ref;
            ShiftedReference shiftedRef2 = (ShiftedReference)p2Ref;
            return shiftedRef1.getShift() == shiftedRef2.getShift();
        }
        if (p1Ref.isStackReference()) {
            if (!p2Ref.isStackReference()) {
                return false;
            }
            StackReference stackRef1 = (StackReference)p1Ref;
            StackReference stackRef2 = (StackReference)p2Ref;
            return stackRef1.getStackOffset() == stackRef2.getStackOffset();
        }
        if (p1Ref.isRegisterReference() && !p2Ref.isRegisterReference()) {
            return false;
        }
        if (p1Ref.isMemoryReference()) {
            return p2Ref.isMemoryReference();
        }
        return true;
    }

    public static Reference[] getDiffRefs(Reference[] refs) {
        ArrayList<Reference> refList = new ArrayList<Reference>();
        for (Reference reference : refs) {
            if (reference.getReferenceType().isFallthrough()) continue;
            refList.add(reference);
        }
        return refList.toArray(new Reference[refList.size()]);
    }

    static boolean equivalentInstructionPrototypes(Instruction i1, Instruction i2) {
        boolean samePrototypes = false;
        samePrototypes = i1.getPrototype().getLanguage().equals(i2.getPrototype().getLanguage()) ? i1.getPrototype().equals(i2.getPrototype()) : i1.toString().equals(i2.toString());
        return samePrototypes;
    }

    static boolean isSameFallthrough(Program program1, Instruction i1, Program program2, Instruction i2) {
        boolean overridden2;
        boolean overridden1 = i1.isFallThroughOverridden();
        if (overridden1 != (overridden2 = i2.isFallThroughOverridden())) {
            return false;
        }
        Address fallThrough1 = i1.getFallThrough();
        Address fallThrough1As2 = SimpleDiffUtility.getCompatibleAddress((Program)program1, (Address)fallThrough1, (Program)program2);
        return SystemUtilities.isEqual((Object)i2.getFallThrough(), (Object)fallThrough1As2);
    }

    static boolean equivalentSymbols(Program p1, Program p2, Symbol p1Symbol, Symbol p2Symbol) {
        Symbol p2Parent;
        Address p2SymbolAddress;
        Address p2SymbolAddressAsP1;
        SourceType p2SourceType;
        if (p1Symbol == p2Symbol) {
            return true;
        }
        if (p1Symbol == null) {
            return p2Symbol == null;
        }
        if (p2Symbol == null) {
            return false;
        }
        SourceType p1SourceType = p1Symbol instanceof GlobalSymbol ? null : p1Symbol.getSource();
        SourceType sourceType = p2SourceType = p2Symbol instanceof GlobalSymbol ? null : p2Symbol.getSource();
        if (p1SourceType != p2SourceType) {
            return false;
        }
        if (p1SourceType != SourceType.DEFAULT && !p1Symbol.getName().equals(p2Symbol.getName())) {
            return false;
        }
        if (p1Symbol.isDynamic()) {
            return p2Symbol.isDynamic();
        }
        if (p2Symbol.isDynamic()) {
            return false;
        }
        Address p1SymbolAddress = p1Symbol.getAddress();
        if (!p1SymbolAddress.equals((Object)(p2SymbolAddressAsP1 = SimpleDiffUtility.getCompatibleAddress((Program)p2, (Address)(p2SymbolAddress = p2Symbol.getAddress()), (Program)p1)))) {
            return false;
        }
        if (!p1Symbol.getSymbolType().equals((Object)p2Symbol.getSymbolType())) {
            return false;
        }
        if (p1Symbol.isPrimary() != p2Symbol.isPrimary()) {
            return false;
        }
        if (p1Symbol.isPinned() != p2Symbol.isPinned()) {
            return false;
        }
        Symbol p1Parent = p1Symbol.getParentSymbol();
        return ProgramDiff.equivalentSymbols(p1, p2, p1Parent, p2Parent = p2Symbol.getParentSymbol());
    }

    static boolean equivalentSymbols(AddressTranslator p2ToP1Translator, Symbol p1Symbol, Symbol p2Symbol) {
        Symbol p2Parent;
        Address p2SymbolAddress;
        Address p2SymbolAddressAsP1;
        SourceType p2SourceType;
        if (p1Symbol == p2Symbol) {
            return true;
        }
        if (p1Symbol == null) {
            return p2Symbol == null;
        }
        if (p2Symbol == null) {
            return false;
        }
        if (p1Symbol.isDynamic()) {
            return p2Symbol.isDynamic();
        }
        if (p2Symbol.isDynamic()) {
            return false;
        }
        SourceType p1SourceType = p1Symbol instanceof GlobalSymbol ? null : p1Symbol.getSource();
        SourceType sourceType = p2SourceType = p2Symbol instanceof GlobalSymbol ? null : p2Symbol.getSource();
        if (p1SourceType != p2SourceType) {
            return false;
        }
        if (p1SourceType != SourceType.DEFAULT && !p1Symbol.getName().equals(p2Symbol.getName())) {
            return false;
        }
        Address p1SymbolAddress = p1Symbol.getAddress();
        if (!p1SymbolAddress.equals((Object)(p2SymbolAddressAsP1 = p2ToP1Translator.getAddress(p2SymbolAddress = p2Symbol.getAddress())))) {
            return false;
        }
        if (!p1Symbol.getSymbolType().equals((Object)p2Symbol.getSymbolType())) {
            return false;
        }
        if (p1Symbol.isPrimary() != p2Symbol.isPrimary()) {
            return false;
        }
        if (p1Symbol.isPinned() != p2Symbol.isPinned()) {
            return false;
        }
        Symbol p1Parent = p1Symbol.getParentSymbol();
        return ProgramDiff.equivalentSymbols(p2ToP1Translator, p1Parent, p2Parent = p2Symbol.getParentSymbol());
    }

    private class SymbolNameComparator
    implements Comparator<Symbol> {
        SymbolNameComparator() {
        }

        @Override
        public int compare(Symbol s1, Symbol s2) {
            int comparison = s1.getName().compareTo(s2.getName());
            return comparison;
        }
    }

    private static class IteratorWrapper {
        Object iterator;

        public IteratorWrapper(Object iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            if (this.iterator instanceof AddressIterator) {
                return ((AddressIterator)this.iterator).hasNext();
            }
            if (this.iterator instanceof CodeUnitIterator) {
                return ((CodeUnitIterator)this.iterator).hasNext();
            }
            if (this.iterator instanceof SymbolIterator) {
                return ((SymbolIterator)this.iterator).hasNext();
            }
            if (this.iterator instanceof FunctionIterator) {
                return ((FunctionIterator)this.iterator).hasNext();
            }
            return false;
        }

        public Object next() throws NoSuchElementException {
            if (this.iterator instanceof AddressIterator) {
                return ((AddressIterator)this.iterator).next();
            }
            if (this.iterator instanceof CodeUnitIterator) {
                return ((CodeUnitIterator)this.iterator).next();
            }
            if (this.iterator instanceof SymbolIterator) {
                return ((SymbolIterator)this.iterator).next();
            }
            if (this.iterator instanceof FunctionIterator) {
                return ((FunctionIterator)this.iterator).next();
            }
            return null;
        }
    }

    private class DefinedDataComparator
    extends CodeUnitComparator {
        private DefinedDataComparator(Program program1, Program program2) {
            super(program1, program2);
        }

        @Override
        public boolean isSame(Object obj1, Object obj2) {
            DataType dt2;
            Data d1 = (Data)obj1;
            Data d2 = (Data)obj2;
            if (d1.getLength() != d2.getLength()) {
                return false;
            }
            DataType dt1 = d1.getDataType();
            if (!dt1.isEquivalent(dt2 = d2.getDataType())) {
                return false;
            }
            return dt1.getPathName().equals(dt2.getPathName());
        }
    }

    private class InstructionComparator
    extends CodeUnitComparator {
        private InstructionComparator(Program program1, Program program2) {
            super(program1, program2);
        }

        @Override
        public boolean isSame(Object obj1, Object obj2) {
            Instruction i1 = (Instruction)obj1;
            Instruction i2 = (Instruction)obj2;
            if (i1 == i2) {
                return true;
            }
            if (i1.getLength() != i2.getLength()) {
                return false;
            }
            if (!ProgramDiff.equivalentInstructionPrototypes(i1, i2)) {
                return false;
            }
            if (i1.getFlowOverride() != i2.getFlowOverride()) {
                return false;
            }
            if (!ProgramDiff.isSameFallthrough(this.program1, i1, this.program2, i2)) {
                return false;
            }
            try {
                if (!Arrays.equals(i1.getBytes(), i2.getBytes())) {
                    return false;
                }
            }
            catch (MemoryAccessException e) {
                String message = "Diff couldn't get the underlying bytes when comparing instructions. instruction1 is at " + i1.getAddress().toString(true) + ". instruction2 is at " + i2.getAddress().toString(true) + ".  " + e.getMessage();
                Msg.error((Object)this, (Object)message, (Throwable)e);
                return false;
            }
            return true;
        }
    }

    private class UserDefinedComparator
    extends CodeUnitComparator {
        String propertyName;

        private UserDefinedComparator(Program program1, Program program2, String property) {
            super(program1, program2);
            this.propertyName = property;
        }

        @Override
        public boolean isSame(Object obj1, Object obj2) {
            CodeUnit cu1 = (CodeUnit)obj1;
            CodeUnit cu2 = (CodeUnit)obj2;
            Object p1 = null;
            Object p2 = null;
            p1 = this.getProperty(cu1, this.propertyName);
            p2 = this.getProperty(cu2, this.propertyName);
            return SystemUtilities.isEqual((Object)p1, (Object)p2);
        }

        private Object getProperty(CodeUnit cu, String localPropertyName) {
            Object obj = null;
            if (cu.hasProperty(localPropertyName)) {
                try {
                    int intProp = cu.getIntProperty(localPropertyName);
                    return new Integer(intProp);
                }
                catch (NoValueException intProp) {
                }
                catch (TypeMismatchException intProp) {
                    // empty catch block
                }
                try {
                    String stringProp = cu.getStringProperty(localPropertyName);
                    return stringProp;
                }
                catch (TypeMismatchException stringProp) {
                    try {
                        Saveable objProp = cu.getObjectProperty(localPropertyName);
                        return objProp;
                    }
                    catch (TypeMismatchException objProp) {
                        try {
                            boolean voidProp = cu.getVoidProperty(localPropertyName);
                            return new Boolean(voidProp);
                        }
                        catch (TypeMismatchException typeMismatchException) {
                            // empty catch block
                        }
                    }
                }
            }
            return obj;
        }
    }

    private class ReferenceComparator
    extends ProgramDiffComparatorImpl {
        ReferenceManager rm1;
        ReferenceManager rm2;

        private ReferenceComparator(Program program1, Program program2) {
            super(program1, program2);
            this.rm1 = program1.getReferenceManager();
            this.rm2 = program2.getReferenceManager();
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            Address a1 = (Address)obj1;
            Address a2 = (Address)obj2;
            Address address2CompatibleWith1 = SimpleDiffUtility.getCompatibleAddress((Program)this.program2, (Address)a2, (Program)this.program1);
            return a1.compareTo((Object)address2CompatibleWith1);
        }

        @Override
        public boolean isSame(Object obj1, Object obj2) {
            Address addr1 = (Address)obj1;
            Address addr2 = (Address)obj2;
            Reference[] refs1 = this.rm1.getReferencesFrom(addr1);
            Reference[] refs2 = this.rm2.getReferencesFrom(addr2);
            Object[] diffRefs1 = ProgramDiff.getDiffRefs(refs1);
            Object[] diffRefs2 = ProgramDiff.getDiffRefs(refs2);
            Arrays.sort(diffRefs1);
            Arrays.sort(diffRefs2);
            return ProgramDiff.this.equalRefArrays((Reference[])diffRefs1, (Reference[])diffRefs2);
        }

        @Override
        public AddressSet getAddressSet(Object obj, Program program) {
            AddressSet addrs = new AddressSet();
            if (obj == null) {
                return addrs;
            }
            Address addr = (Address)obj;
            CodeUnit cu = program.getListing().getCodeUnitContaining(addr);
            if (cu != null) {
                addrs.addRange(cu.getMinAddress(), cu.getMaxAddress());
            }
            return addrs;
        }
    }

    private class CommentTypeComparator
    extends ProgramDiffComparatorImpl {
        int type;
        private Listing comparatorListing1;
        private Listing comparatorListing2;

        private CommentTypeComparator(Program program1, Program program2, int type) {
            super(program1, program2);
            this.type = type;
            this.comparatorListing1 = program1.getListing();
            this.comparatorListing2 = program2.getListing();
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            Address a1 = (Address)obj1;
            Address a2 = (Address)obj2;
            Address address2CompatibleWith1 = SimpleDiffUtility.getCompatibleAddress((Program)this.program2, (Address)a2, (Program)this.program1);
            return a1.compareTo((Object)address2CompatibleWith1);
        }

        @Override
        public boolean isSame(Object obj1, Object obj2) {
            Address a1 = (Address)obj1;
            Address a2 = (Address)obj2;
            String c1 = this.comparatorListing1.getComment(this.type, a1);
            String c2 = this.comparatorListing2.getComment(this.type, a2);
            return SystemUtilities.isEqual((Object)c1, (Object)c2);
        }

        @Override
        public AddressSet getAddressSet(Object obj, Program program) {
            AddressSet addrs = new AddressSet();
            if (obj == null) {
                return addrs;
            }
            Address addr = (Address)obj;
            addrs.addRange(addr, addr);
            return addrs;
        }
    }

    private abstract class CodeUnitComparator
    extends ProgramDiffComparatorImpl {
        private CodeUnitComparator(Program program1, Program program2) {
            super(program1, program2);
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            CodeUnit cu1 = (CodeUnit)obj1;
            CodeUnit cu2 = (CodeUnit)obj2;
            Address min2CompatibleWith1 = SimpleDiffUtility.getCompatibleAddress((Program)this.program2, (Address)cu2.getMinAddress(), (Program)this.program1);
            return cu1.getMinAddress().compareTo((Object)min2CompatibleWith1);
        }

        @Override
        public abstract boolean isSame(Object var1, Object var2);

        @Override
        public AddressSet getAddressSet(Object obj, Program program) {
            AddressSet addrSet = new AddressSet();
            if (obj == null) {
                return addrSet;
            }
            CodeUnit cu = (CodeUnit)obj;
            addrSet.addRange(cu.getMinAddress(), cu.getMaxAddress());
            return addrSet;
        }
    }

    private class FunctionComparator
    extends ProgramDiffComparatorImpl {
        private FunctionComparator(Program program1, Program program2) {
            super(program1, program2);
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            Function f1 = (Function)obj1;
            Function f2 = (Function)obj2;
            Address entryPt2CompatibleWith1 = SimpleDiffUtility.getCompatibleAddress((Program)this.program2, (Address)f2.getEntryPoint(), (Program)this.program1);
            return f1.getEntryPoint().compareTo((Object)entryPt2CompatibleWith1);
        }

        @Override
        public boolean isSame(Object obj1, Object obj2) {
            Function f1 = (Function)obj1;
            Function f2 = (Function)obj2;
            return ProgramDiff.equivalentFunctions(f1, f2);
        }

        @Override
        public AddressSet getAddressSet(Object obj, Program program) {
            AddressSet addrs = new AddressSet();
            if (obj == null) {
                return addrs;
            }
            Function f = (Function)obj;
            Address addr = f.getEntryPoint();
            if (addr != null) {
                addrs.addRange(addr, addr);
            }
            return addrs;
        }
    }

    private class BookmarksComparator
    extends ProgramDiffComparatorImpl {
        BookmarkManager bm1;
        BookmarkManager bm2;
        BookmarkType type;

        private BookmarksComparator(BookmarkType type, Program program1, Program program2) {
            super(program1, program2);
            this.type = type;
            this.bm1 = program1.getBookmarkManager();
            this.bm2 = program2.getBookmarkManager();
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            Address a1 = (Address)obj1;
            Address a2 = (Address)obj2;
            Address address2CompatibleWith1 = SimpleDiffUtility.getCompatibleAddress((Program)this.program2, (Address)a2, (Program)this.program1);
            return a1.compareTo((Object)address2CompatibleWith1);
        }

        @Override
        public boolean isSame(Object obj1, Object obj2) {
            Bookmark[] marks2;
            Address a1 = (Address)obj1;
            Address a2 = (Address)obj2;
            Address address2CompatibleWith1 = SimpleDiffUtility.getCompatibleAddress((Program)this.program2, (Address)a2, (Program)this.program1);
            if (!a1.equals((Object)address2CompatibleWith1)) {
                throw new AssertException("Can only diff bookmarks at same address.");
            }
            Bookmark[] marks1 = this.bm1.getBookmarks(a1, this.type.getTypeString());
            if (marks1.length != (marks2 = this.bm2.getBookmarks(a2, this.type.getTypeString())).length) {
                return false;
            }
            Arrays.sort(marks1, BOOKMARK_COMPARATOR);
            Arrays.sort(marks2, BOOKMARK_COMPARATOR);
            for (int i = 0; i < marks1.length; ++i) {
                if (marks1[i].getCategory().equals(marks2[i].getCategory()) && marks1[i].getComment().equals(marks2[i].getComment())) continue;
                return false;
            }
            return true;
        }

        @Override
        public AddressSet getAddressSet(Object obj, Program program) {
            AddressSet addrs = new AddressSet();
            if (obj == null) {
                return addrs;
            }
            Address addr = (Address)obj;
            CodeUnit cu = program.getListing().getCodeUnitContaining(addr);
            if (cu != null) {
                addrs.addRange(cu.getMinAddress(), cu.getMaxAddress());
            }
            return addrs;
        }
    }

    private class EquateComparator
    extends ProgramDiffComparatorImpl {
        private EquateComparator(Program program1, Program program2) {
            super(program1, program2);
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            Address a1 = (Address)obj1;
            Address a2 = (Address)obj2;
            Address address2CompatibleWith1 = SimpleDiffUtility.getCompatibleAddress((Program)this.program2, (Address)a2, (Program)this.program1);
            return a1.compareTo((Object)address2CompatibleWith1);
        }

        @Override
        public boolean isSame(Object obj1, Object obj2) {
            Address a1 = (Address)obj1;
            for (int opIndex = 0; opIndex < 16; ++opIndex) {
                if (ProgramDiff.this.isSameOperandEquates(a1, opIndex)) continue;
                return false;
            }
            return true;
        }

        @Override
        public AddressSet getAddressSet(Object obj, Program program) {
            AddressSet addrs = new AddressSet();
            if (obj == null) {
                return addrs;
            }
            Address addr = (Address)obj;
            addrs.addRange(addr, addr);
            return addrs;
        }
    }

    private class SymbolComparator
    extends ProgramDiffComparatorImpl {
        private SymbolComparator(Program program1, Program program2) {
            super(program1, program2);
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            Symbol s1 = (Symbol)obj1;
            Symbol s2 = (Symbol)obj2;
            Address address2CompatibleWith1 = SimpleDiffUtility.getCompatibleAddress((Program)this.program2, (Address)s2.getAddress(), (Program)this.program1);
            return s1.getAddress().compareTo((Object)address2CompatibleWith1);
        }

        @Override
        public boolean isSame(Object obj1, Object obj2) {
            Symbol[] sym2;
            Symbol s1 = (Symbol)obj1;
            Symbol s2 = (Symbol)obj2;
            if (s1.isExternalEntryPoint() != s2.isExternalEntryPoint()) {
                return false;
            }
            Symbol[] sym1 = this.program1.getSymbolTable().getSymbols(s1.getAddress());
            if (sym1.length != (sym2 = this.program2.getSymbolTable().getSymbols(s2.getAddress())).length) {
                return false;
            }
            SymbolNameComparator snc = new SymbolNameComparator();
            Arrays.sort(sym1, snc);
            Arrays.sort(sym2, snc);
            for (int i = 0; i < sym1.length; ++i) {
                if (ProgramDiff.equivalentSymbols(this.program1, this.program2, sym1[i], sym2[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public AddressSet getAddressSet(Object obj, Program program) {
            AddressSet addrs = new AddressSet();
            if (obj == null) {
                return addrs;
            }
            Symbol s = (Symbol)obj;
            Address addr = s.getAddress();
            addrs.addRange(addr, addr);
            return addrs;
        }
    }

    static abstract class ProgramDiffComparatorImpl
    implements ProgramDiffComparator {
        protected Program program1;
        protected Program program2;

        public ProgramDiffComparatorImpl(Program program1, Program program2) {
            this.program1 = program1;
            this.program2 = program2;
        }

        @Override
        public Program getProgramOne() {
            return this.program1;
        }

        @Override
        public Program getProgramTwo() {
            return this.program2;
        }
    }

    private static interface ProgramDiffComparator {
        public Program getProgramOne();

        public Program getProgramTwo();

        public int compare(Object var1, Object var2);

        public boolean isSame(Object var1, Object var2);

        public AddressSet getAddressSet(Object var1, Program var2);
    }
}

