/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.utils.Utils;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;

public class OpBehaviorIntCarry
extends BinaryOpBehavior {
    public OpBehaviorIntCarry() {
        super(21);
    }

    @Override
    public long evaluateBinary(int sizeout, int sizein, long in1, long in2) {
        if (sizein == 8) {
            if (in1 < 0L) {
                return in2 < 0L || -in2 <= in1 ? 1L : 0L;
            }
            if (in2 < 0L) {
                return -in1 <= in2 ? 1L : 0L;
            }
        }
        return in1 > (in1 + in2 & Utils.calc_mask(sizein)) ? 1L : 0L;
    }

    @Override
    public BigInteger evaluateBinary(int sizeout, int sizein, BigInteger in1, BigInteger in2) {
        if (in1.signum() < 0 || in2.signum() < 0) {
            throw new AssertException("Expected unsigned in values");
        }
        BigInteger res = in1.compareTo(in1.add(in2).and(Utils.calc_bigmask(sizein))) > 0 ? BigInteger.ONE : BigInteger.ZERO;
        return res;
    }
}

