/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.BlockMap;
import ghidra.program.model.pcode.ListLinked;
import ghidra.program.model.pcode.PcodeBlock;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class PcodeBlockBasic
extends PcodeBlock {
    private ListLinked<PcodeOp> oplist;
    private AddressSet cover;

    PcodeBlockBasic() {
        this.blocktype = 1;
        this.oplist = new ListLinked();
        this.cover = new AddressSet();
    }

    @Override
    public Address getStart() {
        return this.cover.getMinAddress();
    }

    @Override
    public Address getStop() {
        return this.cover.getMaxAddress();
    }

    public boolean contains(Address addr) {
        return this.cover.contains(addr);
    }

    protected void insertBefore(Iterator<PcodeOp> iter, PcodeOp op) {
        PcodeOpAST opast = (PcodeOpAST)op;
        opast.setParent(this);
        Iterator<PcodeOp> newiter = this.oplist.insertBefore(iter, op);
        opast.setBasicIter(newiter);
    }

    protected void insertAfter(Iterator<PcodeOp> iter, PcodeOp op) {
        PcodeOpAST opast = (PcodeOpAST)op;
        opast.setParent(this);
        Iterator<PcodeOp> newiter = this.oplist.insertAfter(iter, opast);
        opast.setBasicIter(newiter);
    }

    protected void insertEnd(PcodeOp op) {
        PcodeOpAST opast = (PcodeOpAST)op;
        opast.setParent(this);
        Iterator<PcodeOp> newiter = this.oplist.add(opast);
        opast.setBasicIter(newiter);
    }

    protected void remove(PcodeOp op) {
        PcodeOpAST opast = (PcodeOpAST)op;
        opast.setParent(null);
        this.oplist.remove(op.getBasicIter());
    }

    public Iterator<PcodeOp> getIterator() {
        return this.oplist.iterator();
    }

    @Override
    public void saveXmlBody(Writer writer) throws IOException {
        writer.append("<rangelist>\n");
        AddressRangeIterator iter = this.cover.getAddressRanges(true);
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            StringBuilder buffer = new StringBuilder();
            buffer.append("<range");
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"space", (String)range.getAddressSpace().getName());
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buffer, (String)"first", (long)range.getMinAddress().getOffset());
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buffer, (String)"last", (long)range.getMaxAddress().getOffset());
            writer.append(buffer);
        }
        writer.append("</rangelist>\n");
    }

    @Override
    public void restoreXmlBody(XmlPullParser parser, BlockMap resolver) throws PcodeXMLException {
        AddressFactory addressFactory = resolver.getAddressFactory();
        XmlElement rangelistel = parser.start(new String[]{"rangelist"});
        while (parser.peek().isStart()) {
            XmlElement rangeel = parser.start(new String[]{"range"});
            String spc = rangeel.getAttribute("space");
            long offset = SpecXmlUtils.decodeLong((String)rangeel.getAttribute("first"));
            AddressSpace addressSpace = addressFactory.getAddressSpace(spc);
            Address start = addressSpace.getAddress(offset);
            offset = SpecXmlUtils.decodeLong((String)rangeel.getAttribute("last"));
            Address stop = addressSpace.getAddress(offset);
            this.cover.addRange(start, stop);
            parser.end(rangeel);
        }
        parser.end(rangelistel);
    }
}

