/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.util.DefaultPropertyMap;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.util.exception.NoValueException;
import ghidra.util.prop.IntPropertySet;
import ghidra.util.prop.PropertySet;

public class DefaultIntPropertyMap
extends DefaultPropertyMap
implements IntPropertyMap {
    private static final long serialVersionUID = 1L;
    private IntPropertySet ips;

    public DefaultIntPropertyMap(String name) {
        super((PropertySet)new IntPropertySet(name));
        this.ips = (IntPropertySet)this.propertyMgr;
    }

    @Override
    public void add(Address addr, int value) {
        this.ips.putInt(this.addrMap.getKey(addr), value);
    }

    @Override
    public int getInt(Address addr) throws NoValueException {
        return this.ips.getInt(this.addrMap.getKey(addr));
    }

    @Override
    public Object getObject(Address addr) {
        try {
            return new Integer(this.getInt(addr));
        }
        catch (NoValueException e) {
            return null;
        }
    }
}

