/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ExactVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.InverseVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.SubVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionRangeSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;

public class DefaultVersionSelectorScheme
implements VersionSelectorScheme {
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;
    private final FeaturePreviews featurePreviews;
    private boolean smartExcludeOnUpperBound;

    @Deprecated
    public DefaultVersionSelectorScheme(VersionComparator versionComparator) {
        this(versionComparator, new VersionParser(), null);
    }

    public DefaultVersionSelectorScheme(VersionComparator versionComparator, VersionParser versionParser) {
        this(versionComparator, versionParser, null);
    }

    public DefaultVersionSelectorScheme(VersionComparator versionComparator, VersionParser versionParser, FeaturePreviews featurePreviews) {
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
        this.featurePreviews = featurePreviews;
    }

    @Override
    public VersionSelector parseSelector(String selectorString) {
        if (VersionRangeSelector.ALL_RANGE.matcher(selectorString).matches()) {
            return this.maybeCreateRangeSelector(selectorString);
        }
        if (selectorString.endsWith("+")) {
            return new SubVersionSelector(selectorString);
        }
        if (selectorString.startsWith("latest.")) {
            return new LatestVersionSelector(selectorString);
        }
        return new ExactVersionSelector(selectorString);
    }

    private VersionSelector maybeCreateRangeSelector(String selectorString) {
        VersionRangeSelector rangeSelector = new VersionRangeSelector(selectorString, this.versionComparator.asVersionComparator(), this.versionParser, this.smartExcludeOnUpperBound);
        if (DefaultVersionSelectorScheme.isSingleVersionRange(rangeSelector)) {
            return new ExactVersionSelector(rangeSelector.getUpperBound());
        }
        return rangeSelector;
    }

    private static boolean isSingleVersionRange(VersionRangeSelector rangeSelector) {
        String lowerBound = rangeSelector.getLowerBound();
        return lowerBound != null && lowerBound.equals(rangeSelector.getUpperBound()) && rangeSelector.isLowerInclusive() && rangeSelector.isUpperInclusive();
    }

    @Override
    public String renderSelector(VersionSelector selector) {
        return selector.getSelector();
    }

    @Override
    public VersionSelector complementForRejection(VersionSelector selector) {
        return new InverseVersionSelector(selector);
    }

    public void configure() {
        if (this.featurePreviews != null && this.featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.VERSION_ORDERING_V2)) {
            this.smartExcludeOnUpperBound = true;
        }
    }
}

