/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.PluginUpdateChecker;
import net.i2p.router.update.PluginUpdateRunner;
import net.i2p.router.web.PluginStarter;
import net.i2p.update.Checker;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateTask;
import net.i2p.update.UpdateType;
import net.i2p.update.Updater;

class PluginUpdateHandler
implements Checker,
Updater {
    private final RouterContext _context;
    private final ConsoleUpdateManager _mgr;

    public PluginUpdateHandler(RouterContext ctx, ConsoleUpdateManager mgr) {
        this._context = ctx;
        this._mgr = mgr;
    }

    @Override
    public UpdateTask check(UpdateType type, UpdateMethod method, String appName, String currentVersion, long maxTime) {
        if (type != UpdateType.PLUGIN || method != UpdateMethod.HTTP || appName.length() <= 0) {
            return null;
        }
        Properties props = PluginStarter.pluginProperties(this._context, appName);
        String oldVersion = props.getProperty("version");
        String xpi2pURL = props.getProperty("updateURL.su3");
        if (xpi2pURL == null) {
            xpi2pURL = props.getProperty("updateURL");
        }
        List<URI> updateSources = null;
        if (xpi2pURL != null) {
            try {
                updateSources = Collections.singletonList(new URI(xpi2pURL));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (oldVersion == null || updateSources == null) {
            return null;
        }
        PluginUpdateChecker update = new PluginUpdateChecker(this._context, this._mgr, updateSources, appName, oldVersion);
        return update;
    }

    @Override
    public UpdateTask update(UpdateType type, UpdateMethod method, List<URI> updateSources, String appName, String newVersion, long maxTime) {
        if (type != UpdateType.PLUGIN || method != UpdateMethod.HTTP && method != UpdateMethod.FILE || updateSources.isEmpty()) {
            return null;
        }
        Properties props = PluginStarter.pluginProperties(this._context, appName);
        String oldVersion = props.getProperty("version");
        if (oldVersion == null) {
            oldVersion = "0";
        }
        PluginUpdateRunner update = new PluginUpdateRunner(this._context, this._mgr, updateSources, appName, oldVersion);
        this._mgr.notifyProgress(update, "<b>" + this._mgr._t("Updating") + "</b>");
        return update;
    }
}

