/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import net.i2p.data.DataHelper;

class GunzipOutputStream
extends InflaterOutputStream {
    private static final int FOOTER_SIZE = 8;
    private final CRC32 _crc32;
    private final byte[] _buf1 = new byte[1];
    private boolean _complete;
    private final byte[] _footer = new byte[8];
    private long _bytesReceived;
    private long _bytesReceivedAtCompletion;
    private HeaderState _state = HeaderState.MB1;
    private int _flags;
    private int _extHdrToRead;

    public GunzipOutputStream(OutputStream uncompressedStream) throws IOException {
        super(uncompressedStream, new Inflater(true));
        this._crc32 = new CRC32();
    }

    @Override
    public void write(int b) throws IOException {
        this._buf1[0] = (byte)b;
        this.write(this._buf1, 0, 1);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (this._complete) {
            return;
        }
        boolean isFinished = this.inf.finished();
        for (int i = off; i < off + len; ++i) {
            long footerSize;
            if (!isFinished) {
                if (this._state != HeaderState.DONE) {
                    this.verifyHeader(buf[i]);
                    continue;
                }
                super.write(buf, i, 1);
                if (this.inf.finished()) {
                    isFinished = true;
                    this._bytesReceivedAtCompletion = this._bytesReceived;
                }
            }
            this._footer[(int)(this._bytesReceived++ % 8L)] = buf[i];
            if (!isFinished || (footerSize = this._bytesReceivedAtCompletion - this._bytesReceived) < 7L) continue;
            try {
                this.verifyFooter();
                this.inf.reset();
                this._complete = true;
                return;
            }
            catch (IOException ioe) {
                if (footerSize == 7L && i < off + len - 1) continue;
                this._complete = true;
                throw ioe;
            }
        }
    }

    public long getTotalRead() {
        try {
            return this.inf.getBytesRead();
        }
        catch (RuntimeException e) {
            return 0L;
        }
    }

    public long getTotalExpanded() {
        try {
            return this.inf.getBytesWritten();
        }
        catch (RuntimeException e) {
            return 0L;
        }
    }

    public long getRemaining() {
        try {
            return this.inf.getRemaining();
        }
        catch (RuntimeException e) {
            return 0L;
        }
    }

    public boolean getFinished() {
        try {
            return this.inf.finished();
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    @Override
    public void close() throws IOException {
        this._complete = true;
        this._state = HeaderState.DONE;
        super.close();
    }

    public String toString() {
        return "GOS read: " + this.getTotalRead() + " expanded: " + this.getTotalExpanded() + " remaining: " + this.getRemaining() + " finished: " + this.getFinished();
    }

    private void verifyFooter() throws IOException {
        byte[] footer;
        int idx = (int)(this._bytesReceivedAtCompletion % 8L);
        if (idx == 0) {
            footer = this._footer;
        } else {
            footer = new byte[8];
            for (int i = 0; i < 8; ++i) {
                footer[i] = this._footer[(int)((this._bytesReceivedAtCompletion + (long)i) % 8L)];
            }
        }
        long actualSize = this.inf.getTotalOut();
        long expectedSize = DataHelper.fromLongLE(footer, 4, 4);
        if (expectedSize != actualSize) {
            throw new IOException("gunzip expected " + expectedSize + " bytes, got " + actualSize);
        }
        long actualCRC = this._crc32.getValue();
        long expectedCRC = DataHelper.fromLongLE(footer, 0, 4);
        if (expectedCRC != actualCRC) {
            throw new IOException("gunzip CRC fail expected 0x" + Long.toHexString(expectedCRC) + " bytes, got 0x" + Long.toHexString(actualCRC));
        }
    }

    private void verifyHeader(byte b) throws IOException {
        int c = b & 0xFF;
        switch (this._state) {
            case MB1: {
                if (c != 31) {
                    throw new IOException("First magic byte was wrong [" + c + "]");
                }
                this._state = HeaderState.MB2;
                break;
            }
            case MB2: {
                if (c != 139) {
                    throw new IOException("Second magic byte was wrong [" + c + "]");
                }
                this._state = HeaderState.CF;
                break;
            }
            case CF: {
                if (c != 8) {
                    throw new IOException("Compression format is invalid [" + c + "]");
                }
                this._state = HeaderState.FLAGS;
                break;
            }
            case FLAGS: {
                this._flags = c;
                this._state = HeaderState.MT0;
                break;
            }
            case MT0: {
                this._state = HeaderState.MT1;
                break;
            }
            case MT1: {
                this._state = HeaderState.MT2;
                break;
            }
            case MT2: {
                this._state = HeaderState.MT3;
                break;
            }
            case MT3: {
                this._state = HeaderState.EF;
                break;
            }
            case EF: {
                if (c != 0 && c != 2 && c != 4) {
                    throw new IOException("Invalid extended flags [" + c + "]");
                }
                this._state = HeaderState.OS;
                break;
            }
            case OS: {
                if (0 != (this._flags & 0x20)) {
                    this._state = HeaderState.EH1;
                    break;
                }
                if (0 != (this._flags & 0x10)) {
                    this._state = HeaderState.NAME;
                    break;
                }
                if (0 != (this._flags & 8)) {
                    this._state = HeaderState.COMMENT;
                    break;
                }
                if (0 != (this._flags & 0x40)) {
                    this._state = HeaderState.CRC1;
                    break;
                }
                this._state = HeaderState.DONE;
                break;
            }
            case EH1: {
                this._extHdrToRead = c;
                this._state = HeaderState.EH2;
                break;
            }
            case EH2: {
                this._extHdrToRead += c << 8;
                if (this._extHdrToRead > 0) {
                    this._state = HeaderState.EHDATA;
                } else if (0 != (this._flags & 0x10)) {
                    this._state = HeaderState.NAME;
                }
                if (0 != (this._flags & 8)) {
                    this._state = HeaderState.COMMENT;
                    break;
                }
                if (0 != (this._flags & 0x40)) {
                    this._state = HeaderState.CRC1;
                    break;
                }
                this._state = HeaderState.DONE;
                break;
            }
            case EHDATA: {
                if (--this._extHdrToRead > 0) break;
                if (0 != (this._flags & 0x10)) {
                    this._state = HeaderState.NAME;
                }
                if (0 != (this._flags & 8)) {
                    this._state = HeaderState.COMMENT;
                    break;
                }
                if (0 != (this._flags & 0x40)) {
                    this._state = HeaderState.CRC1;
                    break;
                }
                this._state = HeaderState.DONE;
                break;
            }
            case NAME: {
                if (c != 0) break;
                if (0 != (this._flags & 8)) {
                    this._state = HeaderState.COMMENT;
                    break;
                }
                if (0 != (this._flags & 0x40)) {
                    this._state = HeaderState.CRC1;
                    break;
                }
                this._state = HeaderState.DONE;
                break;
            }
            case COMMENT: {
                if (c != 0) break;
                if (0 != (this._flags & 0x40)) {
                    this._state = HeaderState.CRC1;
                    break;
                }
                this._state = HeaderState.DONE;
                break;
            }
            case CRC1: {
                this._state = HeaderState.CRC2;
                break;
            }
            case CRC2: {
                this._state = HeaderState.DONE;
                break;
            }
        }
    }

    private static enum HeaderState {
        MB1,
        MB2,
        CF,
        MT0,
        MT1,
        MT2,
        MT3,
        EF,
        OS,
        FLAGS,
        EH1,
        EH2,
        EHDATA,
        NAME,
        COMMENT,
        CRC1,
        CRC2,
        DONE;

    }
}

