/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread.strategy;

import java.io.Closeable;
import java.util.concurrent.Executor;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.strategy.ExecutingExecutionStrategy;

public class ExecuteProduceConsume
extends ExecutingExecutionStrategy
implements ExecutionStrategy,
Runnable {
    private static final Logger LOG = Log.getLogger(ExecuteProduceConsume.class);
    private final Locker _locker = new Locker();
    private final Runnable _runExecute = new RunExecute();
    private final ExecutionStrategy.Producer _producer;
    private final ThreadPool _threadPool;
    private boolean _idle = true;
    private boolean _execute;
    private boolean _producing;
    private boolean _pending;
    private boolean _lowThreads;

    public ExecuteProduceConsume(ExecutionStrategy.Producer producer, Executor executor) {
        super(executor);
        this._producer = producer;
        this._threadPool = executor instanceof ThreadPool ? (ThreadPool)executor : null;
    }

    @Deprecated
    public ExecuteProduceConsume(ExecutionStrategy.Producer producer, Executor executor, ExecutionStrategy lowResourceStrategy) {
        this(producer, executor);
    }

    @Override
    public void execute() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} execute", this);
        }
        boolean produce = false;
        try (Locker.Lock locked = this._locker.lock();){
            if (this._idle) {
                if (this._producing) {
                    throw new IllegalStateException();
                }
                this._producing = true;
                produce = true;
                this._idle = false;
            } else {
                this._execute = true;
            }
        }
        if (produce) {
            this.produceConsume();
        }
    }

    @Override
    public void dispatch() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} spawning", this);
        }
        boolean dispatch = false;
        try (Locker.Lock locked = this._locker.lock();){
            if (this._idle) {
                dispatch = true;
            } else {
                this._execute = true;
            }
        }
        if (dispatch) {
            this.execute(this._runExecute);
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} run", this);
        }
        boolean produce = false;
        try (Locker.Lock locked = this._locker.lock();){
            this._pending = false;
            if (!this._idle && !this._producing) {
                this._producing = true;
                produce = true;
            }
        }
        if (produce) {
            this.produceConsume();
        }
    }

    private void produceConsume() {
        if (this._threadPool != null && this._threadPool.isLowOnThreads() && !this.produceExecuteConsume()) {
            return;
        }
        this.executeProduceConsume();
    }

    public boolean isLowOnThreads() {
        return this._lowThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean produceExecuteConsume() {
        boolean bl;
        block15: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} enter low threads mode", this);
            }
            this._lowThreads = true;
            try {
                boolean idle = false;
                while (this._threadPool.isLowOnThreads()) {
                    Runnable task = this._producer.produce();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} produced {}", this._producer, task);
                    }
                    if (task == null) {
                        Locker.Lock locked = this._locker.lock();
                        try {
                            if (this._execute) {
                                this._execute = false;
                                this._producing = true;
                                this._idle = false;
                                continue;
                            }
                            this._producing = false;
                            this._idle = true;
                            idle = true;
                            break;
                        }
                        finally {
                            if (locked != null) {
                                locked.close();
                            }
                            continue;
                        }
                    }
                    this.executeProduct(task);
                }
                bl = !idle;
                this._lowThreads = false;
                if (!LOG.isDebugEnabled()) break block15;
            }
            catch (Throwable throwable) {
                this._lowThreads = false;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} exit low threads mode", this);
                }
                throw throwable;
            }
            LOG.debug("{} exit low threads mode", this);
        }
        return bl;
    }

    protected void executeProduct(Runnable task) {
        if (task instanceof ExecutionStrategy.Rejectable) {
            try {
                ((ExecutionStrategy.Rejectable)((Object)task)).reject();
                if (task instanceof Closeable) {
                    ((Closeable)((Object)task)).close();
                }
            }
            catch (Throwable x) {
                LOG.debug(x);
            }
        } else {
            this.execute(task);
        }
    }

    private void executeProduceConsume() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} produce enter", this);
        }
        while (true) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} producing", this);
            }
            Runnable task = this._producer.produce();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} produced {}", this, task);
            }
            boolean dispatch = false;
            Locker.Lock locked = this._locker.lock();
            try {
                this._producing = false;
                if (task == null) {
                    if (this._execute) {
                        this._idle = false;
                        this._producing = true;
                        this._execute = false;
                        continue;
                    }
                    this._idle = true;
                    break;
                }
                if (!this._pending) {
                    this._pending = true;
                    dispatch = true;
                }
                this._execute = false;
            }
            finally {
                if (locked == null) continue;
                locked.close();
                continue;
            }
            if (dispatch) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} dispatch", this);
                }
                if (!this.execute(this)) {
                    task = null;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} run {}", this, task);
            }
            if (task != null) {
                task.run();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} ran {}", this, task);
            }
            locked = this._locker.lock();
            try {
                if (this._producing || this._idle) break;
                this._producing = true;
                continue;
            }
            finally {
                if (locked == null) continue;
                locked.close();
                continue;
            }
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} produce exit", this);
        }
    }

    public Boolean isIdle() {
        try (Locker.Lock locked = this._locker.lock();){
            Boolean bl = this._idle;
            return bl;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EPC ");
        try (Locker.Lock locked = this._locker.lock();){
            builder.append(this._idle ? "Idle/" : "");
            builder.append(this._producing ? "Prod/" : "");
            builder.append(this._pending ? "Pend/" : "");
            builder.append(this._execute ? "Exec/" : "");
        }
        builder.append(this._producer);
        return builder.toString();
    }

    public static class Factory
    implements ExecutionStrategy.Factory {
        @Override
        public ExecutionStrategy newExecutionStrategy(ExecutionStrategy.Producer producer, Executor executor) {
            return new ExecuteProduceConsume(producer, executor);
        }
    }

    private class RunExecute
    implements Runnable {
        private RunExecute() {
        }

        @Override
        public void run() {
            ExecuteProduceConsume.this.execute();
        }
    }
}

