/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.servlet.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.VersionComparator;

public class JspC {
    private static final String THREADS_VERSION_8 = "8.5.33";
    private static final String THREADS_VERSION_9 = "9.0.11";
    private static final boolean REPRODUCIBLE = Boolean.valueOf(System.getProperty("build.reproducible"));
    private static final boolean SYSTEM_TOMCAT = Boolean.valueOf(System.getProperty("with-libtomcat8-java")) != false || Boolean.valueOf(System.getProperty("with-libtomcat9-java")) != false;
    private static final String JASPER_JAR = System.getProperty("jasper.jar");

    public static void main(String[] args) {
        if (REPRODUCIBLE) {
            args = JspC.fixupArgs(args);
        }
        try {
            String cls = "org.apache.jasper.JspC";
            Class<?> c = Class.forName(cls, true, ClassLoader.getSystemClassLoader());
            Method main = c.getMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String[] fixupArgs(String[] args) {
        Object[] files;
        ArrayList<String> largs = new ArrayList<String>(32);
        String sdir = null;
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a.equals("-webapp")) {
                if (++i >= args.length) {
                    throw new IllegalArgumentException("no value for -webapp");
                }
                if (sdir != null) {
                    throw new IllegalArgumentException("multiple -webapp args");
                }
                sdir = args[i];
                largs.add("-uriroot");
                largs.add(sdir);
                continue;
            }
            largs.add(a);
        }
        if (sdir == null) {
            return args;
        }
        File dir = new File(sdir);
        if (!dir.exists()) {
            throw new IllegalArgumentException("webapp dir does not exist: " + sdir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + sdir);
        }
        boolean supportsThreads = false;
        if (SYSTEM_TOMCAT) {
            String ver;
            Attributes atts;
            if (JASPER_JAR != null && (atts = JspC.attributes(JASPER_JAR)) != null && (ver = atts.getValue("Implementation-Version")) != null) {
                supportsThreads = ver.startsWith("8.") ? VersionComparator.comp((String)ver, (String)THREADS_VERSION_8) >= 0 : VersionComparator.comp((String)ver, (String)THREADS_VERSION_9) >= 0;
                System.out.println("Found JspC version: " + ver + ", supports threads? " + supportsThreads);
            }
        } else {
            supportsThreads = true;
        }
        if (supportsThreads) {
            largs.add("-threadCount");
            largs.add("1");
        }
        if ((files = dir.listFiles((FileFilter)new FileSuffixFilter(".jsp"))) == null || files.length == 0) {
            throw new IllegalArgumentException("no jsp files in webapp dir: " + sdir);
        }
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            largs.add(((File)files[i]).getName());
        }
        System.out.println("JspC arguments for reproducible build: " + largs);
        String[] rv = new String[largs.size()];
        rv = largs.toArray(rv);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes attributes(String f) {
        InputStream in = null;
        try {
            in = new URL("jar:file:" + f + "!/META-INF/MANIFEST.MF").openStream();
            Manifest man = new Manifest(in);
            Attributes attributes = man.getMainAttributes();
            return attributes;
        }
        catch (IOException ioe) {
            Attributes attributes = null;
            return attributes;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

