"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importStar(require("react"));
var fast_deep_equal_1 = require("../../utils/fast_deep_equal");
var color_1 = require("./color");
var extra_1 = require("./extra");
var label_1 = require("./label");
var utils_1 = require("./utils");
exports.LEGEND_HIERARCHY_MARGIN = 10;
function renderLegendItem(item, props, totalItems, index) {
    var key = item.seriesIdentifier.key, childId = item.childId;
    return (react_1.default.createElement(LegendListItem, { key: key + "-" + childId + "-" + index, item: item, totalItems: totalItems, position: props.position, colorPicker: props.colorPicker, action: props.action, extraValues: props.extraValues, showExtra: props.showExtra, toggleDeselectSeriesAction: props.toggleDeselectSeriesAction, mouseOutAction: props.mouseOutAction, mouseOverAction: props.mouseOverAction, clearTemporaryColorsAction: props.clearTemporaryColorsAction, setTemporaryColorAction: props.setTemporaryColorAction, setPersistedColorAction: props.setPersistedColorAction, onMouseOver: props.onMouseOver, onMouseOut: props.onMouseOut, onClick: props.onClick }));
}
exports.renderLegendItem = renderLegendItem;
var LegendListItem = (function (_super) {
    __extends(LegendListItem, _super);
    function LegendListItem() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.colorRef = react_1.createRef();
        _this.state = {
            isOpen: false,
            actionActive: false,
        };
        _this.handleColorClick = function (changable) {
            return changable
                ? function (event) {
                    event.stopPropagation();
                    _this.toggleIsOpen();
                }
                : undefined;
        };
        _this.toggleIsOpen = function () {
            _this.setState(function (_a) {
                var isOpen = _a.isOpen;
                return ({ isOpen: !isOpen });
            });
        };
        _this.onLegendItemMouseOver = function () {
            var _a = _this.props, onMouseOver = _a.onMouseOver, mouseOverAction = _a.mouseOverAction, item = _a.item;
            if (onMouseOver) {
                onMouseOver(item.seriesIdentifier);
            }
            mouseOverAction(item.seriesIdentifier.key);
        };
        _this.onLegendItemMouseOut = function () {
            var _a = _this.props, onMouseOut = _a.onMouseOut, mouseOutAction = _a.mouseOutAction;
            if (onMouseOut) {
                onMouseOut();
            }
            mouseOutAction();
        };
        _this.handleLabelClick = function (legendItemId) {
            var _a = _this.props, item = _a.item, onClick = _a.onClick, toggleDeselectSeriesAction = _a.toggleDeselectSeriesAction;
            if (!item.isToggleable && !onClick) {
                return;
            }
            return function (_a) {
                var shiftKey = _a.shiftKey;
                if (onClick) {
                    onClick(legendItemId);
                }
                if (item.isToggleable) {
                    toggleDeselectSeriesAction(legendItemId, shiftKey);
                }
            };
        };
        return _this;
    }
    LegendListItem.prototype.shouldComponentUpdate = function (nextProps, nextState) {
        return !fast_deep_equal_1.deepEqual(this.props, nextProps) || !fast_deep_equal_1.deepEqual(this.state, nextState);
    };
    LegendListItem.prototype.renderColorPicker = function () {
        var _this = this;
        var _a = this.props, ColorPicker = _a.colorPicker, item = _a.item, clearTemporaryColorsAction = _a.clearTemporaryColorsAction, setTemporaryColorAction = _a.setTemporaryColorAction, setPersistedColorAction = _a.setPersistedColorAction;
        var seriesIdentifier = item.seriesIdentifier, color = item.color;
        var handleClose = function () {
            setPersistedColorAction(seriesIdentifier.key, color);
            clearTemporaryColorsAction();
            _this.toggleIsOpen();
        };
        if (ColorPicker && this.state.isOpen && this.colorRef.current) {
            return (react_1.default.createElement(ColorPicker, { anchor: this.colorRef.current, color: color, onClose: handleClose, onChange: function (color) { return setTemporaryColorAction(seriesIdentifier.key, color); }, seriesIdentifier: seriesIdentifier }));
        }
    };
    LegendListItem.prototype.render = function () {
        var _a;
        var _b = this.props, extraValues = _b.extraValues, item = _b.item, showExtra = _b.showExtra, colorPicker = _b.colorPicker, position = _b.position, totalItems = _b.totalItems, Action = _b.action;
        var color = item.color, isSeriesHidden = item.isSeriesHidden, isItemHidden = item.isItemHidden, seriesIdentifier = item.seriesIdentifier, label = item.label;
        var itemClassNames = classnames_1.default('echLegendItem', "echLegendItem--" + position, {
            'echLegendItem--hidden': isSeriesHidden,
            'echLegendItem__extra--hidden': isItemHidden,
        });
        var hasColorPicker = Boolean(colorPicker);
        var extra = utils_1.getExtra(extraValues, item, totalItems);
        var style = item.depth
            ? {
                marginLeft: exports.LEGEND_HIERARCHY_MARGIN * (_a = item.depth, (_a !== null && _a !== void 0 ? _a : 0)),
            }
            : undefined;
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("li", { className: itemClassNames, onMouseEnter: this.onLegendItemMouseOver, onMouseLeave: this.onLegendItemMouseOut, style: style, "data-ech-series-name": label },
                react_1.default.createElement(color_1.Color, { ref: this.colorRef, color: color, isSeriesHidden: isSeriesHidden, hasColorPicker: hasColorPicker, onClick: this.handleColorClick(hasColorPicker) }),
                react_1.default.createElement(label_1.Label, { label: label, onClick: this.handleLabelClick(seriesIdentifier) }),
                showExtra && extra != null && extra_1.renderExtra(extra, isSeriesHidden),
                Action && (react_1.default.createElement("div", { className: "echLegendItem__action" },
                    react_1.default.createElement(Action, { series: seriesIdentifier, color: color, label: label })))),
            this.renderColorPicker()));
    };
    LegendListItem.displayName = 'LegendItem';
    return LegendListItem;
}(react_1.Component));
exports.LegendListItem = LegendListItem;
//# sourceMappingURL=legend_item.js.map