/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkFenceGetFdInfoKHR;
import org.lwjgl.vulkan.VkImportFenceFdInfoKHR;

public class KHRExternalFenceFd {
    public static final int VK_KHR_EXTERNAL_FENCE_FD_SPEC_VERSION = 1;
    public static final String VK_KHR_EXTERNAL_FENCE_FD_EXTENSION_NAME = "VK_KHR_external_fence_fd";
    public static final int VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR = 1000115000;
    public static final int VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR = 1000115001;

    protected KHRExternalFenceFd() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_EXTERNAL_FENCE_FD_EXTENSION_NAME) && VK.checkExtension(VK_KHR_EXTERNAL_FENCE_FD_EXTENSION_NAME, VK.isSupported(provider, "vkImportFenceFdKHR", caps) && VK.isSupported(provider, "vkGetFenceFdKHR", caps));
    }

    public static int nvkImportFenceFdKHR(VkDevice device, long pImportFenceFdInfo) {
        long __functionAddress = device.getCapabilities().vkImportFenceFdKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)device.address(), (long)pImportFenceFdInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkImportFenceFdKHR(VkDevice device, @NativeType(value="VkImportFenceFdInfoKHR const *") VkImportFenceFdInfoKHR pImportFenceFdInfo) {
        return KHRExternalFenceFd.nvkImportFenceFdKHR(device, pImportFenceFdInfo.address());
    }

    public static int nvkGetFenceFdKHR(VkDevice device, long pGetFdInfo, long pFd) {
        long __functionAddress = device.getCapabilities().vkGetFenceFdKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)device.address(), (long)pGetFdInfo, (long)pFd, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetFenceFdKHR(VkDevice device, @NativeType(value="VkFenceGetFdInfoKHR const *") VkFenceGetFdInfoKHR pGetFdInfo, @NativeType(value="int *") IntBuffer pFd) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pFd, (int)1);
        }
        return KHRExternalFenceFd.nvkGetFenceFdKHR(device, pGetFdInfo.address(), MemoryUtil.memAddress((IntBuffer)pFd));
    }

    @NativeType(value="VkResult")
    public static int vkGetFenceFdKHR(VkDevice device, @NativeType(value="VkFenceGetFdInfoKHR const *") VkFenceGetFdInfoKHR pGetFdInfo, @NativeType(value="int *") int[] pFd) {
        long __functionAddress = device.getCapabilities().vkGetFenceFdKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pFd, (int)1);
        }
        return JNI.callPPPI((long)device.address(), (long)pGetFdInfo.address(), (int[])pFd, (long)__functionAddress);
    }
}

