/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLBusAddressAMD;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class AMDBusAddressableMemory {
    public static final int CL_MEM_BUS_ADDRESSABLE_AMD = 0x40000000;
    public static final int CL_MEM_EXTERNAL_PHYSICAL_AMD = Integer.MIN_VALUE;
    public static final int CL_COMMAND_WAIT_SIGNAL_AMD = 16512;
    public static final int CL_COMMAND_WRITE_SIGNAL_AMD = 16513;
    public static final int CL_COMMAND_MAKE_BUFFERS_RESIDENT_AMD = 16514;

    protected AMDBusAddressableMemory() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.clEnqueueWaitSignalAMD, caps.clEnqueueWriteSignalAMD, caps.clEnqueueMakeBuffersResidentAMD});
    }

    public static int nclEnqueueWaitSignalAMD(long command_queue, long mem_object, int value, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueWaitSignalAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
            Checks.check((long)mem_object);
        }
        return JNI.callPPPPI((long)command_queue, (long)mem_object, (int)value, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWaitSignalAMD(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long mem_object, @NativeType(value="cl_uint") int value, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return AMDBusAddressableMemory.nclEnqueueWaitSignalAMD(command_queue, mem_object, value, Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueWriteSignalAMD(long command_queue, long mem_object, int value, long offset, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueWriteSignalAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
            Checks.check((long)mem_object);
        }
        return JNI.callPPJPPI((long)command_queue, (long)mem_object, (int)value, (long)offset, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteSignalAMD(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long mem_object, @NativeType(value="cl_uint") int value, @NativeType(value="cl_ulong") long offset, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return AMDBusAddressableMemory.nclEnqueueWriteSignalAMD(command_queue, mem_object, value, offset, Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueMakeBuffersResidentAMD(long command_queue, int num_mem_objs, long mem_objects, int blocking_make_resident, long bus_addresses, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueMakeBuffersResidentAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPPPI((long)command_queue, (int)num_mem_objs, (long)mem_objects, (int)blocking_make_resident, (long)bus_addresses, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueMakeBuffersResidentAMD(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem const *") PointerBuffer mem_objects, @NativeType(value="cl_bool") boolean blocking_make_resident, @NativeType(value="cl_bus_address_amd *") CLBusAddressAMD.Buffer bus_addresses, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)bus_addresses, (int)mem_objects.remaining());
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return AMDBusAddressableMemory.nclEnqueueMakeBuffersResidentAMD(command_queue, mem_objects.remaining(), MemoryUtil.memAddress((CustomBuffer)mem_objects), blocking_make_resident ? 1 : 0, bus_addresses.address(), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }
}

