/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * smoothstep(-1.9, -0.6333333, -2.0) => 0.0
 * smoothstep(-1.9, -0.6333333, -0.6666667) => 0.9979589
 * smoothstep(-1.9, -0.6333333, 0.6666667) => 1.0
 * smoothstep(-1.9, -0.6333333, 2.0) => 1.0
 * smoothstep(-1.9, 0.6333333, -2.0) => 0.0
 * smoothstep(-1.9, 0.6333333, -0.6666667) => 0.4802677
 * smoothstep(-1.9, 0.6333333, 0.6666667) => 1.0
 * smoothstep(-1.9, 0.6333333, 2.0) => 1.0
 * smoothstep(-1.9, 1.9, -2.0) => 0.0
 * smoothstep(-1.9, 1.9, -0.6666667) => 0.24764164
 * smoothstep(-1.9, 1.9, 0.6666667) => 0.7523584
 * smoothstep(-1.9, 1.9, 2.0) => 1.0
 * smoothstep(-0.6333333, 0.6333333, -2.0) => 0.0
 * smoothstep(-0.6333333, 0.6333333, -0.6666667) => 0.0
 * smoothstep(-0.6333333, 0.6333333, 0.6666667) => 1.0
 * smoothstep(-0.6333333, 0.6333333, 2.0) => 1.0
 * smoothstep(-0.6333333, 1.9, -2.0) => 0.0
 * smoothstep(-0.6333333, 1.9, -0.6666667) => 0.0
 * smoothstep(-0.6333333, 1.9, 0.6666667) => 0.5197323
 * smoothstep(-0.6333333, 1.9, 2.0) => 1.0
 * smoothstep(0.6333333, 1.9, -2.0) => 0.0
 * smoothstep(0.6333333, 1.9, -0.6666667) => 0.0
 * smoothstep(0.6333333, 1.9, 0.6666667) => 0.0020411173
 * smoothstep(0.6333333, 1.9, 2.0) => 1.0
 */
#version 120

void main()
{
  float[distance(smoothstep(-1.9, -0.6333333, -2.0), 0.0) <= 0.0 ? 1 : -1] array0;
  float[distance(smoothstep(-1.9, -0.6333333, -0.6666667), 0.9979589) <= 9.979589e-06 ? 1 : -1] array1;
  float[distance(smoothstep(-1.9, -0.6333333, 0.6666667), 1.0) <= 1e-05 ? 1 : -1] array2;
  float[distance(smoothstep(-1.9, -0.6333333, 2.0), 1.0) <= 1e-05 ? 1 : -1] array3;
  float[distance(smoothstep(-1.9, 0.6333333, -2.0), 0.0) <= 0.0 ? 1 : -1] array4;
  float[distance(smoothstep(-1.9, 0.6333333, -0.6666667), 0.4802677) <= 4.802677e-06 ? 1 : -1] array5;
  float[distance(smoothstep(-1.9, 0.6333333, 0.6666667), 1.0) <= 1e-05 ? 1 : -1] array6;
  float[distance(smoothstep(-1.9, 0.6333333, 2.0), 1.0) <= 1e-05 ? 1 : -1] array7;
  float[distance(smoothstep(-1.9, 1.9, -2.0), 0.0) <= 0.0 ? 1 : -1] array8;
  float[distance(smoothstep(-1.9, 1.9, -0.6666667), 0.24764164) <= 2.4764163e-06 ? 1 : -1] array9;
  float[distance(smoothstep(-1.9, 1.9, 0.6666667), 0.7523584) <= 7.5235835e-06 ? 1 : -1] array10;
  float[distance(smoothstep(-1.9, 1.9, 2.0), 1.0) <= 1e-05 ? 1 : -1] array11;
  float[distance(smoothstep(-0.6333333, 0.6333333, -2.0), 0.0) <= 0.0 ? 1 : -1] array12;
  float[distance(smoothstep(-0.6333333, 0.6333333, -0.6666667), 0.0) <= 0.0 ? 1 : -1] array13;
  float[distance(smoothstep(-0.6333333, 0.6333333, 0.6666667), 1.0) <= 1e-05 ? 1 : -1] array14;
  float[distance(smoothstep(-0.6333333, 0.6333333, 2.0), 1.0) <= 1e-05 ? 1 : -1] array15;
  float[distance(smoothstep(-0.6333333, 1.9, -2.0), 0.0) <= 0.0 ? 1 : -1] array16;
  float[distance(smoothstep(-0.6333333, 1.9, -0.6666667), 0.0) <= 0.0 ? 1 : -1] array17;
  float[distance(smoothstep(-0.6333333, 1.9, 0.6666667), 0.5197323) <= 5.197323e-06 ? 1 : -1] array18;
  float[distance(smoothstep(-0.6333333, 1.9, 2.0), 1.0) <= 1e-05 ? 1 : -1] array19;
  float[distance(smoothstep(0.6333333, 1.9, -2.0), 0.0) <= 0.0 ? 1 : -1] array20;
  float[distance(smoothstep(0.6333333, 1.9, -0.6666667), 0.0) <= 0.0 ? 1 : -1] array21;
  float[distance(smoothstep(0.6333333, 1.9, 0.6666667), 0.0020411173) <= 2.0411173e-08 ? 1 : -1] array22;
  float[distance(smoothstep(0.6333333, 1.9, 2.0), 1.0) <= 1e-05 ? 1 : -1] array23;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length());
}
