/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySetGenerator;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActivateEncryptionAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public boolean equals(Object o) {
        return o instanceof ActivateEncryptionAction;
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        KeySet keySet;
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        try {
            keySet = KeySetGenerator.generateKeySet(tlsContext);
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("The specified Algorithm is not supported", ex);
        }
        LOGGER.debug("Setting new Cipher in RecordLayer");
        RecordCipher recordCipher = RecordCipherFactory.getRecordCipher(tlsContext, keySet);
        tlsContext.getRecordLayer().setRecordCipher(recordCipher);
        tlsContext.getRecordLayer().updateDecryptionCipher();
        tlsContext.setReadSequenceNumber(0L);
        tlsContext.getRecordLayer().updateEncryptionCipher();
        tlsContext.setWriteSequenceNumber(0L);
        LOGGER.info("Activated Encryption/Decryption");
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.setExecuted(false);
        this.setExecuted(null);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

