/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.jxls.util.JxlsHelper;
import org.traccar.Context;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.reports.ReportUtils;
import org.traccar.reports.model.SummaryReport;

public final class Summary {
    private Summary() {
    }

    private static SummaryReport calculateSummaryResult(long deviceId, Collection<Position> positions) {
        SummaryReport result = new SummaryReport();
        result.setDeviceId(deviceId);
        result.setDeviceName(Context.getIdentityManager().getById(deviceId).getName());
        if (positions != null && !positions.isEmpty()) {
            long durationMilliseconds;
            Position firstPosition = null;
            Position previousPosition = null;
            for (Position position : positions) {
                if (firstPosition == null) {
                    firstPosition = position;
                }
                previousPosition = position;
                if (!(position.getSpeed() > result.getMaxSpeed())) continue;
                result.setMaxSpeed(position.getSpeed());
            }
            boolean ignoreOdometer = Context.getDeviceManager().lookupAttributeBoolean(deviceId, "report.ignoreOdometer", false, false, true);
            result.setDistance(ReportUtils.calculateDistance(firstPosition, previousPosition, !ignoreOdometer));
            result.setSpentFuel(ReportUtils.calculateFuel(firstPosition, previousPosition));
            if (firstPosition.getAttributes().containsKey("hours") && previousPosition.getAttributes().containsKey("hours")) {
                durationMilliseconds = previousPosition.getLong("hours") - firstPosition.getLong("hours");
                result.setEngineHours(durationMilliseconds);
            } else {
                durationMilliseconds = previousPosition.getFixTime().getTime() - firstPosition.getFixTime().getTime();
            }
            if (durationMilliseconds > 0L) {
                result.setAverageSpeed(UnitsConverter.knotsFromMps(result.getDistance() * 1000.0 / (double)durationMilliseconds));
            }
            if (!ignoreOdometer && firstPosition.getDouble("odometer") != 0.0 && previousPosition.getDouble("odometer") != 0.0) {
                result.setStartOdometer(firstPosition.getDouble("odometer"));
                result.setEndOdometer(previousPosition.getDouble("odometer"));
            } else {
                result.setStartOdometer(firstPosition.getDouble("totalDistance"));
                result.setEndOdometer(previousPosition.getDouble("totalDistance"));
            }
            result.setStartTime(firstPosition.getFixTime());
            result.setEndTime(previousPosition.getFixTime());
        }
        return result;
    }

    private static int getDay(long userId, Date date) {
        Calendar calendar = Calendar.getInstance(ReportUtils.getTimezone(userId));
        calendar.setTime(date);
        return calendar.get(5);
    }

    private static Collection<SummaryReport> calculateSummaryResults(long userId, long deviceId, Date from, Date to, boolean daily) throws SQLException {
        ArrayList<Position> positions = new ArrayList<Position>(Context.getDataManager().getPositions(deviceId, from, to));
        ArrayList<SummaryReport> results = new ArrayList<SummaryReport>();
        if (daily && !positions.isEmpty()) {
            int startIndex = 0;
            int startDay = Summary.getDay(userId, positions.iterator().next().getFixTime());
            for (int i = 0; i < positions.size(); ++i) {
                int currentDay = Summary.getDay(userId, positions.get(i).getFixTime());
                if (currentDay == startDay) continue;
                results.add(Summary.calculateSummaryResult(deviceId, positions.subList(startIndex, i)));
                startIndex = i;
                startDay = currentDay;
            }
            results.add(Summary.calculateSummaryResult(deviceId, positions.subList(startIndex, positions.size())));
        } else {
            results.add(Summary.calculateSummaryResult(deviceId, positions));
        }
        return results;
    }

    public static Collection<SummaryReport> getObjects(long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Date from, Date to, boolean daily) throws SQLException {
        ReportUtils.checkPeriodLimit(from, to);
        ArrayList<SummaryReport> result = new ArrayList<SummaryReport>();
        for (long deviceId : ReportUtils.getDeviceList(deviceIds, groupIds)) {
            Context.getPermissionsManager().checkDevice(userId, deviceId);
            result.addAll(Summary.calculateSummaryResults(userId, deviceId, from, to, daily));
        }
        return result;
    }

    public static void getExcel(OutputStream outputStream, long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Date from, Date to, boolean daily) throws SQLException, IOException {
        ReportUtils.checkPeriodLimit(from, to);
        Collection<SummaryReport> summaries = Summary.getObjects(userId, deviceIds, groupIds, from, to, daily);
        String templatePath = Context.getConfig().getString("report.templatesPath", "templates/export/");
        try (FileInputStream inputStream = new FileInputStream(templatePath + "/summary.xlsx");){
            org.jxls.common.Context jxlsContext = ReportUtils.initializeContext(userId);
            jxlsContext.putVar("summaries", summaries);
            jxlsContext.putVar("from", (Object)from);
            jxlsContext.putVar("to", (Object)to);
            JxlsHelper.getInstance().setUseFastFormulaProcessor(false).processTemplate((InputStream)inputStream, outputStream, jxlsContext);
        }
    }
}

