/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;

public class VariantURLPath
implements Variant {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final List<NameValuePair> stringParam = new ArrayList<NameValuePair>();

    @Override
    public void setMessage(HttpMessage msg) {
        try {
            if (msg.getRequestHeader().getURI().getPath() != null) {
                String[] paths = msg.getRequestHeader().getURI().getPath().toString().split("/");
                int i = 0;
                for (String path : paths) {
                    if (path.length() > 0) {
                        this.stringParam.add(new NameValuePair(16, path, path, i));
                    }
                    ++i;
                }
            }
        }
        catch (URIException uRIException) {
            // empty catch block
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.stringParam;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, true);
    }

    private String getEscapedValue(String value) {
        if (value != null) {
            try {
                return URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "";
    }

    private String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value, boolean escaped) {
        try {
            URI uri = msg.getRequestHeader().getURI();
            Object[] paths = msg.getRequestHeader().getURI().getPath().toString().split("/");
            if (originalPair.getPosition() < paths.length) {
                String encodedValue;
                paths[originalPair.getPosition()] = encodedValue = escaped ? value : this.getEscapedValue(value);
                String path = StringUtils.join((Object[])paths, (String)"/");
                try {
                    uri.setEscapedPath(path);
                }
                catch (URIException e) {
                    uri.setPath(path);
                }
            }
        }
        catch (URIException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return value;
    }
}

