/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.launcher.daemon.protocol.Cancel;

public class DaemonCancelForwarder
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DaemonCancelForwarder.class);
    private final Runnable cancellationCallback;
    private final BuildCancellationToken cancellationToken;

    public DaemonCancelForwarder(final Dispatch<? super Cancel> dispatch, BuildCancellationToken cancellationToken) {
        this.cancellationToken = cancellationToken;
        this.cancellationCallback = new Runnable(){

            @Override
            public void run() {
                LOGGER.info("Request daemon to cancel build...");
                dispatch.dispatch((Object)new Cancel());
            }
        };
    }

    public void start() {
        this.cancellationToken.addCallback(this.cancellationCallback);
    }

    @Override
    public void stop() {
        this.cancellationToken.removeCallback(this.cancellationCallback);
    }
}

