/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.xml.sax.InputSource;

public class ResourceDataInputSource
extends InputSource {
    private static final Log logger = LogFactory.getLog(ResourceDataInputSource.class);
    private ResourceData data;
    private long version;
    private ResourceManager caller;

    public ResourceDataInputSource(ResourceData data, ResourceManager caller) throws ResourceLoadingException {
        if (data == null) {
            throw new NullPointerException("Data must not be null");
        }
        if (caller == null) {
            throw new NullPointerException("ResourceManager must not be null");
        }
        this.data = data;
        this.version = data.getVersion(caller);
        this.caller = caller;
        URL url = caller.toURL(data.getKey());
        if (url != null) {
            this.setSystemId(url.toExternalForm());
        }
    }

    @Override
    public void setByteStream(InputStream byteStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getByteStream() {
        try {
            return this.data.getResourceAsStream(this.caller);
        }
        catch (ResourceLoadingException e) {
            logger.error((Object)("Unable to create byte-stream: " + this.data.getKey()));
            return null;
        }
    }

    public ResourceData getData() {
        return this.data;
    }

    public long getVersion() {
        return this.version;
    }
}

