/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.TK_Session;
import com.gitlab.pdftk_java.pdftk;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pdftk.com.lowagie.text.Rectangle;
import pdftk.com.lowagie.text.pdf.PRStream;
import pdftk.com.lowagie.text.pdf.PdfAnnotation;
import pdftk.com.lowagie.text.pdf.PdfArray;
import pdftk.com.lowagie.text.pdf.PdfDictionary;
import pdftk.com.lowagie.text.pdf.PdfFileSpecification;
import pdftk.com.lowagie.text.pdf.PdfIndirectReference;
import pdftk.com.lowagie.text.pdf.PdfName;
import pdftk.com.lowagie.text.pdf.PdfNameTree;
import pdftk.com.lowagie.text.pdf.PdfNumber;
import pdftk.com.lowagie.text.pdf.PdfObject;
import pdftk.com.lowagie.text.pdf.PdfReader;
import pdftk.com.lowagie.text.pdf.PdfString;
import pdftk.com.lowagie.text.pdf.PdfWriter;

class attachments {
    TK_Session session;
    String m_output_filename;
    ArrayList<String> m_input_attach_file_filename;
    int m_input_attach_file_pagenum;
    String m_input_attach_file_relation;
    boolean m_ask_about_warnings_b;

    attachments(TK_Session session) {
        this.session = session;
        this.m_output_filename = session.m_output_filename;
        this.m_input_attach_file_filename = session.m_input_attach_file_filename;
        this.m_input_attach_file_pagenum = session.m_input_attach_file_pagenum;
        this.m_input_attach_file_relation = session.m_input_attach_file_relation;
        this.m_ask_about_warnings_b = session.m_ask_about_warnings_b;
    }

    static String drop_path(String ss) {
        int loc = ss.lastIndexOf(File.separatorChar);
        if (loc != -1 && loc != ss.length() - 1) {
            return ss.substring(loc + 1);
        }
        return ss;
    }

    static String normalize_pathname(String output_pathname) {
        if (output_pathname == "PROMPT") {
            output_pathname = pdftk.prompt_for_filename("Please enter the directory where you want attachments unpacked:");
        }
        if (output_pathname.lastIndexOf(File.separatorChar) == output_pathname.length() - 1) {
            return output_pathname;
        }
        return output_pathname + File.separatorChar;
    }

    static void unpack_file(PdfReader input_reader_p, PdfDictionary filespec_p, String output_pathname, boolean ask_about_warnings_b) {
        PdfObject type_p = PdfReader.getPdfObject(filespec_p.get(PdfName.TYPE));
        if (type_p != null && (type_p.equals(PdfName.FILESPEC) || type_p.equals(PdfName.F))) {
            PdfObject ef_p = PdfReader.getPdfObject(filespec_p.get(PdfName.EF));
            if (ef_p != null && ef_p.isDictionary()) {
                PdfObject fn_p = PdfReader.getPdfObject(filespec_p.get(PdfName.UF));
                if (fn_p == null) {
                    fn_p = PdfReader.getPdfObject(filespec_p.get(PdfName.F));
                }
                if (fn_p != null && fn_p.isString()) {
                    PdfObject f_p;
                    String fn_str = ((PdfString)fn_p).toUnicodeString();
                    String fn = attachments.drop_path(fn_str);
                    if (!output_pathname.isEmpty()) {
                        fn = output_pathname + fn;
                    }
                    if ((f_p = PdfReader.getPdfObject(((PdfDictionary)ef_p).get(PdfName.F))) != null && f_p.isStream()) {
                        try {
                            byte[] bytes_p = PdfReader.getStreamBytes((PRStream)f_p);
                            if (ask_about_warnings_b && pdftk.file_exists(fn) && !pdftk.confirm_overwrite(fn)) {
                                System.out.println("   Skipping: " + fn);
                                return;
                            }
                            FileOutputStream ofs = new FileOutputStream(fn);
                            ofs.write(bytes_p);
                            ofs.close();
                        }
                        catch (IOException e) {
                            System.err.println("Error: unable to create the file:");
                            System.err.println("   " + fn);
                            System.err.println("   Skipping.");
                        }
                    }
                }
            }
        }
    }

    void attach_files(PdfReader input_reader_p, PdfWriter writer_p) throws IOException {
        if (!this.m_input_attach_file_filename.isEmpty()) {
            if (this.m_input_attach_file_pagenum == -1) {
                System.out.println("Please enter the page number you want to attach these files to.");
                System.out.println("   The first page is 1.  The final page is \"end\".");
                System.out.println("   To attach files at the document level, just press Enter.");
                Scanner s = new Scanner(System.in);
                String buff = s.nextLine();
                if (buff.isEmpty()) {
                    this.m_input_attach_file_pagenum = 0;
                }
                if (buff.equals("end")) {
                    this.m_input_attach_file_pagenum = input_reader_p.getNumberOfPages();
                } else {
                    Pattern p = Pattern.compile("([0-9]*).*");
                    Matcher m = p.matcher(buff);
                    m.matches();
                    try {
                        this.m_input_attach_file_pagenum = Integer.valueOf(m.group(1));
                    }
                    catch (NumberFormatException e) {
                        this.m_input_attach_file_pagenum = 0;
                    }
                }
            } else if (this.m_input_attach_file_pagenum == -2) {
                this.m_input_attach_file_pagenum = input_reader_p.getNumberOfPages();
            }
            if (this.m_input_attach_file_pagenum != 0) {
                int trans = 27;
                int margin = 18;
                if (0 < this.m_input_attach_file_pagenum && this.m_input_attach_file_pagenum <= input_reader_p.getNumberOfPages()) {
                    PdfDictionary page_p = input_reader_p.getPageN(this.m_input_attach_file_pagenum);
                    if (page_p != null && page_p.isDictionary()) {
                        Rectangle crop_box_p = input_reader_p.getCropBox(this.m_input_attach_file_pagenum);
                        float corner_top = crop_box_p.top() - 18.0f;
                        float corner_left = crop_box_p.left() + 18.0f;
                        PdfObject annots_po = PdfReader.getPdfObject(page_p.get(PdfName.ANNOTS));
                        boolean annots_new_b = false;
                        if (annots_po == null) {
                            annots_po = new PdfArray();
                            annots_new_b = true;
                        }
                        if (annots_po.isArray()) {
                            Object annot_bbox_p;
                            PdfArray annots_p = (PdfArray)annots_po;
                            ArrayList annots_array_p = annots_p.getArrayList();
                            for (PdfObject ii : annots_array_p) {
                                ArrayList bbox_array_p;
                                PdfObject annot_p = PdfReader.getPdfObject(ii);
                                if (annot_p == null || !annot_p.isDictionary()) continue;
                                annot_bbox_p = PdfReader.getPdfObject(((PdfDictionary)annot_p).get(PdfName.RECT));
                                if (annot_bbox_p == null || !((PdfObject)annot_bbox_p).isArray() || (bbox_array_p = ((PdfArray)annot_bbox_p).getArrayList()).size() != 4) continue;
                                corner_top = ((PdfNumber)bbox_array_p.get(1)).floatValue();
                                corner_left = ((PdfNumber)bbox_array_p.get(2)).floatValue();
                            }
                            for (String vit : this.m_input_attach_file_filename) {
                                if (vit.equals("PROMPT")) {
                                    vit = pdftk.prompt_for_filename("Please enter a filename for attachment:");
                                }
                                String filename = attachments.drop_path(vit);
                                if (crop_box_p.right() < corner_left + 27.0f) {
                                    corner_left = crop_box_p.left() + 18.0f;
                                }
                                if (corner_top - 27.0f < crop_box_p.bottom()) {
                                    corner_top = crop_box_p.top() - 18.0f;
                                }
                                annot_bbox_p = new Rectangle(corner_left, corner_top - 27.0f, corner_left + 27.0f, corner_top);
                                PdfAnnotation annot_p = PdfAnnotation.createFileAttachment(writer_p, (Rectangle)annot_bbox_p, filename, null, vit, filename);
                                PdfIndirectReference ref_p = writer_p.addToBody(annot_p).getIndirectReference();
                                annots_p.add(ref_p);
                                corner_left += 27.0f;
                                corner_top -= 27.0f;
                            }
                            if (annots_new_b) {
                                PdfIndirectReference ref_p = writer_p.addToBody(annots_p).getIndirectReference();
                                page_p.put(PdfName.ANNOTS, ref_p);
                            }
                        }
                    } else {
                        System.err.println("Internal Error: unable to get page dictionary");
                    }
                } else {
                    System.err.print("Error: page number " + this.m_input_attach_file_pagenum);
                    System.err.println(" is not present in the input PDF.");
                }
            } else {
                PdfDictionary catalog_p = input_reader_p.catalog;
                if (catalog_p != null && catalog_p.isDictionary()) {
                    PdfObject names_po = PdfReader.getPdfObject(catalog_p.get(PdfName.NAMES));
                    boolean names_new_b = false;
                    PdfObject af_po = PdfReader.getPdfObject(catalog_p.get(new PdfName("AF")));
                    boolean af_new_b = false;
                    if (names_po == null) {
                        names_po = new PdfDictionary();
                        names_new_b = true;
                    }
                    if (af_po == null) {
                        af_po = new PdfArray();
                        af_new_b = true;
                    }
                    if (names_po != null && names_po.isDictionary() && af_po != null && af_po.isArray()) {
                        PdfDictionary names_p = (PdfDictionary)names_po;
                        PdfArray af_p = (PdfArray)af_po;
                        PdfObject emb_files_tree_p = PdfReader.getPdfObject(names_p.get(PdfName.EMBEDDEDFILES));
                        HashMap<String, PdfIndirectReference> emb_files_map_p = null;
                        boolean emb_files_tree_new_b = false;
                        if (emb_files_tree_p != null) {
                            emb_files_map_p = PdfNameTree.readTree((PdfDictionary)emb_files_tree_p);
                        } else {
                            emb_files_map_p = new HashMap<String, PdfIndirectReference>();
                            emb_files_tree_new_b = true;
                        }
                        for (String vit : this.m_input_attach_file_filename) {
                            if (vit.equals("PROMPT")) {
                                vit = pdftk.prompt_for_filename("Please enter a filename for attachment:");
                            }
                            String filename = attachments.drop_path(vit);
                            PdfFileSpecification filespec_p = null;
                            try {
                                filespec_p = PdfFileSpecification.fileEmbedded(writer_p, vit, filename, null);
                                filespec_p.put(new PdfName("AFRelationship"), new PdfName(this.m_input_attach_file_relation));
                            }
                            catch (IOException ioe_p) {
                                System.err.println("Error: Failed to open attachment file: ");
                                System.err.println("   " + vit);
                                System.err.println("   Skipping this file.");
                                continue;
                            }
                            PdfIndirectReference ref_p = writer_p.addToBody(filespec_p).getIndirectReference();
                            String key_p = vit;
                            int counter = 1;
                            while (emb_files_map_p.containsKey(key_p)) {
                                key_p = vit + "-" + counter;
                                ++counter;
                            }
                            emb_files_map_p.put(key_p, ref_p);
                            af_p.add(ref_p);
                        }
                        if (!emb_files_map_p.isEmpty()) {
                            PdfIndirectReference ref_p;
                            PdfDictionary emb_files_tree_new_p = PdfNameTree.writeTree(emb_files_map_p, writer_p);
                            if (emb_files_tree_new_b && emb_files_tree_new_p != null) {
                                ref_p = writer_p.addToBody(emb_files_tree_new_p).getIndirectReference();
                                names_p.put(PdfName.EMBEDDEDFILES, ref_p);
                            } else if (emb_files_tree_p != null && emb_files_tree_new_p != null) {
                                ((PdfDictionary)emb_files_tree_p).merge(emb_files_tree_new_p);
                            } else {
                                System.err.println("Internal Error: no valid EmbeddedFiles tree to add to PDF.");
                            }
                            if (names_new_b) {
                                ref_p = writer_p.addToBody(names_p).getIndirectReference();
                                catalog_p.put(PdfName.NAMES, ref_p);
                            }
                            if (af_new_b) {
                                catalog_p.put(new PdfName("AF"), af_p);
                            }
                        }
                    } else {
                        System.err.println("Internal Error: couldn't read or create PDF Names dictionary.");
                    }
                } else {
                    System.err.println("Internal Error: couldn't read input PDF Root dictionary.");
                    System.err.println("   File attachment failed; no new files attached to output.");
                }
            }
        }
    }

    void unpack_files(PdfReader input_reader_p) {
        String output_pathname = attachments.normalize_pathname(this.m_output_filename);
        PdfDictionary catalog_p = input_reader_p.catalog;
        if (catalog_p != null && catalog_p.isDictionary()) {
            PdfObject names_p = PdfReader.getPdfObject(catalog_p.get(PdfName.NAMES));
            if (names_p != null && names_p.isDictionary()) {
                PdfObject emb_files_tree_p = PdfReader.getPdfObject(((PdfDictionary)names_p).get(PdfName.EMBEDDEDFILES));
                HashMap emb_files_map_p = null;
                if (emb_files_tree_p != null && emb_files_tree_p.isDictionary()) {
                    emb_files_map_p = PdfNameTree.readTree((PdfDictionary)emb_files_tree_p);
                    for (PdfObject value_p : emb_files_map_p.values()) {
                        PdfObject filespec_p = PdfReader.getPdfObject(value_p);
                        if (filespec_p == null || !filespec_p.isDictionary()) continue;
                        attachments.unpack_file(input_reader_p, (PdfDictionary)filespec_p, output_pathname, this.m_ask_about_warnings_b);
                    }
                }
            }
        }
        int num_pages = input_reader_p.getNumberOfPages();
        for (int ii = 1; ii <= num_pages; ++ii) {
            PdfDictionary page_p = input_reader_p.getPageN(ii);
            if (page_p == null || !page_p.isDictionary()) continue;
            PdfObject annots_p = PdfReader.getPdfObject(page_p.get(PdfName.ANNOTS));
            if (annots_p == null || !annots_p.isArray()) continue;
            ArrayList annots_array_p = ((PdfArray)annots_p).getArrayList();
            for (PdfObject jj : annots_array_p) {
                PdfObject annot_po = PdfReader.getPdfObject(jj);
                if (annot_po == null || !annot_po.isDictionary()) continue;
                PdfDictionary annot_p = (PdfDictionary)annot_po;
                PdfObject subtype_p = PdfReader.getPdfObject(annot_p.get(PdfName.SUBTYPE));
                if (subtype_p == null || !subtype_p.equals(PdfName.FILEATTACHMENT)) continue;
                PdfObject filespec_p = PdfReader.getPdfObject(annot_p.get(PdfName.FS));
                if (filespec_p == null || !filespec_p.isDictionary()) continue;
                attachments.unpack_file(input_reader_p, (PdfDictionary)filespec_p, output_pathname, this.m_ask_about_warnings_b);
            }
        }
    }
}

