#!/usr/bin/env python
# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.4 on Sun Nov 20 15:23:13 2005

__author__  = 'www.stani.be'
__license__ = 'GPL'
__doc__ = """
Demo & test script for sm.wxp.realtime.TreeCtrl (SPE widget)

This module was orignally developed for SPE - Stani's Python Editor

Homepage:   http://pythonide.stani.be
Email:      spe.stani.be@gmail.com
Copyright:  (c) 2005 www.stani.be
License:    GPL (contact me for other licenses)

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by the 
Free Software Foundation; either version 2 of the License, or any later 
version.

This program is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place, Suite 330, Boston, MA 02111-1307 USA    
"""

import wx
from _spe.sm.wxp.realtime import TreeCtrl
#from wx import TreeCtrl #to compare

class Frame(wx.Frame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: Frame.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.statusbar = self.CreateStatusBar(1, 0)
        self.treeCtrl = TreeCtrl(self, -1)
        self.source = wx.TextCtrl(self, -1, "class Dummy:\n    def hello_world()\n    def goodbye()\nclass Colors:\n    def red()\n    def blue()", style=wx.TE_MULTILINE)

        self.__set_properties()
        self.__do_layout()
        # end wxGlade
        self.finish()
        
    def __set_properties(self):
        # begin wxGlade: Frame.__set_properties
        self.SetTitle("Realtime TreeCtrl Demo - SPE widget")
        self.SetSize((400, 300))
        self.statusbar.SetStatusWidths([-1])
        # statusbar fields
        statusbar_fields = ["Right click on any item to display its line number in the statusbar."]
        for i in range(len(statusbar_fields)):
            self.statusbar.SetStatusText(statusbar_fields[i], i)
        self.source.SetBackgroundColour(wx.Colour(255, 135, 127))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: Frame.__do_layout
        sizer = wx.BoxSizer(wx.HORIZONTAL)
        sizer.Add(self.treeCtrl, 1, wx.EXPAND, 0)
        sizer.Add(self.source, 1, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        self.SetAutoLayout(True)
        self.SetSizer(sizer)
        self.Layout()
        # end wxGlade
        
    def finish(self):
        self.root   = self.treeCtrl.AddRoot('Root')
        #difference between wx.TreeCtrl and realtime.TreeCtrl
        if hasattr(self.root,'wx'):
            self.rootId = self.root.wx
        else:
            self.rootId = self.root
        self.Bind(wx.EVT_IDLE,self.onIdle)
        self.Bind(wx.EVT_TREE_ITEM_RIGHT_CLICK,self.onRightClick)

    def onIdle(self,event):
        source = self.source.GetValue().split('\n')
        #mark begin
        self.treeCtrl.CollapseAndReset(self.root) 
        hierarchy   = [(-1,self.root)]
        for index,line in enumerate(source):
            label       = line.lstrip()
            #hierarchy based on left whitespace
            level       = len(line)-len(label) 
            for nodeIndex, node in enumerate(hierarchy):
                treeItemLevel, treeItem = node
                if treeItemLevel<level: break
            item        = self.treeCtrl.AppendItem(treeItem,label,data=wx.TreeItemData(index))
            hierarchy   = hierarchy[nodeIndex:]
            hierarchy.insert(0,(level,item))
        #expand, if necessary
        self.treeCtrl.Expand(self.root) 
        #only update real changes to avoid flickering
        self.treeCtrl.Update()
        
    def onRightClick(self,event):
        item    = event.GetItem()
        if item == self.rootId: #!!!! not self.root
            message = 'The root has not a corresponding line.'
        else:
            label   = self.treeCtrl.GetItemText(item)
            index   = self.treeCtrl.GetPyData(item)+1
            message = 'This item [%s] is on line %s.'%(label,index)
        self.SetStatusText(message)

# end of class Frame


class App(wx.App):
    def OnInit(self):
        wx.InitAllImageHandlers()
        frame = Frame(None, -1, "")
        self.SetTopWindow(frame)
        frame.Show()
        return 1

# end of class App

if __name__ == "__main__":
    app = App(0)
    app.MainLoop()
