/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notificators.Notificator;

public class NotificatorTelegram
extends Notificator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificatorTelegram.class);
    private final String url = String.format("https://api.telegram.org/bot%s/sendMessage", Context.getConfig().getString(Keys.NOTIFICATOR_TELEGRAM_KEY));
    private final String chatId = Context.getConfig().getString(Keys.NOTIFICATOR_TELEGRAM_CHAT_ID);

    @Override
    public void sendSync(long userId, Event event, Position position) {
        Message message = new Message();
        message.chatId = this.chatId;
        message.text = NotificationFormatter.formatShortMessage(userId, event, position);
        Context.getClient().target(this.url).request().async().post(Entity.json((Object)message), (InvocationCallback)new InvocationCallback<Object>(){

            public void completed(Object o) {
            }

            public void failed(Throwable throwable) {
                LOGGER.warn("Telegram API error", throwable);
            }
        });
    }

    @Override
    public void sendAsync(long userId, Event event, Position position) {
        this.sendSync(userId, event, position);
    }

    public static class Message {
        @JsonProperty(value="chat_id")
        private String chatId;
        @JsonProperty(value="text")
        private String text;
        @JsonProperty(value="parse_mode")
        private String parseMode = "html";
    }
}

