/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class GnxProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_LOCATION = new PatternBuilder().number("(d+),").number("d+,").expression("([01]),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(d),").number("(dd.d+),").expression("([NS]),").number("(ddd.d+),").expression("([EW]),").compile();
    private static final Pattern PATTERN_MIF = new PatternBuilder().text("$GNX_MIF,").expression(PATTERN_LOCATION.pattern()).expression("[01],").expression("([^,]+),").any().compile();
    private static final Pattern PATTERN_OTHER = new PatternBuilder().text("$GNX_").expression("...,").expression(PATTERN_LOCATION.pattern()).any().compile();

    public GnxProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        String type = sentence.substring(5, 8);
        Pattern pattern = type.equals("MIF") ? PATTERN_MIF : PATTERN_OTHER;
        Parser parser = new Parser(pattern, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        if (parser.nextInt(0) == 1) {
            position.set("archive", true);
        }
        position.setDeviceTime(parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY, "GMT+5:30"));
        position.setFixTime(parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY, "GMT+5:30"));
        position.setValid(parser.nextInt(0) != 0);
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        if (type.equals("MIF")) {
            position.set("driverUniqueId", parser.next());
        }
        return position;
    }
}

