/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.jvm;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.servicelocator.LiquibaseService;
import liquibase.util.JdbcUtils;

@LiquibaseService(skip=true)
public class HsqlConnection
extends JdbcConnection {
    public HsqlConnection() {
    }

    public HsqlConnection(Connection connection) {
        super(connection);
    }

    @Override
    public void commit() throws DatabaseException {
        super.commit();
        Statement st = null;
        try {
            st = this.createStatement();
            String sql = "CHECKPOINT";
            LogService.getLog(this.getClass()).debug(LogType.WRITE_SQL, "CHECKPOINT");
            st.execute("CHECKPOINT");
        }
        catch (SQLException e2) {
            throw new DatabaseException(e2);
        }
        finally {
            JdbcUtils.closeStatement(st);
        }
    }

    @Override
    public void rollback() throws DatabaseException {
        super.rollback();
        Statement st = null;
        try {
            st = this.createStatement();
            String sql = "CHECKPOINT";
            LogService.getLog(this.getClass()).debug(LogType.WRITE_SQL, "CHECKPOINT");
            st.execute("CHECKPOINT");
        }
        catch (SQLException e2) {
            throw new DatabaseException(e2);
        }
        finally {
            JdbcUtils.closeStatement(st);
        }
    }
}

